/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import java.awt.Color;
import java.util.HashSet;
import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.base.Node;
import y.base.NodeCursor;
import y.layout.router.BusDescriptor;
import y.layout.router.BusRouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.DoubleOptionItem;
import y.option.IntOptionItem;
import y.option.OptionGroup;
import y.option.OptionHandler;
import y.option.OptionItem;
import y.util.DataProviderAdapter;
import y.util.Maps;
import y.view.Graph2D;

public class BusRouterModule
extends LayoutModule {
    private static final String ph = "BUS_ROUTER";
    private static final String lh = "GROUP_LAYOUT";
    private static final String ai = "GROUP_SELECTION";
    private static final String th = "GROUP_ROUTING";
    private static final String kh = "ALL";
    private static final String jh = "BUSES";
    private static final String oh = "COLOR";
    private static final String wh = "CROSSING_COST";
    private static final String sh = "CROSSING_REROUTING";
    private static final String ci = "GRID_ENABLED";
    private static final String zh = "GRID_SPACING";
    private static final String uh = "MINIMUM_CONNECTIONS_COUNT";
    private static final String rh = "MINIMUM_BACKBONE_LENGTH";
    private static final String bi = "MIN_DISTANCE_TO_EDGES";
    private static final String mh = "MIN_DISTANCE_TO_NODES";
    private static final String nh = "PREFERRED_BACKBONE_COUNT";
    private static final String xh = "PARTIAL";
    private static final String yh = "SCOPE";
    private static final String qh = "SINGLE";
    private static final String ei = "SUBSET";
    private static final String di = "SUBSET_BUS";
    private final BusRouter vh = new BusRouter();
    protected boolean optionsLayout = true;
    protected boolean optionsSelection = true;
    protected boolean optionsRouting = true;

    public BusRouterModule() {
        super(ph, "yFiles Layout Team", "Routes edges in bus-style");
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(ph);
        this.addOptionItems(optionHandler);
        return optionHandler;
    }

    protected void addOptionItems(OptionHandler optionHandler) {
        OptionGroup optionGroup;
        OptionItem optionItem;
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        BusRouter busRouter = new BusRouter();
        if (this.optionsLayout) {
            optionHandler.addEnum(yh, new String[]{kh, ei, di, xh}, busRouter.getScope());
            optionHandler.addEnum(jh, new String[]{qh, oh}, 0);
            optionHandler.addBool(ci, busRouter.isGridRoutingEnabled());
            optionItem = optionHandler.addInt(zh, busRouter.getGridSpacing());
            optionItem.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
            optionItem = optionHandler.addInt(mh, busRouter.getMinimumDistanceToNode());
            optionItem.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
            optionItem = optionHandler.addInt(bi, busRouter.getMinimumDistanceToEdge());
            optionItem.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
            constraintManager.setEnabledOnValueEquals(ci, (Object)Boolean.TRUE, zh);
            optionGroup = new OptionGroup();
            optionGroup.setAttribute("OptionGroup.title", lh);
            optionGroup.addItem(optionHandler.getItem(yh));
            optionGroup.addItem(optionHandler.getItem(jh));
            optionGroup.addItem(optionHandler.getItem(ci));
            optionGroup.addItem(optionHandler.getItem(zh));
            optionGroup.addItem(optionHandler.getItem(mh));
            optionGroup.addItem(optionHandler.getItem(bi));
        }
        if (this.optionsSelection) {
            optionItem = optionHandler.addInt(nh, busRouter.getPreferredBackboneSegmentCount());
            optionItem.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
            optionItem = optionHandler.addDouble(rh, busRouter.getMinimumBackboneSegmentLength());
            optionItem.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(1.0));
            optionGroup = new OptionGroup();
            optionGroup.setAttribute("OptionGroup.title", ai);
            optionGroup.addItem(optionHandler.getItem(nh));
            optionGroup.addItem(optionHandler.getItem(rh));
        }
        if (this.optionsRouting) {
            optionItem = optionHandler.addDouble(wh, busRouter.getCrossingCost());
            optionItem.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(0.0));
            optionHandler.addBool(sh, busRouter.isReroutingEnabled());
            optionItem.setAttribute(DoubleOptionItem.ATTRIBUTE_MIN_VALUE, new Double(0.0));
            optionItem = optionHandler.addInt(uh, busRouter.getMinimumBusConnectionsCount());
            optionItem.setAttribute(IntOptionItem.ATTRIBUTE_MIN_VALUE, new Integer(1));
            optionGroup = new OptionGroup();
            optionGroup.setAttribute("OptionGroup.title", th);
            optionGroup.addItem(optionHandler.getItem(wh));
            optionGroup.addItem(optionHandler.getItem(sh));
            optionGroup.addItem(optionHandler.getItem(uh));
        }
        this.initOptionHandler(optionHandler, this.vh);
    }

    protected void initOptionHandler(OptionHandler optionHandler, BusRouter busRouter) {
        if (this.optionsLayout) {
            optionHandler.set(yh, BusRouterModule.b(busRouter.getScope()));
            optionHandler.set(ci, busRouter.isGridRoutingEnabled());
            optionHandler.set(zh, new Integer(busRouter.getGridSpacing()));
            optionHandler.set(mh, new Integer(busRouter.getMinimumDistanceToNode()));
            optionHandler.set(bi, new Integer(busRouter.getMinimumDistanceToEdge()));
        }
        if (this.optionsSelection) {
            optionHandler.set(wh, new Double(busRouter.getCrossingCost()));
            optionHandler.set(sh, busRouter.isReroutingEnabled());
        }
        if (this.optionsRouting) {
            optionHandler.set(nh, new Integer(busRouter.getPreferredBackboneSegmentCount()));
            optionHandler.set(uh, new Integer(busRouter.getMinimumBusConnectionsCount()));
            optionHandler.set(rh, new Double(busRouter.getMinimumBackboneSegmentLength()));
        }
    }

    public void configure(BusRouter busRouter) {
        OptionHandler optionHandler = this.getOptionHandler();
        if (this.optionsLayout) {
            busRouter.setScope(BusRouterModule.b(optionHandler.get(yh)));
            busRouter.setGridRoutingEnabled(optionHandler.getBool(ci));
            busRouter.setGridSpacing(optionHandler.getInt(zh));
            busRouter.setMinimumDistanceToNode(optionHandler.getInt(mh));
            busRouter.setMinimumDistanceToEdge(optionHandler.getInt(bi));
        }
        if (this.optionsSelection) {
            busRouter.setCrossingCost(optionHandler.getDouble(wh));
            busRouter.setReroutingEnabled(optionHandler.getBool(sh));
        }
        if (this.optionsRouting) {
            busRouter.setPreferredBackboneSegmentCount(optionHandler.getInt(nh));
            busRouter.setMinimumBusConnectionsCount(optionHandler.getInt(uh));
            busRouter.setMinimumBackboneSegmentLength(optionHandler.getDouble(rh));
        }
    }

    protected BusRouter getBusRouter() {
        return this.vh;
    }

    protected void mainrun() {
        this.launchLayouter(this.vh);
    }

    protected void init() {
        block11: {
            Object object;
            HashSet<Object> hashSet;
            Object object2;
            OptionHandler optionHandler;
            Graph2D graph2D;
            boolean bl;
            block14: {
                block10: {
                    block13: {
                        bl = YModule.z;
                        super.init();
                        this.configure(this.vh);
                        if (!this.optionsLayout) {
                            return;
                        }
                        graph2D = this.getGraph2D();
                        optionHandler = this.getOptionHandler();
                        boolean bl2 = oh.equals(optionHandler.get(jh));
                        boolean bl3 = xh.equals(optionHandler.get(yh));
                        EdgeMap edgeMap = Maps.createHashedEdgeMap();
                        graph2D.addDataProvider(BusRouter.EDGE_DESCRIPTOR_DPKEY, edgeMap);
                        Object object3 = object2 = ei.equals(optionHandler.get(yh)) ? graph2D.selectedEdges() : graph2D.edges();
                        while (object2.ok()) {
                            hashSet = object2.edge();
                            boolean bl4 = bl3 && !graph2D.isSelected(((Edge)((Object)hashSet)).source()) && !graph2D.isSelected(((Edge)((Object)hashSet)).target());
                            object = bl2 ? graph2D.getRealizer((Edge)((Object)hashSet)).getLineColor() : Color.BLACK;
                            edgeMap.set(hashSet, new BusDescriptor(object, bl4));
                            object2.next();
                            if (!bl) continue;
                        }
                        object2 = graph2D.getDataProvider(BusRouter.EDGE_DESCRIPTOR_DPKEY);
                        if (!ei.equals(optionHandler.get(yh))) break block13;
                        graph2D.addDataProvider(this.vh.getSelectedEdgesDpKey(), new DataProviderAdapter(){

                            public boolean getBool(Object object) {
                                return object instanceof Edge && graph2D.isSelected((Edge)object);
                            }
                        });
                        if (!bl) break block11;
                    }
                    if (!di.equals(optionHandler.get(yh))) break block14;
                    hashSet = new HashSet();
                    EdgeCursor edgeCursor = graph2D.selectedEdges();
                    while (edgeCursor.ok()) {
                        hashSet.add(((BusDescriptor)object2.get(edgeCursor.edge())).getID());
                        edgeCursor.next();
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block10;
                    }
                    graph2D.addDataProvider(this.vh.getSelectedEdgesDpKey(), new DataProviderAdapter((DataProvider)object2){
                        private final /* synthetic */ DataProvider val$descriptorDP;
                        {
                            this.val$descriptorDP = dataProvider;
                        }

                        public boolean getBool(Object object) {
                            return hashSet.contains(((BusDescriptor)this.val$descriptorDP.get(object)).getID());
                        }
                    });
                }
                if (!bl) break block11;
            }
            if (xh.equals(optionHandler.get(yh))) {
                hashSet = new HashSet<Object>();
                NodeCursor nodeCursor = graph2D.selectedNodes();
                while (nodeCursor.ok()) {
                    block12: {
                        object = nodeCursor.node();
                        if (bl) break block11;
                        EdgeCursor edgeCursor = ((Node)object).edges();
                        while (edgeCursor.ok()) {
                            hashSet.add(((BusDescriptor)object2.get(edgeCursor.edge())).getID());
                            edgeCursor.next();
                            if (!bl) {
                                if (!bl) continue;
                            }
                            break block12;
                        }
                        nodeCursor.next();
                    }
                    if (!bl) continue;
                }
                graph2D.addDataProvider(this.vh.getSelectedEdgesDpKey(), new DataProviderAdapter((DataProvider)object2){
                    private final /* synthetic */ DataProvider val$descriptorDP;
                    {
                        this.val$descriptorDP = dataProvider;
                    }

                    public boolean getBool(Object object) {
                        return hashSet.contains(((BusDescriptor)this.val$descriptorDP.get(object)).getID());
                    }
                });
            }
        }
    }

    protected void dispose() {
        if (this.optionsLayout) {
            this.getGraph2D().removeDataProvider(BusRouter.EDGE_DESCRIPTOR_DPKEY);
            if (!kh.equals(this.getOptionHandler().get(yh))) {
                this.getGraph2D().removeDataProvider(this.vh.getSelectedEdgesDpKey());
            }
        }
        super.dispose();
    }

    private static byte b(Object object) {
        if (kh.equals(object)) {
            return 0;
        }
        if (ei.equals(object) || di.equals(object) || xh.equals(object)) {
            return 1;
        }
        return 0;
    }

    private static String b(byte by) {
        if (0 == by) {
            return kh;
        }
        if (1 == by) {
            return ei;
        }
        throw new IllegalArgumentException("Unknown scope: " + by);
    }
}

