/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import javax.swing.SwingUtilities;
import y.anim.AnimationObject;
import y.anim.AnimationPlayer;
import y.layout.GraphLayout;
import y.layout.Layouter;
import y.module.YModule;
import y.view.Graph2D;
import y.view.Graph2DLayoutExecutor;
import y.view.Graph2DView;
import y.view.LayoutMorpher;

public abstract class LayoutModule
extends YModule {
    private Graph2DLayoutExecutor j;

    protected LayoutModule(String string2, String string3, String string4) {
        super(string2, string3, string4);
    }

    public Graph2DLayoutExecutor getLayoutExecutor() {
        if (this.j == null) {
            this.j = this.createLayoutExecutor();
        }
        return this.j;
    }

    protected Graph2DLayoutExecutor createLayoutExecutor() {
        Graph2DLayoutExecutor graph2DLayoutExecutor = new Graph2DLayoutExecutor(){

            protected AnimationPlayer createAnimationPlayer() {
                return LayoutModule.this.createAnimationPlayer();
            }

            protected LayoutMorpher createLayoutMorpher() {
                LayoutMorpher layoutMorpher = LayoutModule.this.createLayoutMorpher();
                if (layoutMorpher == null) {
                    layoutMorpher = super.createLayoutMorpher();
                }
                return layoutMorpher;
            }

            protected AnimationObject createAnimation(Graph2DView graph2DView, Graph2D graph2D, GraphLayout graphLayout) {
                return super.createAnimation(graph2DView, graph2D, graphLayout);
            }

            protected boolean useEventDispatchThread(Graph2DView graph2DView) {
                return LayoutModule.this.useEventDispatchThread();
            }
        };
        graph2DLayoutExecutor.getLayoutMorpher().setEasedExecution(true);
        graph2DLayoutExecutor.getLayoutMorpher().setSmoothViewTransform(true);
        graph2DLayoutExecutor.setMode((byte)3);
        graph2DLayoutExecutor.setPortIntersectionCalculatorEnabled(false);
        graph2DLayoutExecutor.setBackupRealizersEnabled(false);
        return graph2DLayoutExecutor;
    }

    public void setLayoutExecutor(Graph2DLayoutExecutor graph2DLayoutExecutor) {
        this.j = graph2DLayoutExecutor;
    }

    protected void launchLayouter(Layouter layouter) {
        this.launchLayouter(layouter, this.getLayoutExecutor().getMode() != 0);
    }

    protected void launchLayouter(Layouter layouter, boolean bl) {
        block10: {
            block9: {
                Graph2DView graph2DView;
                boolean bl2;
                block8: {
                    block7: {
                        bl2 = YModule.z;
                        if (bl) break block7;
                        this.getLayoutExecutor().setMode((byte)0);
                        if (!bl2) break block8;
                    }
                    if (this.getLayoutExecutor().getMode() == 0) {
                        this.getLayoutExecutor().setMode((byte)1);
                    }
                }
                if ((graph2DView = this.getGraph2DView()) == null) break block9;
                this.getLayoutExecutor().doLayout(graph2DView, layouter);
                if (!bl2) break block10;
            }
            this.getLayoutExecutor().doLayout(this.getGraph2D(), layouter);
        }
    }

    protected AnimationPlayer createAnimationPlayer() {
        return new AnimationPlayer();
    }

    protected LayoutMorpher createLayoutMorpher() {
        LayoutMorpher layoutMorpher = new LayoutMorpher();
        layoutMorpher.setPreferredDuration(300L);
        layoutMorpher.setEasedExecution(true);
        layoutMorpher.setSmoothViewTransform(true);
        return layoutMorpher;
    }

    protected boolean useEventDispatchThread() {
        if (SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        Graph2DView graph2DView = this.getGraph2DView();
        return graph2DView != null && graph2DView.isShowing();
    }

    public boolean isAbortable() {
        return true;
    }

    public void setBufferedMode(boolean bl) {
        block5: {
            block4: {
                if (bl) break block4;
                this.getLayoutExecutor().setMode((byte)0);
                if (!YModule.z) break block5;
            }
            if (this.getLayoutExecutor().getMode() == 0) {
                this.getLayoutExecutor().setMode((byte)3);
            }
        }
    }

    public boolean getBufferedMode() {
        return this.getLayoutExecutor().getMode() != 0;
    }

    public boolean isMorphingEnabled() {
        return this.getLayoutExecutor().getMode() == 3 || this.getLayoutExecutor().getMode() == 7;
    }

    public void setMorphingEnabled(boolean bl) {
        block5: {
            block4: {
                if (!bl) break block4;
                this.getLayoutExecutor().setMode((byte)3);
                if (!YModule.z) break block5;
            }
            if (this.isMorphingEnabled()) {
                this.getLayoutExecutor().setMode((byte)1);
            }
        }
    }

    public boolean isPortIntersectionCalculatorEnabled() {
        return this.getLayoutExecutor().isPortIntersectionCalculatorEnabled();
    }

    public void setPortIntersectionCalculatorEnabled(boolean bl) {
        this.getLayoutExecutor().setPortIntersectionCalculatorEnabled(bl);
    }
}

