/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.EdgeMap;
import y.layout.BendConverter;
import y.layout.CompositeLayoutStage;
import y.layout.LayoutStage;
import y.layout.SequentialLayouter;
import y.layout.grouping.GroupNodeHider;
import y.layout.organic.RemoveOverlapsLayoutStage;
import y.layout.router.OrganicEdgeRouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.OptionGroup;
import y.option.OptionHandler;
import y.view.Selections;

public class OrganicEdgeRouterModule
extends LayoutModule {
    private static final String gz = "ORGANIC_EDGE_ROUTER";
    private static final String lz = "MINIMAL_NODE_DISTANCE";
    private static final String kz = "USE_BENDS";
    private static final String mz = "ROUTE_ONLY_NECESSARY";
    private static final String hz = "SELECTION_ONLY";
    private static final String jz = "ALLOW_MOVING_NODES";
    private static final String iz = "LAYOUT_OPTIONS";

    public OrganicEdgeRouterModule() {
        super(gz, "Sebastian Mueller", "Routes edges organically");
    }

    public OptionHandler createOptionHandler() {
        OrganicEdgeRouter organicEdgeRouter = new OrganicEdgeRouter();
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.setAttribute("OptionGroup.title", iz);
        optionGroup.addItem(optionHandler.addBool(hz, false));
        optionGroup.addItem(optionHandler.addInt(lz, (int)organicEdgeRouter.getMinimalDistance(), 10, 300));
        optionGroup.addItem(optionHandler.addBool(kz, organicEdgeRouter.isUsingBends()));
        optionGroup.addItem(optionHandler.addBool(mz, !organicEdgeRouter.isRoutingAll()));
        optionGroup.addItem(optionHandler.addBool(jz, false));
        return optionHandler;
    }

    protected void mainrun() {
        block6: {
            GroupNodeHider groupNodeHider;
            block5: {
                OrganicEdgeRouter organicEdgeRouter = new OrganicEdgeRouter();
                OptionHandler optionHandler = this.getOptionHandler();
                organicEdgeRouter.setMinimalDistance(optionHandler.getInt(lz));
                organicEdgeRouter.setUsingBends(optionHandler.getBool(kz));
                organicEdgeRouter.setRoutingAll(!optionHandler.getBool(mz));
                RemoveOverlapsLayoutStage removeOverlapsLayoutStage = new RemoveOverlapsLayoutStage(0.0);
                LayoutStage layoutStage = organicEdgeRouter.createNodeEnlargementStage();
                CompositeLayoutStage compositeLayoutStage = new CompositeLayoutStage();
                compositeLayoutStage.appendStage(layoutStage);
                if (organicEdgeRouter.isUsingBends()) {
                    compositeLayoutStage.appendStage(new BendConverter());
                }
                compositeLayoutStage.appendStage(removeOverlapsLayoutStage);
                SequentialLayouter sequentialLayouter = new SequentialLayouter();
                if (optionHandler.getBool(jz)) {
                    sequentialLayouter.appendLayouter(compositeLayoutStage);
                }
                sequentialLayouter.appendLayouter(organicEdgeRouter);
                groupNodeHider = new GroupNodeHider(sequentialLayouter);
                if (!optionHandler.getBool(hz)) break block5;
                EdgeMap edgeMap = Selections.createSelectionEdgeMap(this.getGraph2D());
                this.getGraph2D().addDataProvider(OrganicEdgeRouter.ROUTE_EDGE_DPKEY, edgeMap);
                this.launchLayouter(groupNodeHider);
                this.getGraph2D().removeDataProvider(OrganicEdgeRouter.ROUTE_EDGE_DPKEY);
                if (!YModule.z) break block6;
            }
            this.launchLayouter(groupNodeHider);
        }
    }
}

