/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.DataProvider;
import y.base.Edge;
import y.base.NodeMap;
import y.layout.CanonicMultiStageLayouter;
import y.layout.LayoutGraph;
import y.layout.ParallelEdgeLayouter;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.OptionHandler;
import y.util.DataProviderAdapter;
import y.view.Graph2D;
import y.view.Selections;

public class ParallelEdgeLayoutModule
extends LayoutModule {
    private static final String gi = "PARALLEL_EDGES";
    private static final String li = "CONSIDER_EDGE_DIRECTION";
    private static final String qi = "USE_ADAPTIVE_LINE_DISTANCE";
    private static final String ii = "LINE_DISTANCE";
    private static final String ni = "JOINS_ENDS";
    private static final String pi = "JOIN_DISTANCE";
    private static final String fi = "USE_SELECTED_EDGES_AS_MASTER";
    private static final String mi = "SCOPE";
    private static final String ji = "ALL_EDGES";
    private static final String hi = "SELECTED_EDGES";
    private static final String oi = "AT_SELECTED_NODES";
    private String[] ki = new String[]{"ALL_EDGES", "SELECTED_EDGES", "AT_SELECTED_NODES"};

    public ParallelEdgeLayoutModule() {
        super(gi, "Roland Wiese", "layout parallel edges");
    }

    public OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(this.getModuleName());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        ParallelEdgeLayouter parallelEdgeLayouter = new ParallelEdgeLayouter();
        optionHandler.addEnum(mi, this.ki, 0);
        optionHandler.addBool(fi, false);
        optionHandler.addBool(li, parallelEdgeLayouter.isDirectedModeEnabled());
        optionHandler.addBool(qi, parallelEdgeLayouter.isUsingAdaptiveLineDistances());
        optionHandler.addInt(ii, (int)parallelEdgeLayouter.getLineDistance(), 0, 50);
        optionHandler.addBool(ni, parallelEdgeLayouter.isJoinEndsEnabled());
        optionHandler.addInt(pi, (int)parallelEdgeLayouter.getAbsJoinEndDistance(), 0, 50);
        constraintManager.setEnabledOnValueEquals(ni, (Object)Boolean.TRUE, pi);
        return optionHandler;
    }

    public void mainrun() {
        Object object;
        DataProvider dataProvider;
        Graph2D graph2D;
        CanonicMultiStageLayouter canonicMultiStageLayouter;
        OptionHandler optionHandler;
        block9: {
            block10: {
                String string2;
                boolean bl;
                block8: {
                    bl = YModule.z;
                    optionHandler = this.getOptionHandler();
                    canonicMultiStageLayouter = new CanonicMultiStageLayouter(){

                        protected void doLayoutCore(LayoutGraph layoutGraph) {
                        }

                        protected boolean canLayoutCore(LayoutGraph layoutGraph) {
                            return true;
                        }
                    };
                    graph2D = this.getGraph2D();
                    string2 = optionHandler.getString(mi);
                    dataProvider = graph2D.getDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY);
                    if (!string2.equals(oi)) break block8;
                    object = Selections.createSelectionNodeMap(graph2D);
                    graph2D.addDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY, new DataProviderAdapter((NodeMap)object){
                        private final /* synthetic */ NodeMap val$node2IsSelected;
                        {
                            this.val$node2IsSelected = nodeMap;
                        }

                        public boolean getBool(Object object) {
                            Edge edge = (Edge)object;
                            return this.val$node2IsSelected.getBool(edge.source()) || this.val$node2IsSelected.getBool(edge.target());
                        }
                    });
                    if (!bl) break block9;
                }
                if (!string2.equals(hi)) break block10;
                graph2D.addDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY, Selections.createSelectionEdgeMap(graph2D));
                if (!bl) break block9;
            }
            if (graph2D.getDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY) != null) {
                graph2D.removeDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY);
            }
        }
        if (optionHandler.getBool(fi)) {
            graph2D.addDataProvider(ParallelEdgeLayouter.LEADING_EDGE_DPKEY, Selections.createSelectionEdgeMap(graph2D));
        }
        canonicMultiStageLayouter.enableOnlyCore();
        canonicMultiStageLayouter.setParallelEdgeLayouterEnabled(true);
        object = (ParallelEdgeLayouter)canonicMultiStageLayouter.getParallelEdgeLayouter();
        ((ParallelEdgeLayouter)object).setLeadingEdgeAdjustmentEnabled(false);
        ((ParallelEdgeLayouter)object).setDirectedModeEnabled(optionHandler.getBool(li));
        ((ParallelEdgeLayouter)object).setUsingAdaptiveLineDistances(optionHandler.getBool(qi));
        ((ParallelEdgeLayouter)object).setLineDistance(optionHandler.getInt(ii));
        ((ParallelEdgeLayouter)object).setJoinEndsEnabled(optionHandler.getBool(ni));
        ((ParallelEdgeLayouter)object).setAbsJoinEndDistance(optionHandler.getInt(pi));
        this.launchLayouter(canonicMultiStageLayouter, false);
        if (optionHandler.getBool(fi)) {
            graph2D.removeDataProvider(ParallelEdgeLayouter.LEADING_EDGE_DPKEY);
        }
        if (graph2D.getDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY) != null) {
            graph2D.removeDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY);
        }
        if (dataProvider != null) {
            graph2D.addDataProvider(ParallelEdgeLayouter.SCOPE_DPKEY, dataProvider);
        }
    }
}

