/*
 * Decompiled with CFR 0.152.
 */
package y.module;

import y.base.Edge;
import y.base.Node;
import y.layout.Layouter;
import y.layout.router.polyline.EdgeLayoutDescriptor;
import y.layout.router.polyline.EdgeRouter;
import y.layout.router.polyline.Grid;
import y.layout.router.polyline.PenaltySettings;
import y.module.LayoutModule;
import y.module.YModule;
import y.option.ConstraintManager;
import y.option.OptionGroup;
import y.option.OptionHandler;
import y.util.DataProviderAdapter;
import y.view.Graph2D;

public class PolylineEdgeRouterModule
extends LayoutModule {
    private static final String tj = "POLYLINE_EDGE_ROUTER";
    private static final String xj = "LAYOUT";
    private static final String kk = "SCOPE";
    private static final String zj = "SCOPE_ALL_EDGES";
    private static final String sk = "SCOPE_SELECTED_EDGES";
    private static final String pk = "SCOPE_EDGES_AT_SELECTED_NODES";
    private static final String[] gk = new String[]{"SCOPE_ALL_EDGES", "SCOPE_SELECTED_EDGES", "SCOPE_EDGES_AT_SELECTED_NODES"};
    private static final String ck = "OPTIMIZATION_STRATEGY";
    private static final String nk = "STRATEGY_BALANCED";
    private static final String fk = "STRATEGY_MINIMIZE_BENDS";
    private static final String mk = "STRATEGY_MINIMIZE_CROSSINGS";
    private static final String[] ak = new String[]{"STRATEGY_BALANCED", "STRATEGY_MINIMIZE_BENDS", "STRATEGY_MINIMIZE_CROSSINGS"};
    private static final String yj = "MONOTONIC_RESTRICTION";
    private static final String uk = "MONOTONIC_NONE";
    private static final String ek = "MONOTONIC_VERTICAL";
    private static final String ok = "MONOTONIC_HORIZONTAL";
    private static final String yk = "MONOTONIC_BOTH";
    private static final Object[] tk = new Object[]{"MONOTONIC_NONE", "MONOTONIC_HORIZONTAL", "MONOTONIC_VERTICAL", "MONOTONIC_BOTH"};
    private static final String wj = "MINIMAL_DISTANCES";
    private static final String rk = "MINIMAL_EDGE_TO_EDGE_DISTANCE";
    private static final String wk = "MINIMAL_NODE_TO_EDGE_DISTANCE";
    private static final String sj = "MINIMAL_NODE_CORNER_DISTANCE";
    private static final String ik = "MINIMAL_FIRST_SEGMENT_LENGTH";
    private static final String rj = "MINIMAL_LAST_SEGMENT_LENGTH";
    private static final String hk = "GRID_SETTINGS";
    private static final String vk = "GRID_ENABLED";
    private static final String lk = "GRID_SPACING";
    private static final String vj = "CONSIDER_NODE_LABELS";
    private static final String jk = "CONSIDER_EDGE_LABELS";
    private static final String dk = "ENABLE_REROUTING";
    private static final String bk = "MAXIMAL_DURATION";
    private static final String qj = "POLYLINE_ROUTING";
    private static final String uj = "ENABLE_POLYLINE_ROUTING";
    private static final String xk = "PREFERRED_POLYLINE_SEGMENT_LENGTH";
    private EdgeRouter qk;

    public PolylineEdgeRouterModule() {
        super(tj, "yFiles Layout Team", "Polyline Edge Router");
        this.setPortIntersectionCalculatorEnabled(true);
    }

    public OptionHandler createOptionHandler() {
        OptionHandler optionHandler;
        EdgeRouter edgeRouter;
        block7: {
            OptionGroup optionGroup;
            block6: {
                EdgeLayoutDescriptor edgeLayoutDescriptor;
                boolean bl;
                block5: {
                    block4: {
                        bl = YModule.z;
                        edgeRouter = new EdgeRouter();
                        edgeLayoutDescriptor = edgeRouter.getDefaultEdgeLayoutDescriptor();
                        optionHandler = new OptionHandler(this.getModuleName());
                        optionHandler.useSection(xj);
                        byte by = edgeRouter.getSphereOfAction();
                        if (by != 0) break block4;
                        optionHandler.addEnum(kk, gk, 0);
                        if (!bl) break block5;
                    }
                    optionHandler.addEnum(kk, gk, 1);
                }
                optionHandler.addEnum(ck, ak, 0);
                optionHandler.addEnum(yj, tk, edgeLayoutDescriptor.getMonotonicPathRestriction());
                optionGroup = new OptionGroup();
                optionGroup.setAttribute("OptionGroup.title", wj);
                optionGroup.addItem(optionHandler.addDouble(rk, edgeLayoutDescriptor.getMinimalEdgeToEdgeDistance()));
                optionGroup.addItem(optionHandler.addDouble(wk, edgeRouter.getMinimalNodeToEdgeDistance()));
                optionGroup.addItem(optionHandler.addDouble(sj, edgeLayoutDescriptor.getMinimalNodeCornerDistance()));
                optionGroup.addItem(optionHandler.addDouble(ik, edgeLayoutDescriptor.getMinimalFirstSegmentLength()));
                optionGroup.addItem(optionHandler.addDouble(rj, edgeLayoutDescriptor.getMinimalLastSegmentLength()));
                optionGroup = new OptionGroup();
                optionGroup.setAttribute("OptionGroup.title", hk);
                Grid grid = edgeRouter.getGrid();
                if (grid == null) break block6;
                optionGroup.addItem(optionHandler.addBool(vk, true));
                optionGroup.addItem(optionHandler.addDouble(lk, grid.getSpacing()));
                if (!bl) break block7;
            }
            optionGroup.addItem(optionHandler.addBool(vk, false));
            optionGroup.addItem(optionHandler.addDouble(lk, 10.0));
        }
        optionHandler.addBool(vj, edgeRouter.isConsiderNodeLabelsEnabled());
        optionHandler.addBool(jk, edgeRouter.isConsiderEdgeLabelsEnabled());
        optionHandler.addBool(dk, edgeRouter.isReroutingEnabled());
        optionHandler.addInt(bk, 0);
        optionHandler.useSection(qj);
        optionHandler.addBool(uj, true);
        optionHandler.addDouble(xk, edgeRouter.getPreferredPolylineSegmentLength());
        ConstraintManager constraintManager = new ConstraintManager(optionHandler);
        constraintManager.setEnabledOnValueEquals(vk, (Object)Boolean.TRUE, lk);
        constraintManager.setEnabledOnValueEquals(uj, (Object)Boolean.TRUE, xk);
        return optionHandler;
    }

    protected void init() {
        block5: {
            OptionHandler optionHandler;
            Graph2D graph2D;
            block4: {
                super.init();
                this.e();
                this.configure(this.qk);
                graph2D = this.getGraph2D();
                optionHandler = this.getOptionHandler();
                if (!sk.equals(optionHandler.getString(kk))) break block4;
                graph2D.addDataProvider(this.qk.getSelectedEdgesDpKey(), new DataProviderAdapter(){

                    public boolean getBool(Object object) {
                        return graph2D.isSelected((Edge)object);
                    }
                });
                if (!YModule.z) break block5;
            }
            if (pk.equals(optionHandler.getString(kk))) {
                graph2D.addDataProvider(this.qk.getSelectedNodesDpKey(), new DataProviderAdapter(){

                    public boolean getBool(Object object) {
                        return graph2D.isSelected((Node)object);
                    }
                });
            }
        }
    }

    private void e() {
        if (this.qk == null) {
            this.qk = new EdgeRouter();
        }
    }

    public void configure(Layouter layouter) {
        block24: {
            block10: {
                int n2;
                EdgeRouter edgeRouter;
                boolean bl;
                block23: {
                    OptionHandler optionHandler;
                    block22: {
                        block21: {
                            EdgeLayoutDescriptor edgeLayoutDescriptor;
                            block18: {
                                block20: {
                                    String string2;
                                    block19: {
                                        block17: {
                                            block15: {
                                                PenaltySettings penaltySettings;
                                                block16: {
                                                    String string3;
                                                    block14: {
                                                        block12: {
                                                            block13: {
                                                                String string4;
                                                                block11: {
                                                                    bl = YModule.z;
                                                                    if (!(layouter instanceof EdgeRouter)) break block10;
                                                                    edgeRouter = (EdgeRouter)layouter;
                                                                    edgeLayoutDescriptor = edgeRouter.getDefaultEdgeLayoutDescriptor();
                                                                    optionHandler = this.getOptionHandler();
                                                                    string4 = optionHandler.getString(kk);
                                                                    if (!pk.equals(string4)) break block11;
                                                                    edgeRouter.setSphereOfAction((byte)4);
                                                                    if (!bl) break block12;
                                                                }
                                                                if (!zj.equals(string4)) break block13;
                                                                edgeRouter.setSphereOfAction((byte)0);
                                                                if (!bl) break block12;
                                                            }
                                                            edgeRouter.setSphereOfAction((byte)2);
                                                        }
                                                        string3 = optionHandler.getString(ck);
                                                        penaltySettings = edgeLayoutDescriptor.getPenaltySettings();
                                                        if (!string3.equals(nk)) break block14;
                                                        penaltySettings.setBendPenalty(3);
                                                        penaltySettings.setEdgeCrossingPenalty(1);
                                                        if (!bl) break block15;
                                                    }
                                                    if (!string3.equals(fk)) break block16;
                                                    penaltySettings.setBendPenalty(3);
                                                    penaltySettings.setEdgeCrossingPenalty(0);
                                                    if (!bl) break block15;
                                                }
                                                penaltySettings.setBendPenalty(3);
                                                penaltySettings.setEdgeCrossingPenalty(5);
                                            }
                                            if (!(string2 = optionHandler.getString(yj)).equals(yk)) break block17;
                                            edgeLayoutDescriptor.setMonotonicPathRestriction((byte)3);
                                            if (!bl) break block18;
                                        }
                                        if (!string2.equals(ok)) break block19;
                                        edgeLayoutDescriptor.setMonotonicPathRestriction((byte)2);
                                        if (!bl) break block18;
                                    }
                                    if (!string2.equals(ek)) break block20;
                                    edgeLayoutDescriptor.setMonotonicPathRestriction((byte)1);
                                    if (!bl) break block18;
                                }
                                edgeLayoutDescriptor.setMonotonicPathRestriction((byte)0);
                            }
                            edgeLayoutDescriptor.setMinimalEdgeToEdgeDistance(optionHandler.getDouble(rk));
                            edgeRouter.setMinimalNodeToEdgeDistance(optionHandler.getDouble(wk));
                            edgeLayoutDescriptor.setMinimalNodeCornerDistance(optionHandler.getDouble(sj));
                            edgeLayoutDescriptor.setMinimalFirstSegmentLength(optionHandler.getDouble(ik));
                            edgeLayoutDescriptor.setMinimalLastSegmentLength(optionHandler.getDouble(rj));
                            if (!optionHandler.getBool(vk)) break block21;
                            double d2 = optionHandler.getDouble(lk);
                            edgeRouter.setGrid(new Grid(0.0, 0.0, d2));
                            if (!bl) break block22;
                        }
                        edgeRouter.setGrid(null);
                    }
                    edgeRouter.setConsiderNodeLabelsEnabled(optionHandler.getBool(vj));
                    edgeRouter.setConsiderEdgeLabelsEnabled(optionHandler.getBool(jk));
                    edgeRouter.setReroutingEnabled(optionHandler.getBool(dk));
                    edgeRouter.setPolylineRoutingEnabled(optionHandler.getBool(uj));
                    edgeRouter.setPreferredPolylineSegmentLength(optionHandler.getDouble(xk));
                    n2 = optionHandler.getInt(bk);
                    if (n2 != 0) break block23;
                    edgeRouter.setMaximumDuration(Long.MAX_VALUE);
                    if (!bl) break block24;
                }
                edgeRouter.setMaximumDuration(n2 * 1000);
                if (!bl) break block24;
            }
            throw new IllegalArgumentException("Argument must be of type y.layout.router.polyline.EdgeRouter");
        }
    }

    public void mainrun() {
        this.launchLayouter(this.qk);
    }

    protected void dispose() {
        Graph2D graph2D = this.getGraph2D();
        if (graph2D.getDataProvider(this.qk.getSelectedEdgesDpKey()) != null) {
            graph2D.removeDataProvider(this.qk.getSelectedEdgesDpKey());
        }
        if (graph2D.getDataProvider(this.qk.getSelectedNodesDpKey()) != null) {
            graph2D.removeDataProvider(this.qk.getSelectedNodesDpKey());
        }
        super.dispose();
    }
}

