/*
 * Decompiled with CFR 0.152.
 */
package y.module.io;

import y.io.GIFIOHandler;
import y.io.ImageOutputHandler;
import y.module.io.IOHandlerModule;
import y.module.io.ImageOutputModule;
import y.option.OptionHandler;
import y.view.BackgroundRenderer;
import y.view.DefaultBackgroundRenderer;
import y.view.Graph2D;
import y.view.Graph2DView;

public class GIFOutput
extends ImageOutputModule {
    private static final String scb = "GIF_OUTPUT";
    private static final String rcb = "GIF";
    private static final String qcb = "TRANSPARENT_BACKGROUND";

    public GIFOutput() {
        super(scb, "[RW]", "GIF Export");
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(scb);
        optionHandler.useSection("VIEWPORT");
        this.addViewPortOptions(optionHandler);
        optionHandler.useSection(rcb);
        optionHandler.addBool(qcb, false);
        this.addRenderingOptions(optionHandler);
        optionHandler.useSection("TILING");
        this.addTilingOptions(optionHandler);
        return optionHandler;
    }

    protected ImageOutputHandler createImageOutputHandler() {
        return new GIFIOHandler();
    }

    protected void mainrun() {
        Graph2DView graph2DView;
        Graph2D graph2D;
        GIFIOHandler gIFIOHandler;
        block3: {
            block2: {
                gIFIOHandler = (GIFIOHandler)this.getIOHandler();
                graph2D = this.getGraph2D();
                Graph2DView graph2DView2 = gIFIOHandler.createDefaultGraph2DView(graph2D);
                graph2DView = this.getGraph2DView();
                graph2D.setCurrentView(graph2DView2);
                this.configureViewPort(graph2DView2, graph2DView);
                graph2DView2.setGraph2DRenderer(graph2DView.getGraph2DRenderer());
                OptionHandler optionHandler = this.getOptionHandler();
                this.configureRendering();
                this.configureTiling();
                if (optionHandler.getBool(qcb)) break block2;
                BackgroundRenderer backgroundRenderer = graph2DView.getBackgroundRenderer();
                if (!(backgroundRenderer instanceof DefaultBackgroundRenderer)) break block3;
                DefaultBackgroundRenderer defaultBackgroundRenderer = (DefaultBackgroundRenderer)backgroundRenderer;
                defaultBackgroundRenderer.setGraph2DView(graph2DView2);
                graph2DView2.setBackgroundRenderer(defaultBackgroundRenderer);
                super.mainrun();
                defaultBackgroundRenderer.setGraph2DView(graph2DView);
                if (!IOHandlerModule.z) break block3;
            }
            super.mainrun();
        }
        this.setIOHandler(gIFIOHandler);
        graph2D.removeView(graph2D.getCurrentView());
        graph2D.setCurrentView(graph2DView);
    }
}

