/*
 * Decompiled with CFR 0.152.
 */
package y.module.io;

import java.awt.Color;
import javax.imageio.ImageWriter;
import y.base.Graph;
import y.io.ImageIoOutputHandler;
import y.io.ImageOutputHandler;
import y.module.io.IOHandlerModule;
import y.module.io.ImageOutputModule;
import y.option.OptionHandler;
import y.view.BackgroundRenderer;
import y.view.DefaultBackgroundRenderer;
import y.view.Graph2D;
import y.view.Graph2DView;

public class ImageIoOutput
extends ImageOutputModule {
    private static final String tcb = "IMAGEIO_OUTPUT";
    private static final String wcb = "ANTIALIASING";
    private static final String vcb = "TRANSPARENT_BACKGROUND";
    private static final String xcb = "IMAGE";
    private final ImageWriter ucb;

    public ImageIoOutput(ImageWriter imageWriter) {
        super(tcb, "[SM]", "ImageIO Export");
        this.ucb = imageWriter;
    }

    protected boolean isTransparentBackgroundSupported() {
        return false;
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(tcb);
        optionHandler.useSection("VIEWPORT");
        this.addViewPortOptions(optionHandler);
        optionHandler.useSection(xcb);
        optionHandler.addBool(wcb, true);
        if (this.isTransparentBackgroundSupported()) {
            optionHandler.addBool(vcb, false);
        }
        this.addRenderingOptions(optionHandler);
        optionHandler.useSection("TILING");
        this.addTilingOptions(optionHandler);
        return optionHandler;
    }

    protected ImageOutputHandler createImageOutputHandler() {
        return new ImageIoOutputHandler(this.ucb);
    }

    protected void mainrun() {
        Graph2DView graph2DView;
        Graph2D graph2D;
        ImageIoOutputHandler imageIoOutputHandler;
        boolean bl;
        block5: {
            block6: {
                DefaultBackgroundRenderer defaultBackgroundRenderer;
                BackgroundRenderer backgroundRenderer;
                Graph2DView graph2DView2;
                block4: {
                    bl = IOHandlerModule.z;
                    imageIoOutputHandler = (ImageIoOutputHandler)this.getIOHandler();
                    graph2D = this.getGraph2D();
                    graph2DView2 = imageIoOutputHandler.createDefaultGraph2DView(graph2D);
                    graph2DView = this.getGraph2DView();
                    graph2D.setCurrentView(graph2DView2);
                    this.configureViewPort(graph2DView2, graph2DView);
                    graph2DView2.setGraph2DRenderer(graph2DView.getGraph2DRenderer());
                    OptionHandler optionHandler = this.getOptionHandler();
                    imageIoOutputHandler.setAntialiasingEnabled(optionHandler.getBool(wcb));
                    this.configureRendering();
                    this.configureTiling();
                    boolean bl2 = this.isTransparentBackgroundSupported() && optionHandler.getBool(vcb);
                    imageIoOutputHandler.setTransparencyEnabled(bl2);
                    backgroundRenderer = graph2DView.getBackgroundRenderer();
                    if (!bl2) break block4;
                    defaultBackgroundRenderer = new DefaultBackgroundRenderer(graph2DView2);
                    defaultBackgroundRenderer.setColor(new Color(255, 255, 255, 0));
                    graph2DView2.setBackgroundRenderer(defaultBackgroundRenderer);
                    super.mainrun();
                    if (!bl) break block5;
                }
                if (!(backgroundRenderer instanceof DefaultBackgroundRenderer)) break block6;
                defaultBackgroundRenderer = (DefaultBackgroundRenderer)backgroundRenderer;
                defaultBackgroundRenderer.setGraph2DView(graph2DView2);
                graph2DView2.setBackgroundRenderer(defaultBackgroundRenderer);
                super.mainrun();
                defaultBackgroundRenderer.setGraph2DView(graph2DView);
                if (!bl) break block5;
            }
            super.mainrun();
        }
        this.setIOHandler(imageIoOutputHandler);
        graph2D.removeView(graph2D.getCurrentView());
        graph2D.setCurrentView(graph2DView);
        if (Graph.z) {
            IOHandlerModule.z = !bl;
        }
    }
}

