/*
 * Decompiled with CFR 0.152.
 */
package y.module.io;

import y.io.ImageOutputHandler;
import y.io.JPGIOHandler;
import y.io.ViewPortConfigurator;
import y.module.io.IOHandlerModule;
import y.module.io.ImageOutputModule;
import y.option.OptionHandler;
import y.view.BackgroundRenderer;
import y.view.DefaultBackgroundRenderer;
import y.view.Graph2D;
import y.view.Graph2DView;

public class JPGOutput
extends ImageOutputModule {
    private static final String ncb = "JPG_OUTPUT";
    private static final String pcb = "JPG";
    private static final String mcb = "QUALITY";
    private static final String ocb = "ANTIALIASING";
    private ViewPortConfigurator lcb = new ViewPortConfigurator();

    public JPGOutput() {
        super(ncb, "[RW]", "JPG Export");
    }

    protected OptionHandler createOptionHandler() {
        OptionHandler optionHandler = new OptionHandler(ncb);
        optionHandler.useSection("VIEWPORT");
        this.addViewPortOptions(optionHandler);
        optionHandler.useSection(pcb);
        optionHandler.addInt(mcb, 75, 1, 100);
        optionHandler.addBool(ocb, true);
        this.addRenderingOptions(optionHandler);
        optionHandler.useSection("TILING");
        this.addTilingOptions(optionHandler);
        return optionHandler;
    }

    protected ImageOutputHandler createImageOutputHandler() {
        return new JPGIOHandler();
    }

    protected void mainrun() {
        Graph2DView graph2DView;
        Graph2D graph2D;
        JPGIOHandler jPGIOHandler;
        block3: {
            block2: {
                jPGIOHandler = (JPGIOHandler)this.getIOHandler();
                graph2D = this.getGraph2D();
                Graph2DView graph2DView2 = jPGIOHandler.createDefaultGraph2DView(graph2D);
                graph2DView = this.getGraph2DView();
                graph2D.setCurrentView(graph2DView2);
                this.configureViewPort(graph2DView2, graph2DView);
                graph2DView2.setGraph2DRenderer(graph2DView.getGraph2DRenderer());
                OptionHandler optionHandler = this.getOptionHandler();
                jPGIOHandler.setQuality(0.01f * (float)optionHandler.getInt(mcb));
                jPGIOHandler.setAntialiasingEnabled(optionHandler.getBool(ocb));
                this.configureRendering();
                this.configureTiling();
                BackgroundRenderer backgroundRenderer = graph2DView.getBackgroundRenderer();
                if (!(backgroundRenderer instanceof DefaultBackgroundRenderer)) break block2;
                DefaultBackgroundRenderer defaultBackgroundRenderer = (DefaultBackgroundRenderer)backgroundRenderer;
                defaultBackgroundRenderer.setGraph2DView(graph2DView2);
                graph2DView2.setBackgroundRenderer(defaultBackgroundRenderer);
                super.mainrun();
                defaultBackgroundRenderer.setGraph2DView(graph2DView);
                if (!IOHandlerModule.z) break block3;
            }
            super.mainrun();
        }
        this.setIOHandler(jPGIOHandler);
        graph2D.removeView(graph2D.getCurrentView());
        graph2D.setCurrentView(graph2DView);
    }
}

