/*
 * Decompiled with CFR 0.152.
 */
package y.option;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import y.base.Edge;
import y.base.Node;
import y.geom.YPoint;
import y.option.OptionItem;
import y.view.Bend;
import y.view.BendCursor;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeLabel;
import y.view.NodeRealizer;
import y.view.Port;

public class RealizerCellRenderer
implements ListCellRenderer,
TableCellRenderer {
    private final DefaultListCellRenderer b = new DefaultListCellRenderer();
    private final DefaultTableCellRenderer c = new DefaultTableCellRenderer();
    private int d;
    private int e;

    public RealizerCellRenderer() {
        this(50, 50);
    }

    public RealizerCellRenderer(int n2, int n3) {
        this.e = n3;
        this.d = n2;
    }

    public int getItemWidth() {
        return this.d;
    }

    public void setItemWidth(int n2) {
        this.d = n2;
    }

    public int getItemHeight() {
        return this.e;
    }

    public void setItemHeight(int n2) {
        this.e = n2;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl, boolean bl2) {
        JLabel jLabel;
        block3: {
            block4: {
                boolean bl3;
                block2: {
                    bl3 = OptionItem.z;
                    jLabel = (JLabel)this.b.getListCellRendererComponent((JList<?>)jList, object, n2, bl, bl2);
                    jLabel.setText(null);
                    if (!(object instanceof NodeRealizer)) break block2;
                    jLabel.setIcon(this.createNodeRealizerIcon((NodeRealizer)object, this.d, this.e));
                    jLabel.setToolTipText(this.createNodeToolTipText((NodeRealizer)object));
                    if (!bl3) break block3;
                }
                if (!(object instanceof EdgeRealizer)) break block4;
                jLabel.setIcon(this.createEdgeRealizerIcon((EdgeRealizer)object, this.d, this.e));
                jLabel.setToolTipText(this.createEdgeToolTipText((EdgeRealizer)object));
                if (!bl3) break block3;
            }
            throw new IllegalArgumentException("Can only handle NodeRealizers and EdgeRealizers! " + object.toString());
        }
        return jLabel;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n2, int n3) {
        JLabel jLabel;
        block3: {
            block4: {
                boolean bl3;
                block2: {
                    bl3 = OptionItem.z;
                    jLabel = (JLabel)this.c.getTableCellRendererComponent(jTable, object, bl, bl2, n2, n3);
                    jLabel.setText(null);
                    jLabel.setPreferredSize(new Dimension(this.d, this.e));
                    if (!(object instanceof NodeRealizer)) break block2;
                    jLabel.setIcon(this.createNodeRealizerIcon((NodeRealizer)object, this.d, this.e));
                    jLabel.setToolTipText(this.createNodeToolTipText((NodeRealizer)object));
                    if (!bl3) break block3;
                }
                if (!(object instanceof EdgeRealizer)) break block4;
                jLabel.setIcon(this.createEdgeRealizerIcon((EdgeRealizer)object, this.d, this.e));
                jLabel.setToolTipText(this.createEdgeToolTipText((EdgeRealizer)object));
                if (!bl3) break block3;
            }
            throw new IllegalArgumentException("Can only handle NodeRealizers and EdgeRealizers! " + object.toString());
        }
        return jLabel;
    }

    protected Icon createNodeRealizerIcon(NodeRealizer nodeRealizer, int n2, int n3) {
        return new NodeRealizerIcon(nodeRealizer, n2, n3);
    }

    protected Icon createEdgeRealizerIcon(EdgeRealizer edgeRealizer, int n2, int n3) {
        return new EdgeRealizerIcon(edgeRealizer, n2, n3);
    }

    protected String createNodeToolTipText(NodeRealizer nodeRealizer) {
        return null;
    }

    protected String createEdgeToolTipText(EdgeRealizer edgeRealizer) {
        return null;
    }

    public static class EdgeRealizerIcon
    implements Icon {
        private EdgeRealizer c;
        private boolean d;
        private final int e;
        private final int b;

        public EdgeRealizerIcon(EdgeRealizer edgeRealizer, int n2, int n3) {
            this.e = n2;
            this.b = n3;
            this.d = true;
            this.b(edgeRealizer.createCopy());
        }

        public boolean isDrawingBends() {
            return this.d;
        }

        public void setDrawingBends(boolean bl) {
            this.d = bl;
        }

        private void b(EdgeRealizer edgeRealizer) {
            Graph2D graph2D = new Graph2D();
            Node node = graph2D.createNode();
            Node node2 = graph2D.createNode();
            Edge edge = graph2D.createEdge(node, node2, edgeRealizer.createCopy());
            this.c = graph2D.getRealizer(edge);
            this.c.setSourcePort(new Port(0.0, 0.0));
            this.c.setTargetPort(new Port(0.0, 0.0));
            this.c.clearBends();
            YPoint yPoint = this.calculateSourceBend(this.c, this.e, this.b);
            YPoint yPoint2 = this.calculateTargetBend(this.c, this.e, this.b);
            this.c.appendBend(yPoint.getX(), yPoint.getY());
            this.c.appendBend(yPoint2.getX(), yPoint2.getY());
            graph2D.getRealizer(node).setSize(1.0, 1.0);
            graph2D.getRealizer(node).setVisible(false);
            graph2D.getRealizer(node).setCenter(3.0, yPoint.getY());
            graph2D.getRealizer(node2).setSize(1.0, 1.0);
            graph2D.getRealizer(node2).setVisible(false);
            graph2D.getRealizer(node2).setCenter(this.e - 3, yPoint2.getY());
        }

        protected YPoint calculateSourceBend(EdgeRealizer edgeRealizer, int n2, int n3) {
            return new YPoint(0.5 * (double)n2, 0.8 * (double)n3);
        }

        protected YPoint calculateTargetBend(EdgeRealizer edgeRealizer, int n2, int n3) {
            return new YPoint(0.5 * (double)n2, 0.2 * (double)n3);
        }

        public int getIconHeight() {
            return this.b;
        }

        public int getIconWidth() {
            return this.e;
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.translate(n2, n3);
            this.paintRealizer(this.c, graphics2D);
            graphics2D.dispose();
        }

        protected void paintRealizer(EdgeRealizer edgeRealizer, Graphics2D graphics2D) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            edgeRealizer.getPath();
            this.b(graphics2D);
            edgeRealizer.setSelected(false);
            edgeRealizer.paint(graphics2D);
        }

        private void b(Graphics2D graphics2D) {
            boolean bl = OptionItem.z;
            if (this.isDrawingBends() && this.c.bendCount() > 0) {
                BendCursor bendCursor = this.c.bends();
                while (bendCursor.ok()) {
                    Bend bend = bendCursor.bend();
                    graphics2D.setColor(Color.green);
                    Ellipse2D.Double double_ = new Ellipse2D.Double(bend.getX() - 3.0, bend.getY() - 3.0, 6.0, 6.0);
                    graphics2D.fill(double_);
                    graphics2D.setColor(Color.darkGray);
                    graphics2D.draw(double_);
                    bendCursor.next();
                    if (!bl) continue;
                }
            }
        }
    }

    public static class NodeRealizerIcon
    implements Icon {
        private NodeRealizer d;
        private int f;
        private int b;
        private int c;
        private double g;
        private Rectangle2D e;

        public NodeRealizerIcon(NodeRealizer nodeRealizer, int n2, int n3) {
            block2: {
                boolean bl = OptionItem.z;
                this.f = n2;
                this.b = n3;
                this.d = nodeRealizer;
                this.e = nodeRealizer.getBoundingBox();
                for (int i2 = 0; i2 < nodeRealizer.labelCount(); ++i2) {
                    NodeLabel nodeLabel = nodeRealizer.getLabel(i2);
                    nodeLabel.calcUnionRect(this.e);
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block2;
                }
                this.c = Math.max(0, Math.min(4, Math.min(n2 - 4, n3 - 4) / 2));
                this.g = Math.min(1.0, Math.min((double)(this.f - this.c) / this.e.getWidth(), (double)(this.b - this.c) / this.e.getHeight()));
            }
        }

        public int getIconHeight() {
            return this.b;
        }

        public int getIconWidth() {
            return this.f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics2D.translate((double)(n2 + this.c / 2) + ((double)(this.f - this.c) - this.e.getWidth() * this.g) * 0.5, (double)(n3 + this.c / 2) + ((double)(this.b - this.c) - this.e.getHeight() * this.g) * 0.5);
            graphics2D.translate(this.e.getWidth() * 0.5 * this.g, this.e.getHeight() * 0.5 * this.g);
            graphics2D.scale(this.g, this.g);
            graphics2D.translate(-this.e.getCenterX(), -this.e.getCenterY());
            boolean bl = this.d.isSelected();
            try {
                this.d.setSelected(false);
                this.d.paint(graphics2D);
            }
            finally {
                this.d.setSelected(bl);
            }
            graphics2D.dispose();
        }
    }
}

