/*
 * Decompiled with CFR 0.152.
 */
package y.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceResolver {
    private ResourceResolver() {
    }

    public static URL getResource(String string2, String string3, String string4) {
        URL uRL = null;
        if (string2 != null) {
            uRL = ResourceResolver.getSystemResource(string2);
        }
        if (uRL == null && string3 != null) {
            uRL = ResourceResolver.getUserHomeResource(string3);
        }
        if (uRL == null && string4 != null) {
            uRL = ResourceResolver.getClassPathResource(string4);
        }
        return uRL;
    }

    public static URL getUserHomeResource(String string2) {
        try {
            String string3 = System.getProperty("user.home");
            return ResourceResolver.getFileResource(string3 + File.separatorChar + string2);
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    public static URL getClassPathResource(String string2) {
        return new ResourceResolver().getClass().getClassLoader().getResource(string2);
    }

    public static URL getURLResource(String string2) {
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static URL getFileResource(String string2) {
        try {
            File file2 = new File(string2);
            if (file2.canRead()) {
                return file2.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public static URL getSystemResource(String string2) {
        try {
            String string3 = System.getProperty(string2);
            if (string3 != null) {
                return ResourceResolver.b(string3, false);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public static URL getResource(String string2) {
        return ResourceResolver.b(string2, true);
    }

    private static URL b(String string2, boolean bl) {
        URL uRL = null;
        if (bl) {
            uRL = ResourceResolver.getSystemResource(string2);
        }
        if (uRL == null) {
            uRL = ResourceResolver.getUserHomeResource(string2);
        }
        if (uRL == null) {
            uRL = ResourceResolver.getClassPathResource(string2);
        }
        if (uRL == null) {
            uRL = ResourceResolver.getFileResource(string2);
        }
        if (uRL == null) {
            uRL = ResourceResolver.getURLResource(string2);
        }
        return uRL;
    }
}

