/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import y.view.GenericNodeRealizer;
import y.view.NodeRealizer;
import y.view.YRenderingHints;

public abstract class AbstractCustomNodePainter
implements GenericNodeRealizer.Painter {
    private Color w;
    private Stroke x;
    private Paint y;
    private static final double v = 0.7;

    public void paint(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        this.e(nodeRealizer, graphics2D, false);
    }

    protected void backupGraphics(Graphics2D graphics2D) {
        this.w = graphics2D.getColor();
        this.x = graphics2D.getStroke();
        this.y = graphics2D.getPaint();
    }

    protected void paintHotSpots(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        if (AbstractCustomNodePainter.d(nodeRealizer, graphics2D)) {
            nodeRealizer.paintHotSpots(graphics2D);
        }
    }

    protected void paintText(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        if (nodeRealizer.labelCount() > 0) {
            nodeRealizer.paintText(graphics2D);
        }
    }

    protected void paintPorts(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        nodeRealizer.paintPorts(graphics2D);
    }

    protected void restoreGraphics(Graphics2D graphics2D) {
        graphics2D.setColor(this.w);
        graphics2D.setStroke(this.x);
        graphics2D.setPaint(this.y);
    }

    protected boolean initializeLine(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        Paint paint = this.e(nodeRealizer, graphics2D);
        if (paint != null) {
            graphics2D.setStroke(this.getLineStroke(nodeRealizer, AbstractCustomNodePainter.d(nodeRealizer, graphics2D)));
            graphics2D.setPaint(paint);
            return true;
        }
        return false;
    }

    protected boolean initializeFill(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        if (!nodeRealizer.isTransparent()) {
            Paint paint = this.c(nodeRealizer, graphics2D);
            if (paint != null) {
                graphics2D.setPaint(paint);
                return true;
            }
            return false;
        }
        return false;
    }

    protected Color getLineColor(NodeRealizer nodeRealizer, boolean bl) {
        return nodeRealizer.getLineColor();
    }

    protected Stroke getLineStroke(NodeRealizer nodeRealizer, boolean bl) {
        return nodeRealizer.getLineType();
    }

    protected Paint getLinePaint(NodeRealizer nodeRealizer, boolean bl) {
        return this.getLineColor(nodeRealizer, bl);
    }

    protected Color createSelectionColor(Color color) {
        return new Color(Math.max((int)((double)color.getRed() * 0.7), 0), Math.max((int)((double)color.getGreen() * 0.7), 0), Math.max((int)((double)color.getBlue() * 0.7), 0), color.getAlpha());
    }

    protected Color getFillColor(NodeRealizer nodeRealizer, boolean bl) {
        Color color = nodeRealizer.getFillColor();
        if (color != null) {
            return bl ? this.createSelectionColor(color) : color;
        }
        return null;
    }

    protected Paint getFillPaint(NodeRealizer nodeRealizer, boolean bl) {
        Color color = this.getFillColor(nodeRealizer, bl);
        if (color != null) {
            Color color2 = this.getFillColor2(nodeRealizer, bl);
            if (color2 != null) {
                return new GradientPaint((float)(nodeRealizer.getX() + nodeRealizer.getWidth() * 0.33), (float)nodeRealizer.getY(), color, (float)(nodeRealizer.getX() + nodeRealizer.getWidth()), (float)nodeRealizer.getY(), color2, true);
            }
            return color;
        }
        return null;
    }

    protected Color getFillColor2(NodeRealizer nodeRealizer, boolean bl) {
        Color color = nodeRealizer.getFillColor2();
        if (color != null) {
            return bl ? this.createSelectionColor(color) : color;
        }
        return null;
    }

    protected abstract void paintNode(NodeRealizer var1, Graphics2D var2, boolean var3);

    public void paintSloppy(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        this.e(nodeRealizer, graphics2D, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void e(NodeRealizer nodeRealizer, Graphics2D graphics2D, boolean bl) {
        if (!nodeRealizer.isVisible()) {
            return;
        }
        this.backupGraphics(graphics2D);
        try {
            if (!bl) {
                this.paintHotSpots(nodeRealizer, graphics2D);
            }
            this.paintNode(nodeRealizer, graphics2D, bl);
        }
        finally {
            this.restoreGraphics(graphics2D);
        }
        if (AbstractCustomNodePainter.e(graphics2D, bl)) {
            this.paintPorts(nodeRealizer, graphics2D);
        }
        if (AbstractCustomNodePainter.d(graphics2D, bl)) {
            this.paintText(nodeRealizer, graphics2D);
        }
    }

    Paint c(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        boolean bl = AbstractCustomNodePainter.d(nodeRealizer, graphics2D);
        return AbstractCustomNodePainter.b(graphics2D) ? this.getFillPaint(nodeRealizer, bl) : this.getFillColor(nodeRealizer, bl);
    }

    Paint e(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        boolean bl = AbstractCustomNodePainter.d(nodeRealizer, graphics2D);
        return AbstractCustomNodePainter.b(graphics2D) ? this.getLinePaint(nodeRealizer, bl) : this.getLineColor(nodeRealizer, bl);
    }

    static boolean b(Graphics2D graphics2D) {
        return YRenderingHints.isGradientPaintingEnabled(graphics2D);
    }

    static boolean d(NodeRealizer nodeRealizer, Graphics2D graphics2D) {
        return NodeRealizer.b(nodeRealizer, graphics2D);
    }

    static boolean d(Graphics2D graphics2D, boolean bl) {
        return NodeRealizer.c(graphics2D, bl);
    }

    static boolean e(Graphics2D graphics2D, boolean bl) {
        return NodeRealizer.b(graphics2D, bl);
    }
}

