/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import y.base.ListCell;
import y.io.BadVersionException;
import y.view.Bend;
import y.view.BendCursor;
import y.view.EdgeRealizer;
import y.view.NodeRealizer;
import y.view.Port;
import y.view.v;

public class BezierEdgeRealizer
extends EdgeRealizer {
    private static final double zc = 0.75;
    private final GeneralPath ad = new GeneralPath();

    public BezierEdgeRealizer() {
    }

    public BezierEdgeRealizer(EdgeRealizer edgeRealizer) {
        super(edgeRealizer);
    }

    public EdgeRealizer createCopy(EdgeRealizer edgeRealizer) {
        return new BezierEdgeRealizer(edgeRealizer);
    }

    public Bend createBend(double d2, double d3, Bend bend, int n2) {
        Bend bend2 = new Bend(this, d2, d3);
        this.reInsertBend(bend2, bend, n2);
        return bend2;
    }

    public void reInsertBend(Bend bend, Bend bend2, int n2) {
        block3: {
            block2: {
                if (n2 != 0) break block2;
                this.bends.insertAfter(bend, this.bends.findCell(bend2));
                if (!NodeRealizer.z) break block3;
            }
            this.bends.insertBefore(bend, this.bends.findCell(bend2));
        }
        this.setDirty();
    }

    public Bend insertBend(double d2, double d3) {
        int n2 = this.c(d2, d3);
        if (n2 >= 0) {
            return this.createBend(d2, d3, (Bend)this.bends.elementAt(n2), 1);
        }
        return null;
    }

    public boolean contains(double d2, double d3) {
        if (!this.isSelected()) {
            return super.contains(d2, d3);
        }
        return this.c(d2, d3) >= 0;
    }

    public Bend removeBend(Bend bend) {
        this.bends.remove(bend);
        this.setDirty();
        return bend;
    }

    private int c(double d2, double d3) {
        double d4;
        int n2;
        block4: {
            double d5;
            double d6;
            boolean bl = NodeRealizer.z;
            double d7 = this.getSourcePort().getX(this.getSourceRealizer());
            double d8 = this.getSourcePort().getY(this.getSourceRealizer());
            n2 = 0;
            ListCell listCell = this.bends.firstCell();
            while (listCell != null) {
                Bend bend = (Bend)listCell.getInfo();
                d6 = bend.getX();
                d5 = bend.getY();
                double d9 = Line2D.ptSegDist(d7, d8, d6, d5, d2, d3) - 5.0;
                d4 = d9 == 0.0 ? 0 : (d9 < 0.0 ? -1 : 1);
                if (!bl) {
                    if (d4 < 0) {
                        return n2;
                    }
                    d7 = d6;
                    d8 = d5;
                    listCell = listCell.succ();
                    ++n2;
                    if (!bl) continue;
                }
                break block4;
            }
            d6 = this.getTargetPort().getX(this.getTargetRealizer());
            d5 = this.getTargetPort().getY(this.getTargetRealizer());
            double d10 = Line2D.ptSegDist(d7, d8, d6, d5, d2, d3) - 5.0;
            d4 = d10 == 0.0 ? 0 : (d10 < 0.0 ? -1 : 1);
        }
        if (d4 < 0) {
            return n2;
        }
        return -1;
    }

    protected byte calculatePath(Point2D point2D, Point2D point2D2) {
        block12: {
            int n2;
            int n3;
            Port port;
            NodeRealizer nodeRealizer;
            float[] fArray;
            float[] fArray2;
            int n4;
            boolean bl;
            block11: {
                block14: {
                    block13: {
                        bl = NodeRealizer.z;
                        if (this.bendCount() == 0) {
                            return v.c(this, this.path, point2D, point2D2);
                        }
                        n4 = 2;
                        if ((this.bendCount() & 1) != 1) break block13;
                        n4 += 3 * this.bendCount() + 1 >> 1;
                        if (!bl) break block14;
                    }
                    n4 += 3 * (this.bendCount() >> 1) - 1;
                }
                fArray2 = new float[n4];
                fArray = new float[n4];
                nodeRealizer = this.getSourceRealizer();
                port = this.getSourcePort();
                fArray2[0] = (float)port.getX(nodeRealizer);
                fArray[0] = (float)port.getY(nodeRealizer);
                n3 = 1;
                BendCursor bendCursor = this.bends();
                while (bendCursor.ok()) {
                    Bend bend = bendCursor.bend();
                    n2 = n3 % 3;
                    if (!bl) {
                        if (n2 == 0) {
                            fArray2[n3] = (float)(bend.getX() + (double)fArray2[n3 - 1]) / 2.0f;
                            fArray[n3] = (float)(bend.getY() + (double)fArray[n3 - 1]) / 2.0f;
                            ++n3;
                        }
                        fArray2[n3] = (float)bend.getX();
                        fArray[n3] = (float)bend.getY();
                        bendCursor.next();
                        ++n3;
                        if (!bl) continue;
                    }
                    break block11;
                }
                n2 = n3 % 3;
            }
            if (n2 == 2) {
                fArray2[n3] = fArray2[n3 - 1];
                fArray[n3] = fArray[n3 - 1];
            }
            nodeRealizer = this.getTargetRealizer();
            port = this.getTargetPort();
            fArray2[n4 - 1] = (float)port.getX(nodeRealizer);
            fArray[n4 - 1] = (float)port.getY(nodeRealizer);
            this.path.reset();
            this.ad.reset();
            this.ad.moveTo(fArray2[0], fArray[0]);
            for (int i2 = 0; i2 < n4 - 3; i2 += 3) {
                this.ad.curveTo(fArray2[i2 + 1], fArray[i2 + 1], fArray2[i2 + 2], fArray[i2 + 2], fArray2[i2 + 3], fArray[i2 + 3]);
                if (!bl) {
                    if (!bl) continue;
                }
                break block12;
            }
            this.path.append(this.ad.getPathIterator(null, 0.75), false);
        }
        this.path = new GeneralPath(1, this.bendCount() + 4);
        return v.b(this, this.path, this.path, point2D, point2D2);
    }

    public void calcUnionRect(Rectangle2D rectangle2D) {
        block7: {
            Object object;
            Object object2;
            boolean bl;
            block8: {
                bl = NodeRealizer.z;
                super.calcUnionRect(rectangle2D);
                if (!this.isSelected()) break block8;
                for (object2 = this.bends.firstCell(); object2 != null; object2 = ((ListCell)object2).succ()) {
                    object = (Bend)((ListCell)object2).getInfo();
                    rectangle2D.add(((Bend)object).getX(), ((Bend)object).getY());
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break block7;
                }
                object2 = this.getSourceRealizer();
                object = this.getSourcePort();
                rectangle2D.add(((Port)object).getX((NodeRealizer)object2), ((Port)object).getY((NodeRealizer)object2));
                object2 = this.getTargetRealizer();
                object = this.getTargetPort();
                rectangle2D.add(((Port)object).getX((NodeRealizer)object2), ((Port)object).getY((NodeRealizer)object2));
                if (!bl) break block7;
            }
            for (object2 = this.bends.firstCell(); object2 != null; object2 = ((ListCell)object2).succ()) {
                object = (Bend)((ListCell)object2).getInfo();
                if (!((Bend)object).isSelected()) continue;
                rectangle2D.add(((Bend)object).getX(), ((Bend)object).getY());
                if (!bl) continue;
            }
        }
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        boolean bl = NodeRealizer.z;
        boolean bl2 = super.intersects(rectangle2D);
        if (!bl2) {
            boolean bl3;
            block9: {
                if (this.isSelected()) {
                    Object object;
                    Object object2;
                    for (object2 = this.bends.firstCell(); object2 != null; object2 = ((ListCell)object2).succ()) {
                        object = (Bend)((ListCell)object2).getInfo();
                        bl3 = rectangle2D.contains(((Bend)object).getX(), ((Bend)object).getY());
                        if (!bl) {
                            if (!bl3) continue;
                            return true;
                        }
                        break block9;
                    }
                    object2 = this.getSourceRealizer();
                    object = this.getSourcePort();
                    if (rectangle2D.contains(((Port)object).getX((NodeRealizer)object2), ((Port)object).getY((NodeRealizer)object2))) {
                        return true;
                    }
                    object2 = this.getTargetRealizer();
                    object = this.getTargetPort();
                    if (rectangle2D.contains(((Port)object).getX((NodeRealizer)object2), ((Port)object).getY((NodeRealizer)object2))) {
                        return true;
                    }
                } else {
                    for (ListCell listCell = this.bends.firstCell(); listCell != null; listCell = listCell.succ()) {
                        Bend bend = (Bend)listCell.getInfo();
                        bl3 = bend.isSelected();
                        if (!bl) {
                            if (!bl3 || !rectangle2D.contains(bend.getX(), bend.getY())) continue;
                            return true;
                        }
                        break block9;
                    }
                }
                bl3 = false;
            }
            return bl3;
        }
        return true;
    }

    protected void paintHighlightedBends(Graphics2D graphics2D) {
        super.c(graphics2D);
        super.paintHighlightedBends(graphics2D);
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(0);
        super.write(objectOutputStream);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 0: {
                super.read(objectInputStream);
                if (!NodeRealizer.z) break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }
}

