/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.util.Iterator;
import y.base.Node;
import y.util.FilterIterator;
import y.view.DefaultGraph2DTraversal;
import y.view.Graph2D;
import y.view.Graph2DTraversal;
import y.view.Graph2DView;
import y.view.HitInfo;
import y.view.HitInfoFactory;
import y.view.NodeLabel;
import y.view.NodePort;
import y.view.NodeRealizer;
import y.view.OrderRenderer;
import y.view.PortLabelModel;
import y.view.VisibilityFilter;

public class HitInfoFactories {

    public static class BackwardCompatibilityHitInfoFactory
    implements HitInfoFactory {
        private Graph2DView c;

        public BackwardCompatibilityHitInfoFactory(Graph2DView graph2DView) {
            this.c = graph2DView;
        }

        public HitInfo createHitInfo(double d2, double d3, int n2, boolean bl) {
            if (n2 == -1) {
                return new HitInfo(this.c, d2, d3, bl, 0, 1, 2, 3, 4, 6, 5);
            }
            if ((n2 & 4) != 0) {
                return new HitInfo(this.c, d2, d3, bl, 0);
            }
            if ((n2 & 8) != 0) {
                return new HitInfo(this.c, d2, d3, bl, 1);
            }
            if ((n2 & 0x20) != 0) {
                return new HitInfo(this.c, d2, d3, bl, 2);
            }
            if ((n2 & 2) != 0) {
                return new HitInfo(this.c, d2, d3, bl, 3);
            }
            if ((n2 & 1) != 0) {
                return new HitInfo(this.c, d2, d3, bl, 4);
            }
            if ((n2 & 0x10) != 0) {
                return new HitInfo(this.c, d2, d3, bl, 5);
            }
            if ((n2 & 0x40) != 0) {
                return new HitInfo(this.c, d2, d3, bl, 6);
            }
            throw new IllegalArgumentException("unknown types: " + n2);
        }
    }

    public static class DefaultHitInfoFactory
    implements HitInfoFactory {
        private Graph2DView b;

        public DefaultHitInfoFactory(Graph2DView graph2DView) {
            this.b = graph2DView;
        }

        public HitInfo createHitInfo(double d2, double d3, int n2, boolean bl) {
            HitInfo hitInfo = this.createHitInfo(this.getView(), this.getGraph(), d2, d3, n2, bl);
            if (bl && (n2 & 0x10) != 0 && hitInfo.hasHitNodeLabels() && !hitInfo.getHitNodeLabel().isSelected()) {
                NodePort nodePort;
                NodeLabel nodeLabel;
                NodeRealizer nodeRealizer;
                if ((n2 & 1) != 0 && (n2 & 0x40) != 0) {
                    NodeLabel nodeLabel2 = hitInfo.getHitNodeLabel();
                    NodeRealizer nodeRealizer2 = nodeLabel2.getRealizer();
                    if (nodeRealizer2 != null) {
                        if (nodeLabel2.getLabelModel() instanceof PortLabelModel) {
                            NodePort nodePort2 = PortLabelModel.getPort(nodeRealizer2, nodeLabel2.getModelParameter());
                            if (nodePort2 != null && nodePort2.isSelected() && nodePort2.contains(d2, d3)) {
                                return DefaultHitInfoFactory.b(nodePort2);
                            }
                            if (nodeRealizer2.getNode() != null && nodeRealizer2.contains(d2, d3)) {
                                return DefaultHitInfoFactory.b(nodeRealizer2.getNode());
                            }
                        } else if (nodeRealizer2.getNode() != null && nodeRealizer2.contains(d2, d3)) {
                            return DefaultHitInfoFactory.b(nodeRealizer2.getNode());
                        }
                    }
                } else if ((n2 & 1) != 0) {
                    NodeLabel nodeLabel3 = hitInfo.getHitNodeLabel();
                    NodeRealizer nodeRealizer3 = nodeLabel3.getRealizer();
                    if (nodeRealizer3 != null && nodeRealizer3.getNode() != null && nodeRealizer3.contains(d2, d3)) {
                        return DefaultHitInfoFactory.b(nodeRealizer3.getNode());
                    }
                } else if ((n2 & 0x40) != 0 && (nodeRealizer = (nodeLabel = hitInfo.getHitNodeLabel()).getRealizer()) != null && nodeLabel.getLabelModel() instanceof PortLabelModel && (nodePort = PortLabelModel.getPort(nodeRealizer, nodeLabel.getModelParameter())) != null && nodePort.isSelected() && nodePort.contains(d2, d3)) {
                    return DefaultHitInfoFactory.b(nodePort);
                }
            }
            return hitInfo;
        }

        protected HitInfo createHitInfo(Graph2DView graph2DView, Graph2D graph2D, double d2, double d3, int n2, boolean bl) {
            Iterator iterator2 = DefaultHitInfoFactory.b(graph2DView, graph2D, n2);
            return new HitInfo(graph2D, iterator2, d2, d3, bl);
        }

        protected Graph2DView getView() {
            return this.b;
        }

        protected Graph2D getGraph() {
            return this.getView().getGraph2D();
        }

        private static Iterator b(Graph2DView graph2DView, Graph2D graph2D, int n2) {
            Graph2DTraversal graph2DTraversal;
            block5: {
                block4: {
                    if (!(graph2DView.getGraph2DRenderer() instanceof OrderRenderer)) break block4;
                    OrderRenderer orderRenderer = (OrderRenderer)graph2DView.getGraph2DRenderer();
                    Graph2DTraversal graph2DTraversal2 = graph2DTraversal = graph2DView.getZoom() >= graph2DView.getPaintDetailThreshold() ? orderRenderer.getPaintOrder() : orderRenderer.getSloppyPaintOrder();
                    if (!NodeRealizer.z) break block5;
                }
                graph2DTraversal = new DefaultGraph2DTraversal();
            }
            if (!Boolean.TRUE.equals(graph2DView.getClientProperty("Graph2DView.hitTestInvisibleElements"))) {
                int n3 = 1;
                return new FilterIterator(graph2DTraversal.lastToFirst(graph2D, n2), new VisibilityFilter(graph2D, n3, n3, n3, n3));
            }
            return graph2DTraversal.lastToFirst(graph2D, n2);
        }

        private static HitInfo b(Node node) {
            HitInfo hitInfo = new HitInfo();
            hitInfo.addHitNode(node);
            return hitInfo;
        }

        private static HitInfo b(NodePort nodePort) {
            HitInfo hitInfo = new HitInfo();
            hitInfo.addHitNodePort(nodePort);
            return hitInfo;
        }
    }
}

