/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JComponent;
import y.base.YList;
import y.geom.YPoint;
import y.view.BackgroundRenderer;
import y.view.DefaultBackgroundRenderer;
import y.view.Drawable;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.NodeRealizer;
import y.view.ViewMode;

public class MagnifierViewMode
extends ViewMode {
    private _d zm;
    private double an = 2.0;
    private int vm = 100;
    private MouseWheelListener[] um;
    private MouseWheelListener ym;
    private boolean wm = true;
    private Graph2DView xm;

    public MagnifierViewMode() {
        this.setName("NAVIGATION_MAGNIFIER");
    }

    public void mouseMoved(double d2, double d3) {
        this.o(d2, d3);
    }

    public void mouseDraggedLeft(double d2, double d3) {
        this.o(d2, d3);
    }

    public void mouseDraggedRight(double d2, double d3) {
        this.o(d2, d3);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        super.mouseExited(mouseEvent);
        if (this.zm != null) {
            this.view.removeDrawable(this.zm);
            this.zm = null;
            this.view.updateView();
        }
    }

    protected Graph2DView createMagnifierView() {
        Graph2DView graph2DView = new Graph2DView(this.getGraph2D());
        graph2DView.setAntialiasedPainting(this.view.isAntialiasedPainting());
        graph2DView.setGridVisible(this.view.isGridVisible());
        graph2DView.setGridResolution(this.view.getGridResolution());
        graph2DView.setGridColor(this.view.getGridColor());
        graph2DView.setGridType(this.view.getGridType());
        graph2DView.setGraph2DRenderer(this.view.getGraph2DRenderer());
        graph2DView.setPaintDetailThreshold(0.0);
        graph2DView.setScrollBarPolicy(21, 31);
        graph2DView.setBackgroundRenderer(new _c(graph2DView, this.view));
        return graph2DView;
    }

    public void activate(boolean bl) {
        block14: {
            int n2;
            JComponent jComponent;
            boolean bl2;
            block13: {
                bl2 = NodeRealizer.z;
                if (!bl) break block13;
                jComponent = this.view.getCanvasComponent();
                if (this.wm) {
                    block12: {
                        this.um = jComponent.getMouseWheelListeners();
                        for (n2 = 0; n2 < this.um.length; ++n2) {
                            jComponent.removeMouseWheelListener(this.um[n2]);
                            if (!bl2) {
                                if (!bl2) continue;
                            }
                            break block12;
                        }
                        this.ym = new _b();
                    }
                    jComponent.addMouseWheelListener(this.ym);
                }
                this.setEditing(true);
                if (!bl2) break block14;
            }
            this.setEditing(false);
            this.view.removeDrawable(this.zm);
            this.zm = null;
            this.getGraph2D().removeView(this.xm);
            this.xm = null;
            jComponent = this.view.getCanvasComponent();
            if (this.wm) {
                if (this.ym != null) {
                    jComponent.removeMouseWheelListener(this.ym);
                    this.ym = null;
                }
                for (n2 = 0; n2 < this.um.length; ++n2) {
                    jComponent.addMouseWheelListener(this.um[n2]);
                    if (!bl2) {
                        if (!bl2) continue;
                    }
                    break;
                }
            } else {
                this.view.updateView();
            }
        }
    }

    private void o(double d2, double d3) {
        if (!this.isEditing()) {
            this.setEditing(true);
        }
        if (this.zm == null) {
            this.xm = this.createMagnifierView();
            this.zm = new _d(this.xm);
            this.zm.c(this.an);
            this.zm.b(this.vm);
            this.view.addDrawable(this.zm);
            this.zm.b(new YPoint(d2, d3));
        }
        Rectangle2D rectangle2D = this.zm.n();
        this.zm.b(new YPoint(d2, d3));
        rectangle2D.add(this.zm.n());
        double d4 = 5.0 / this.view.getZoom();
        rectangle2D.setFrame(rectangle2D.getX() - d4, rectangle2D.getY() - d4, rectangle2D.getWidth() + 2.0 * d4, rectangle2D.getHeight() + 2.0 * d4);
        this.view.updateView(rectangle2D);
    }

    public void setMagnifierZoomFactor(double d2) {
        if (this.an != d2) {
            this.an = d2;
            if (this.zm != null) {
                this.zm.c(d2);
                this.view.updateView();
            }
        }
    }

    public double getMagnifierZoomFactor() {
        return this.an;
    }

    public void setMagnifierRadius(int n2) {
        if (n2 != this.vm) {
            this.vm = n2;
            if (this.zm != null) {
                this.zm.b(this.vm);
                this.view.updateView();
            }
        }
    }

    public int getMagnifierRadius() {
        return this.vm;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        block9: {
            int n2;
            block10: {
                boolean bl;
                block8: {
                    block7: {
                        bl = NodeRealizer.z;
                        n2 = 0;
                        if (mouseWheelEvent.getScrollType() != 1) break block7;
                        n2 = mouseWheelEvent.getWheelRotation();
                        if (!bl) break block8;
                    }
                    if (mouseWheelEvent.getScrollType() == 0) {
                        n2 = mouseWheelEvent.getUnitsToScroll();
                    }
                }
                if (n2 == 0) break block9;
                if ((mouseWheelEvent.getModifiers() & 2) != 0) break block10;
                double d2 = this.calcZoom(this.an, n2);
                this.setMagnifierZoomFactor(d2);
                if (!bl) break block9;
            }
            int n3 = this.calcRadius(this.vm, n2);
            this.setMagnifierRadius(n3);
        }
    }

    protected int calcRadius(int n2, int n3) {
        int n4 = 10;
        if (n3 == 0) {
            return n2;
        }
        return Math.max(n4, n2 + n3 * n4);
    }

    protected double calcZoom(double d2, int n2) {
        if (n2 == 0) {
            return d2;
        }
        double d3 = n2 > 0 ? d2 / 1.25 : d2 * 1.25;
        return Math.max(1.0, d3);
    }

    public boolean isMouseWheelEnabled() {
        return this.wm;
    }

    public void setMouseWheelEnabled(boolean bl) {
        this.wm = bl;
    }

    private static final class _c
    extends DefaultBackgroundRenderer {
        private final Graph2DView n;

        _c(Graph2DView graph2DView, Graph2DView graph2DView2) {
            super(graph2DView);
            this.n = graph2DView2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paint(Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
            this.b(this.n);
            try {
                super.paint(graphics2D, n2, n3, n4, n5);
            }
            finally {
                this.b();
            }
        }

        protected void undoWorldTransform(Graphics2D graphics2D) {
        }

        protected void redoWorldTransform(Graphics2D graphics2D) {
        }

        void c(Graphics2D graphics2D) {
            this.undoWorldTransform(graphics2D);
            Image image = this.getImage();
            int n2 = image.getWidth(null);
            int n3 = image.getHeight(null);
            int n4 = this.n.getWidth();
            int n5 = this.n.getHeight();
            graphics2D.drawImage(image, (n4 - n2) / 2, (n5 - n3) / 2, null);
        }

        private void b(Graph2DView graph2DView) {
            BackgroundRenderer backgroundRenderer = graph2DView.getBackgroundRenderer();
            if (backgroundRenderer instanceof DefaultBackgroundRenderer) {
                this.b((DefaultBackgroundRenderer)backgroundRenderer);
            }
        }

        private void b(DefaultBackgroundRenderer defaultBackgroundRenderer) {
            this.setColor(defaultBackgroundRenderer.getColor());
            this.setImage(defaultBackgroundRenderer.getImage());
            Point point = defaultBackgroundRenderer.getImageOrigin();
            this.setImageOrigin(point.getX(), point.getY());
            this.setMode(defaultBackgroundRenderer.getMode());
        }

        private void b() {
            this.setColor(Color.WHITE);
            this.setImage(null);
            this.setImageOrigin(0.0, 0.0);
            this.setMode((byte)4);
        }
    }

    class _b
    implements MouseWheelListener {
        _b() {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            MagnifierViewMode.this.mouseWheelMoved(mouseWheelEvent);
        }
    }

    class _d
    implements Drawable {
        private static final int kb = 0xFFFFFF;
        private YPoint ib;
        private int nb = 100;
        private double jb = 2.0;
        private Graph2DView pb;
        private BufferedImage lb;
        private boolean mb = true;
        YList ob = new YList();

        _d(Graph2DView graph2DView) {
            this.ib = YPoint.ORIGIN;
            this.pb = graph2DView;
        }

        public void paint(Graphics2D graphics2D) {
            double d2;
            Ellipse2D.Double double_;
            Graphics2D graphics2D2;
            block10: {
                AffineTransform affineTransform;
                Shape shape;
                block12: {
                    Rectangle2D rectangle2D;
                    block11: {
                        boolean bl;
                        block9: {
                            int n2;
                            bl = NodeRealizer.z;
                            if (this.mb) {
                                MagnifierViewMode.this.view.addDrawable(this);
                                MagnifierViewMode.this.view.removeDrawable(this);
                                this.mb = false;
                                return;
                            }
                            this.mb = true;
                            graphics2D2 = (Graphics2D)graphics2D.create();
                            rectangle2D = this.n();
                            double_ = new Ellipse2D.Double();
                            double_.setFrame(rectangle2D);
                            double d3 = MagnifierViewMode.this.view.getZoom();
                            d2 = 1.0 / d3;
                            if (this.jb == 1.0) break block10;
                            shape = graphics2D2.getClip();
                            affineTransform = graphics2D2.getTransform();
                            if (MagnifierViewMode.this.view.getClientProperty("MagnifierViewMode.noDoubleBuffering") != null) break block11;
                            graphics2D2.translate(rectangle2D.getX(), rectangle2D.getY());
                            int n3 = this.nb;
                            int n4 = 2 * n3;
                            if (this.lb == null || this.lb.getWidth() < n4 || this.lb.getHeight() < n4) {
                                this.lb = this.b(graphics2D2, n4, n4);
                            }
                            Graphics2D graphics2D3 = this.lb.createGraphics();
                            graphics2D3.addRenderingHints(graphics2D2.getRenderingHints());
                            graphics2D3.setClip(0, 0, n4, n4);
                            this.j();
                            Graph2D graph2D = MagnifierViewMode.this.getGraph2D();
                            this.pb.setGraph2D(graph2D);
                            this.pb.setSize(n4, n4);
                            this.pb.setZoom(this.jb * d3);
                            this.pb.setCenter(this.ib.x, this.ib.y);
                            this.pb.paintVisibleContent(graphics2D3);
                            graph2D.removeView(this.pb);
                            this.k();
                            graphics2D3.dispose();
                            int n5 = n3 * n3;
                            int n6 = 0;
                            block0: while (true) {
                                int n7 = n6;
                                int n8 = n4;
                                block1: while (n7 < n8) {
                                    n2 = 0;
                                    if (bl) break block9;
                                    for (int i2 = v5504698; i2 < n4; ++i2) {
                                        int n9 = n6 - n3;
                                        int n10 = i2 - n3;
                                        n7 = n9 * n9 + n10 * n10;
                                        n8 = n5;
                                        if (bl) continue block1;
                                        if (n7 > n8) {
                                            this.lb.setRGB(n6, i2, 0xFFFFFF);
                                            if (!bl) continue;
                                        }
                                        i2 = Math.max(i2, n4 - i2);
                                        if (!bl) continue;
                                    }
                                    ++n6;
                                    if (!bl) continue block0;
                                }
                                break;
                            }
                            graphics2D2.scale(d2, d2);
                            n2 = graphics2D2.drawImage(this.lb, 0, 0, n4, n4, 0, 0, n4, n4, null) ? 1 : 0;
                        }
                        if (!bl) break block12;
                    }
                    graphics2D2.clip(double_);
                    graphics2D2.translate(rectangle2D.getX(), rectangle2D.getY());
                    this.i(graphics2D2);
                }
                graphics2D2.setTransform(affineTransform);
                graphics2D2.setClip(shape);
            }
            graphics2D2.setColor(Color.BLACK);
            graphics2D2.setStroke(new BasicStroke((float)(1.5 * d2)));
            graphics2D2.draw(double_);
            graphics2D2.dispose();
        }

        private void i(Graphics2D graphics2D) {
            this.j();
            Graph2D graph2D = MagnifierViewMode.this.getGraph2D();
            this.pb.setGraph2D(graph2D);
            double d2 = 20.0 / MagnifierViewMode.this.view.getZoom();
            this.pb.setSize((int)((double)(2 * this.nb) / MagnifierViewMode.this.view.getZoom()), (int)((double)(2 * this.nb) / MagnifierViewMode.this.view.getZoom()));
            this.pb.setZoom(this.jb);
            this.pb.setCenter(this.ib.x, this.ib.y);
            this.pb.setSize((int)((double)(2 * this.nb) / MagnifierViewMode.this.view.getZoom()), (int)((double)(2 * this.nb) / MagnifierViewMode.this.view.getZoom() + d2));
            this.pb.paintVisibleContent(graphics2D);
            graph2D.removeView(this.pb);
            this.k();
        }

        public Rectangle2D n() {
            Rectangle2D.Double double_ = new Rectangle2D.Double();
            double d2 = (double)this.nb / MagnifierViewMode.this.view.getZoom();
            double_.setFrame(this.ib.x - d2, this.ib.y - d2, 2.0 * d2, 2.0 * d2);
            return double_;
        }

        public void j() {
            boolean bl = NodeRealizer.z;
            Collection collection = MagnifierViewMode.this.view.getDrawables();
            Iterator iterator2 = collection.iterator();
            while (iterator2.hasNext()) {
                Drawable drawable = (Drawable)iterator2.next();
                if (drawable == MagnifierViewMode.this.zm) continue;
                this.ob.push(drawable);
                this.pb.addDrawable(drawable);
                if (!bl) continue;
            }
        }

        public void k() {
            boolean bl = NodeRealizer.z;
            while (!this.ob.isEmpty()) {
                Drawable drawable = (Drawable)this.ob.pop();
                this.pb.removeDrawable(drawable);
                if (!bl) continue;
            }
        }

        public Rectangle getBounds() {
            Rectangle rectangle = new Rectangle();
            rectangle.setFrame(this.n());
            return rectangle;
        }

        public void b(YPoint yPoint) {
            this.ib = yPoint;
        }

        public YPoint l() {
            return this.ib;
        }

        public int o() {
            return this.nb;
        }

        public void b(int n2) {
            this.nb = n2;
        }

        public double m() {
            return this.jb;
        }

        public void c(double d2) {
            this.jb = d2;
        }

        private BufferedImage b(Graphics2D graphics2D, int n2, int n3) {
            GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
            if (graphicsConfiguration != null) {
                return graphicsConfiguration.createCompatibleImage(n2, n3, 3);
            }
            return new BufferedImage(n2, n3, 2);
        }
    }
}

