/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import y.view.Graph2DView;
import y.view.NodeRealizer;

public class NavigationComponent
extends JPanel {
    public static final byte ORIENTATION_TOP_TO_BOTTOM = 0;
    public static final byte ORIENTATION_LEFT_TO_RIGHT = 1;
    public static final byte ORIENTATION_BOTTOM_TO_TOP = 2;
    public static final byte ORIENTATION_RIGHT_TO_LEFT = 3;
    public static final String CLIENT_PROPERTY_KEY_SCROLL_TIMER_DELAY = "NavigationComponent.ScrollTimerDelay";
    public static final String CLIENT_PROPERTY_KEY_SCROLL_TIMER_INITIAL_DELAY = "NavigationComponent.ScrollTimerInitialDelay";
    public static final String CLIENT_PROPERTY_KEY_ZOOM_TIMER_DELAY = "NavigationComponent.ZoomTimerDelay";
    public static final String CLIENT_PROPERTY_KEY_ZOOM_TIMER_INITIAL_DELAY = "NavigationComponent.ZoomTimerInitialDelay";
    protected static final byte SCROLL_DIRECTION_UP = 1;
    protected static final byte SCROLL_DIRECTION_DOWN = 2;
    protected static final byte SCROLL_DIRECTION_RIGHT = 4;
    protected static final byte SCROLL_DIRECTION_LEFT = 8;
    protected final Graph2DView view;
    private boolean e = true;
    private boolean i = true;
    private boolean j = true;
    private boolean b;
    private boolean n = true;
    private double o = 10.0;
    private boolean l = true;
    private byte d = 0;
    private boolean g;
    private double k = 15.0;
    private double c = 0.1;
    private double m = 1.1;
    private final int f = 100;
    private JSlider h;
    static /* synthetic */ Class class$y$view$NavigationComponent;

    public NavigationComponent(Graph2DView graph2DView) {
        this.view = graph2DView;
        this.setCursor(Cursor.getDefaultCursor());
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setOpaque(false);
        Color color = this.getBackground();
        this.setBackground(new Color(color.getRed(), color.getGreen(), color.getBlue(), 0));
        this.updateComponents();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getBackground() != null) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void updateComponents() {
        this.removeAll();
        byte by = this.getOrientation();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.e) {
            gridBagConstraints.gridx = by == 3 ? 5 : 1;
            gridBagConstraints.gridy = by == 2 ? 4 : 0;
            this.add((Component)this.createScrollButton((byte)1), gridBagConstraints);
            gridBagConstraints.gridx = by == 3 ? 6 : 2;
            gridBagConstraints.gridy = by == 2 ? 5 : 1;
            this.add((Component)this.createScrollButton((byte)4), gridBagConstraints);
            gridBagConstraints.gridx = by == 3 ? 5 : 1;
            gridBagConstraints.gridy = by == 2 ? 6 : 2;
            this.add((Component)this.createScrollButton((byte)2), gridBagConstraints);
            gridBagConstraints.gridx = by == 3 ? 4 : 0;
            gridBagConstraints.gridy = by == 2 ? 5 : 1;
            this.add((Component)this.createScrollButton((byte)8), gridBagConstraints);
            if (this.n) {
                gridBagConstraints.gridx = by == 3 ? 5 : 1;
                gridBagConstraints.gridy = by == 2 ? 5 : 1;
                this.add((Component)this.createFitContentButton(), gridBagConstraints);
            }
        }
        if (this.i) {
            gridBagConstraints.gridx = by == 3 || by == 1 ? 3 : 1;
            gridBagConstraints.gridy = by == 2 || by == 0 ? 3 : 4;
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            jPanel.setBackground(null);
            this.add((Component)jPanel, gridBagConstraints);
            int n2 = by == 3 ? 2 : (gridBagConstraints.gridx = by == 1 ? 6 : 1);
            gridBagConstraints.gridy = by == 0 ? 4 : (by == 2 ? 0 : 1);
            this.add((Component)this.createZoomButton(true), gridBagConstraints);
            int n3 = by == 3 ? 0 : (gridBagConstraints.gridx = by == 1 ? 4 : 1);
            gridBagConstraints.gridy = by == 0 ? 6 : (by == 2 ? 2 : 1);
            this.add((Component)this.createZoomButton(false), gridBagConstraints);
        }
        if (this.j) {
            gridBagConstraints.gridx = by == 3 ? 1 : (by == 1 ? 5 : 1);
            gridBagConstraints.gridy = by == 0 ? 5 : 1;
            gridBagConstraints.weighty = by == 0 || by == 2 ? 1.0 : 0.0;
            double d2 = gridBagConstraints.weightx = by == 1 || by == 3 ? 1.0 : 0.0;
            int n4 = by == 1 || by == 3 ? 1 : (gridBagConstraints.gridwidth = this.b ? 3 : 1);
            gridBagConstraints.gridheight = by == 0 || by == 2 ? 1 : (this.b ? 3 : 1);
            gridBagConstraints.fill = 1;
            this.h = this.createZoomSlider(by);
            this.add((Component)this.h, gridBagConstraints);
        }
    }

    protected JButton createScrollButton(byte by) {
        Action action2 = this.createScrollAction(by);
        JButton jButton = new JButton(action2);
        jButton.addMouseListener(new _f(action2, CLIENT_PROPERTY_KEY_SCROLL_TIMER_DELAY, CLIENT_PROPERTY_KEY_SCROLL_TIMER_INITIAL_DELAY));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    protected Action createScrollAction(byte by) {
        return new _b(this, by, this.createScrollIcon(by));
    }

    protected Icon createScrollIcon(final byte by) {
        URL uRL;
        boolean bl = NodeRealizer.z;
        String string2 = "";
        switch (by) {
            default: {
                string2 = "resource/nav_up.png";
                if (!bl) break;
            }
            case 4: {
                string2 = "resource/nav_right.png";
                if (!bl) break;
            }
            case 2: {
                string2 = "resource/nav_down.png";
                if (!bl) break;
            }
            case 8: {
                string2 = "resource/nav_left.png";
            }
        }
        if ((uRL = this.b(string2)) != null) {
            return new ImageIcon(uRL);
        }
        return new Icon(){

            public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
                boolean bl = NodeRealizer.z;
                graphics = graphics.create();
                graphics.setColor(Color.white);
                graphics.fillRect(n2 + 1, n3 + 1, 14, 14);
                graphics.setColor(Color.black);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Polygon polygon = new Polygon();
                switch (by) {
                    default: {
                        polygon.addPoint(n2 + 4, n3 + 12);
                        polygon.addPoint(n2 + 12, n3 + 12);
                        polygon.addPoint(n2 + 8, n3 + 2);
                        if (!bl) break;
                    }
                    case 4: {
                        polygon.addPoint(n2 + 4, n3 + 4);
                        polygon.addPoint(n2 + 4, n3 + 12);
                        polygon.addPoint(n2 + 14, n3 + 8);
                        if (!bl) break;
                    }
                    case 2: {
                        polygon.addPoint(n2 + 4, n3 + 4);
                        polygon.addPoint(n2 + 12, n3 + 4);
                        polygon.addPoint(n2 + 8, n3 + 14);
                        if (!bl) break;
                    }
                    case 8: {
                        polygon.addPoint(n2 + 12, n3 + 4);
                        polygon.addPoint(n2 + 12, n3 + 12);
                        polygon.addPoint(n2 + 2, n3 + 8);
                    }
                }
                graphics.fillPolygon(polygon);
                graphics.dispose();
            }

            public int getIconWidth() {
                return 16;
            }

            public int getIconHeight() {
                return 16;
            }
        };
    }

    protected JButton createFitContentButton() {
        Action action2 = this.createFitContentAction();
        JButton jButton = new JButton(action2);
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    protected Action createFitContentAction() {
        return new _g(this.createFitContentIcon());
    }

    protected Icon createFitContentIcon() {
        URL uRL = this.b("resource/nav_fit.png");
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return new Icon(){

            public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
                graphics = graphics.create();
                graphics.setColor(Color.white);
                graphics.fillRect(n2 + 1, n3 + 1, 14, 14);
                graphics.setColor(Color.black);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.fillOval(n2 + 2, n3 + 2, 12, 12);
                graphics.dispose();
            }

            public int getIconWidth() {
                return 16;
            }

            public int getIconHeight() {
                return 16;
            }
        };
    }

    protected JButton createZoomButton(boolean bl) {
        Action action2 = this.createZoomAction(bl);
        JButton jButton = new JButton(action2);
        jButton.addMouseListener(new _f(action2, CLIENT_PROPERTY_KEY_ZOOM_TIMER_DELAY, CLIENT_PROPERTY_KEY_ZOOM_TIMER_INITIAL_DELAY));
        jButton.setContentAreaFilled(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    protected Action createZoomAction(boolean bl) {
        double d2 = this.getButtonZoomFactor();
        double d3 = bl ? d2 : 1.0 / d2;
        return new _d(d3, this.createZoomIcon(bl));
    }

    protected Icon createZoomIcon(final boolean bl) {
        URL uRL;
        String string2;
        block5: {
            block4: {
                string2 = "";
                if (!bl) break block4;
                string2 = "resource/nav_plus.png";
                if (!NodeRealizer.z) break block5;
            }
            string2 = "resource/nav_minus.png";
        }
        if ((uRL = this.b(string2)) != null) {
            return new ImageIcon(uRL);
        }
        return new Icon(){

            public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
                block3: {
                    block2: {
                        graphics = graphics.create();
                        graphics.setColor(Color.white);
                        graphics.fillRect(n2 + 1, n3 + 1, 14, 14);
                        graphics.setColor(Color.black);
                        if (!bl) break block2;
                        graphics.drawLine(n2 + 8, n3 + 4, n2 + 8, n3 + 12);
                        graphics.drawLine(n2 + 4, n3 + 8, n2 + 12, n3 + 8);
                        if (!NodeRealizer.z) break block3;
                    }
                    graphics.drawLine(n2 + 4, n3 + 8, n2 + 12, n3 + 8);
                }
                graphics.dispose();
            }

            public int getIconWidth() {
                return 16;
            }

            public int getIconHeight() {
                return 16;
            }
        };
    }

    protected JSlider createZoomSlider(byte by) {
        Object object;
        JSlider jSlider;
        block5: {
            block4: {
                double d2 = this.getMinZoomLevel();
                double d3 = this.getMaxZoomLevel();
                int n2 = (int)Math.floor(Math.log(d2) / Math.log(10.0) * 100.0);
                int n3 = (int)Math.ceil(Math.log(d3) / Math.log(10.0) * 100.0);
                jSlider = new JSlider(1, n2, n3, n2 <= 1 ? 1 : n2);
                jSlider.setOpaque(false);
                jSlider.setBackground(null);
                jSlider.setMajorTickSpacing(1000);
                jSlider.setMinorTickSpacing(100);
                jSlider.setSnapToTicks(false);
                jSlider.setOpaque(false);
                jSlider.setPaintTicks(this.b);
                jSlider.setPaintLabels(this.b);
                if (this.b) {
                    object = new Hashtable<Integer, JLabel>();
                    ((Hashtable)object).put(new Integer(0), new JLabel("1.0"));
                    ((Hashtable)object).put(new Integer(n2), new JLabel(String.valueOf(d2)));
                    ((Hashtable)object).put(new Integer(n3), new JLabel(String.valueOf(d3)));
                    jSlider.setLabelTable((Dictionary)object);
                }
                if (by != 1 && by != 3) break block4;
                jSlider.setOrientation(0);
                jSlider.setPreferredSize(new Dimension(100, (int)jSlider.getPreferredSize().getHeight()));
                if (!NodeRealizer.z) break block5;
            }
            jSlider.setPreferredSize(new Dimension((int)jSlider.getPreferredSize().getWidth(), 100));
        }
        object = new _e();
        jSlider.addChangeListener((ChangeListener)object);
        _c _c2 = new _c(jSlider);
        this.view.getCanvasComponent().addPropertyChangeListener("Zoom", _c2);
        return jSlider;
    }

    private URL b(String string2) {
        Class clazz = class$y$view$NavigationComponent == null ? (class$y$view$NavigationComponent = NavigationComponent.class$("y.view.NavigationComponent")) : class$y$view$NavigationComponent;
        URL uRL = clazz.getResource(string2);
        if (uRL == null) {
            ClassLoader classLoader = clazz.getClassLoader();
            URL uRL2 = classLoader.getResource("y/view/" + string2);
            if (uRL2 == null) {
                String string3;
                Package package_ = clazz.getPackage();
                String string4 = string3 = package_ == null ? "" : package_.getName();
                if (string3.length() == 0) {
                    return classLoader.getResource(string2);
                }
                return classLoader.getResource(string3.replace('.', '/') + "/" + string2);
            }
            return uRL2;
        }
        return uRL;
    }

    public boolean isShowNavigationControls() {
        return this.e;
    }

    public void setShowNavigationControls(boolean bl) {
        if (this.e != bl) {
            this.e = bl;
            this.updateComponents();
        }
    }

    public boolean isShowFitContentButton() {
        return this.n;
    }

    public void setShowFitContentButton(boolean bl) {
        if (this.n != bl) {
            this.n = bl;
            this.updateComponents();
        }
    }

    public boolean isShowZoomButtons() {
        return this.i;
    }

    public void setShowZoomButtons(boolean bl) {
        if (this.i != bl) {
            this.i = bl;
            this.updateComponents();
        }
    }

    public boolean isShowZoomSlider() {
        return this.j;
    }

    public void setShowZoomSlider(boolean bl) {
        if (this.j != bl) {
            this.j = bl;
            this.updateComponents();
        }
    }

    public double getScrollStepSize() {
        return this.o;
    }

    public void setScrollStepSize(double d2) {
        if (d2 != this.o) {
            this.o = d2;
            this.updateComponents();
        }
    }

    public void setButtonZoomFactor(double d2) {
        if (d2 <= 1.0) {
            throw new IllegalArgumentException("zoom factor must be greater than 1");
        }
        if (this.m != d2) {
            this.m = d2;
            this.updateComponents();
        }
    }

    public double getButtonZoomFactor() {
        return this.m;
    }

    public void setShowLabelsOnSlider(boolean bl) {
        if (this.b != bl) {
            this.b = bl;
            this.updateComponents();
        }
    }

    public boolean isShowLabelsOnSlider() {
        return this.b;
    }

    public void setMaxZoomLevel(double d2) {
        block2: {
            block3: {
                if (this.k == d2) break block2;
                this.k = d2;
                if (this.h != null) break block3;
                this.updateComponents();
                if (!NodeRealizer.z) break block2;
            }
            this.b(this.getMinZoomLevel(), d2);
        }
    }

    public double getMaxZoomLevel() {
        return this.k;
    }

    public void setMinZoomLevel(double d2) {
        block2: {
            block3: {
                if (this.c == d2) break block2;
                this.c = d2;
                if (this.h != null) break block3;
                this.updateComponents();
                if (!NodeRealizer.z) break block2;
            }
            this.b(d2, this.getMaxZoomLevel());
        }
    }

    public double getMinZoomLevel() {
        return this.c;
    }

    private void b(double d2, double d3) {
        int n2 = (int)Math.floor(Math.log(d2) / Math.log(10.0) * 100.0);
        int n3 = (int)Math.ceil(Math.log(d3) / Math.log(10.0) * 100.0);
        this.h.setMinimum(n2);
        this.h.setMaximum(n3);
        if (this.b) {
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(new Integer(0), new JLabel("1.0"));
            hashtable.put(new Integer(n2), new JLabel(String.valueOf(d2)));
            hashtable.put(new Integer(n3), new JLabel(String.valueOf(d3)));
            this.h.setLabelTable(hashtable);
        }
    }

    public byte getOrientation() {
        return this.d;
    }

    public void setOrientation(byte by) {
        if (this.d != by) {
            this.d = by;
            this.updateComponents();
        }
    }

    public boolean isConsiderZoomLevel() {
        return this.l;
    }

    public void setConsiderZoomLevel(boolean bl) {
        this.l = bl;
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class _f
    implements MouseListener {
        Timer d;
        private final Action c;
        private final String f;
        private final String e;
        private final int g = 60;
        private final int b = 300;

        public _f(Action action2) {
            this(action2, null, null);
        }

        public _f(Action action2, String string2, String string3) {
            this.c = action2;
            this.f = string2;
            this.e = string3;
            this.d = new Timer(60, action2);
            this.d.setInitialDelay(300);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            if (this.f != null && this.f.trim().length() > 0 && (object = NavigationComponent.this.getClientProperty(this.f)) != null && object instanceof Number) {
                this.d.setDelay(((Number)object).intValue());
            }
            if (this.e != null && this.e.trim().length() > 0 && (object = NavigationComponent.this.getClientProperty(this.e)) != null && object instanceof Number) {
                this.d.setInitialDelay(((Number)object).intValue());
            }
            this.d.start();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.c.actionPerformed(null);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.d.stop();
        }
    }

    private class _g
    extends AbstractAction
    implements PropertyChangeListener {
        private boolean b;
        private double d;
        private Point2D e;
        private boolean f;
        private boolean c;

        public _g(Icon icon) {
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            }
            this.putValue("ShortDescription", "Toggle Fit Content");
            NavigationComponent.this.view.r().addPropertyChangeListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            block5: {
                block4: {
                    this.f = true;
                    Object object = NavigationComponent.this.getClientProperty("NavigationComponent.AnimateFitContent");
                    if (object != null) {
                        this.c = "True".equalsIgnoreCase(String.valueOf(object));
                    }
                    if (!this.b) break block4;
                    NavigationComponent.this.view.focusView(this.d, new Point2D.Double(this.e.getX(), this.e.getY()), this.c);
                    this.b = false;
                    NavigationComponent.this.view.updateView();
                    if (!NodeRealizer.z) break block5;
                }
                this.b = true;
                this.d = NavigationComponent.this.view.getZoom();
                this.e = NavigationComponent.this.view.getCenter();
                NavigationComponent.this.view.fitContent(this.c);
                NavigationComponent.this.view.updateView();
            }
            this.f = false;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (("Zoom".equals(propertyChangeEvent.getPropertyName()) || "ViewPoint".equals(propertyChangeEvent.getPropertyName()) || "Bounds".equals(propertyChangeEvent.getPropertyName())) && !this.f) {
                this.b = false;
            }
        }
    }

    private class _d
    extends AbstractAction {
        final Timer c;
        private final double b;

        public _d(double d2, Icon icon) {
            block6: {
                block5: {
                    this.b = d2;
                    if (icon != null) {
                        this.putValue("SmallIcon", icon);
                    }
                    if (d2 <= 0.0) {
                        throw new IllegalArgumentException("Zoom factor must be greater than 0. Factors between 0 and 1 will cause a zoom out, a factor greater than 1 will lead to a zoom in..");
                    }
                    if (!(d2 > 1.0)) break block5;
                    this.putValue("ShortDescription", "Zoom In");
                    if (!NodeRealizer.z) break block6;
                }
                this.putValue("ShortDescription", "Zoom Out");
            }
            this.c = new Timer(60, this);
            this.c.setInitialDelay(300);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            double d2;
            double d3;
            double d4 = NavigationComponent.this.view.getZoom() * this.b;
            if (d4 > (d3 = NavigationComponent.this.getMaxZoomLevel())) {
                d4 = d3;
            }
            if (d4 < (d2 = NavigationComponent.this.getMinZoomLevel())) {
                d4 = d2;
            }
            NavigationComponent.this.view.setZoom(d4);
            NavigationComponent.this.view.updateView();
        }
    }

    private class _b
    extends AbstractAction {
        final Timer b;
        private final byte c;
        private final /* synthetic */ NavigationComponent this$0;

        public _b(NavigationComponent navigationComponent, byte by, Icon icon) {
            boolean bl = NodeRealizer.z;
            this.this$0 = navigationComponent;
            this.c = by;
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            }
            switch (by) {
                case 1: {
                    this.putValue("ShortDescription", "Navigate Up");
                    if (!bl) break;
                }
                case 4: {
                    this.putValue("ShortDescription", "Navigate Right");
                    if (!bl) break;
                }
                default: {
                    this.putValue("ShortDescription", "Navigate Down");
                    if (!bl) break;
                }
                case 8: {
                    this.putValue("ShortDescription", "Navigate Left");
                }
            }
            this.b = new Timer(30, this);
            this.b.setRepeats(true);
            this.b.setInitialDelay(300);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            double d2;
            double d3;
            boolean bl = NodeRealizer.z;
            Point2D point2D = this.this$0.view.getViewPoint2D();
            double d4 = this.this$0.getScrollStepSize();
            switch (this.c) {
                case 1: {
                    d3 = 0.0;
                    d2 = -d4;
                    if (!bl) break;
                }
                case 4: {
                    d3 = d4;
                    d2 = 0.0;
                    if (!bl) break;
                }
                default: {
                    d3 = 0.0;
                    d2 = d4;
                    if (!bl) break;
                }
                case 8: {
                    d3 = -d4;
                    d2 = 0.0;
                }
            }
            if (this.this$0.l) {
                d3 /= this.this$0.view.getZoom();
                d2 /= this.this$0.view.getZoom();
            }
            this.this$0.view.setViewPoint2D(point2D.getX() + d3, point2D.getY() + d2);
            this.this$0.view.updateView();
        }

        public byte c() {
            return this.c;
        }

        public Timer b() {
            return this.b;
        }
    }

    private class _e
    implements ChangeListener {
        private _e() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!NavigationComponent.this.g) {
                NavigationComponent.this.g = true;
                JSlider jSlider = (JSlider)changeEvent.getSource();
                double d2 = jSlider.getValue();
                double d3 = Math.pow(10.0, d2 / 100.0);
                NavigationComponent.this.view.setZoom(d3);
                NavigationComponent.this.view.updateView();
                NavigationComponent.this.g = false;
            }
        }
    }

    private class _c
    implements PropertyChangeListener {
        private final JSlider b;

        public _c(JSlider jSlider) {
            this.b = jSlider;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block2: {
                block5: {
                    block3: {
                        boolean bl;
                        block4: {
                            bl = NodeRealizer.z;
                            if (!"Zoom".equals(propertyChangeEvent.getPropertyName())) break block2;
                            double d2 = (Double)propertyChangeEvent.getNewValue();
                            double d3 = Math.log(d2) / Math.log(10.0) * 100.0;
                            if (NavigationComponent.this.g) break block2;
                            NavigationComponent.this.g = true;
                            if (!(d3 < (double)this.b.getMaximum())) break block3;
                            if (!(d3 > (double)this.b.getMinimum())) break block4;
                            this.b.setValue((int)d3);
                            if (!bl) break block5;
                        }
                        this.b.setValue(this.b.getMinimum());
                        if (!bl) break block5;
                    }
                    this.b.setValue(this.b.getMaximum());
                }
                NavigationComponent.this.g = false;
            }
        }
    }
}

