/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import y.base.DataMap;
import y.base.Edge;
import y.base.Node;
import y.base.NodeCursor;
import y.geom.YPoint;
import y.layout.PortConstraint;
import y.view.Bend;
import y.view.BendCursor;
import y.view.CompositeDrawable;
import y.view.Drawable;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.MoveSelectionMode;
import y.view.NodeRealizer;
import y.view.ShapeDrawable;
import y.view.ViewContainer;

public class PortAssignmentMoveSelectionMode
extends MoveSelectionMode {
    private float xd = 500.0f;
    protected DataMap spc;
    protected DataMap tpc;
    protected Drawable hintDrawable;
    private boolean wd = true;
    private Bend yd;
    private static final PortConstraint[] zd = new PortConstraint[]{PortConstraint.create((byte)1), PortConstraint.create((byte)4), PortConstraint.create((byte)2), PortConstraint.create((byte)8)};
    private static final float ae = 5.0f;
    private static final float he = 10.0f;
    private static final float ce = 15.0f;
    private static final float[] ee = new float[]{-1.6666666f, 7.5f, -1.6666666f, 0.0f, -5.0f, 0.0f, 0.0f, -7.5f, 5.0f, 0.0f, 1.6666666f, 0.0f, 1.6666666f, 7.5f};
    private static final float de = 2.5f;
    private static final float be = 5.0f;
    private static final float ge = 7.5f;
    private static final float[] fe = new float[]{0.0f, 2.5f, 5.0f, 7.5f, 7.5f, 5.0f, 2.5f, 0.0f, 7.5f, -5.0f, 5.0f, -7.5f, 0.0f, -2.5f, -5.0f, -7.5f, -7.5f, -5.0f, -2.5f, 0.0f, -7.5f, 5.0f, -5.0f, 7.5f};
    private boolean ie = true;

    public PortAssignmentMoveSelectionMode(DataMap dataMap, DataMap dataMap2) {
        this.setSpc(dataMap);
        this.setTpc(dataMap2);
    }

    public PortAssignmentMoveSelectionMode(ViewContainer viewContainer, DataMap dataMap, DataMap dataMap2) {
        super(viewContainer);
        this.setSpc(dataMap);
        this.setTpc(dataMap2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectionMovedAction(double d2, double d3, double d4, double d5) {
        super.selectionMovedAction(d2, d3, d4, d5);
        Edge edge = null;
        try {
            if (this.yd != null) {
                PortConstraint portConstraint;
                if (this.spc != null && this.isSourceBend(this.yd) && this.isPortReassignmentAllowed(this.yd.getEdge(), true) && (portConstraint = this.getPortConstraint(this.yd, true)) != null && !portConstraint.equals(this.spc.get(this.yd.getEdge()))) {
                    this.spc.set(this.yd.getEdge(), portConstraint);
                    edge = this.yd.getEdge();
                }
                if (this.tpc != null && this.isTargetBend(this.yd) && this.isPortReassignmentAllowed(this.yd.getEdge(), false) && (portConstraint = this.getPortConstraint(this.yd, false)) != null && !portConstraint.equals(this.tpc.get(this.yd.getEdge()))) {
                    this.tpc.set(this.yd.getEdge(), portConstraint);
                    edge = this.yd.getEdge();
                }
                this.yd = null;
                if (this.hintDrawable != null) {
                    this.view.removeDrawable(this.hintDrawable);
                    this.destroyDrawable(this.hintDrawable);
                    this.hintDrawable = null;
                }
            }
        }
        finally {
            this.wd = true;
        }
        if (edge != null) {
            this.portConstraintsUpdated(edge);
        }
    }

    protected void portConstraintsUpdated(Edge edge) {
    }

    protected void selectionOnMove(double d2, double d3, double d4, double d5) {
        block12: {
            Object object;
            block9: {
                boolean bl;
                block13: {
                    block11: {
                        block10: {
                            bl = NodeRealizer.z;
                            if (!this.wd) break block9;
                            this.wd = false;
                            object = this.getGraph2D();
                            NodeCursor nodeCursor = ((Graph2D)object).selectedNodes();
                            BendCursor bendCursor = ((Graph2D)object).selectedBends();
                            if (nodeCursor.ok() || !bendCursor.ok()) break block10;
                            this.yd = bendCursor.bend();
                            bendCursor.next();
                            if (!bendCursor.ok()) break block11;
                            this.yd = null;
                            if (!bl) break block11;
                        }
                        this.yd = null;
                    }
                    if (this.yd == null) break block12;
                    this.hintDrawable = this.createHintDrawable(this.yd);
                    if (this.hintDrawable == null) break block13;
                    this.view.addDrawable(this.hintDrawable);
                    if (!bl) break block12;
                }
                this.yd = null;
                if (!bl) break block12;
            }
            if (this.yd != null && (object = this.updateDrawable(this.hintDrawable, this.yd)) != this.hintDrawable) {
                if (this.hintDrawable != null) {
                    this.view.removeDrawable(this.hintDrawable);
                }
                this.hintDrawable = object;
                if (this.hintDrawable != null) {
                    this.view.addDrawable(this.hintDrawable);
                }
            }
        }
        super.selectionOnMove(d2, d3, d4, d5);
    }

    protected boolean isSourceBend(Bend bend) {
        return this.getGraph2D().getRealizer(bend.getEdge()).getBend(0) == bend;
    }

    protected boolean isTargetBend(Bend bend) {
        EdgeRealizer edgeRealizer = this.getGraph2D().getRealizer(bend.getEdge());
        return edgeRealizer.getBend(edgeRealizer.bendCount() - 1) == bend;
    }

    protected Drawable createHintDrawable(Bend bend) {
        return this.updateDrawable(null, bend);
    }

    protected void destroyDrawable(Drawable drawable) {
    }

    protected PortConstraint getPortConstraint(Bend bend, boolean bl) {
        NodeRealizer nodeRealizer = this.getGraph2D().getRealizer(bl ? bend.getEdge().source() : bend.getEdge().target());
        double d2 = Math.max(20.0, nodeRealizer.getWidth());
        double d3 = Math.max(20.0, nodeRealizer.getHeight());
        double d4 = d2 / d3;
        double d5 = YPoint.distance(nodeRealizer.getCenterX(), nodeRealizer.getCenterY(), bend.getX(), bend.getY());
        if (d5 < 20.0 || nodeRealizer.contains(bend.getX(), bend.getY())) {
            return PortConstraint.create((byte)0);
        }
        double d6 = (bend.getX() - nodeRealizer.getCenterX()) / d4;
        double d7 = bend.getY() - nodeRealizer.getCenterY();
        if (Math.abs(d6) > Math.abs(d7)) {
            if (d6 > 0.0) {
                return PortConstraint.create(bend.getX() - nodeRealizer.getCenterX() - nodeRealizer.getWidth() * 0.5 < (double)this.xd ? (byte)4 : 0);
            }
            return PortConstraint.create(nodeRealizer.getCenterX() - nodeRealizer.getWidth() * 0.5 - bend.getX() < (double)this.xd ? (byte)8 : 0);
        }
        if (d7 > 0.0) {
            return PortConstraint.create(bend.getY() - nodeRealizer.getCenterY() - nodeRealizer.getHeight() * 0.5 < (double)this.xd ? (byte)2 : 0);
        }
        return PortConstraint.create(nodeRealizer.getCenterY() - nodeRealizer.getHeight() * 0.5 - bend.getY() < (double)this.xd ? (byte)1 : 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Drawable updateDrawable(Drawable drawable, Bend bend) {
        CompositeDrawable compositeDrawable;
        int n2;
        PortConstraint[] portConstraintArray;
        boolean bl = NodeRealizer.z;
        PortConstraint[] portConstraintArray2 = null;
        PortConstraint[] portConstraintArray3 = null;
        if (this.isSourceBend(bend) && this.isPortReassignmentAllowed(bend.getEdge(), true)) {
            portConstraintArray2 = this.getValidPortConstraints(bend.getEdge(), true);
            portConstraintArray = this.getPortConstraint(bend, true);
            if (portConstraintArray != null && !portConstraintArray.isAtAnySide()) {
                boolean bl2;
                block26: {
                    boolean bl3 = false;
                    for (int i2 = 0; i2 < portConstraintArray2.length; ++i2) {
                        bl2 = portConstraintArray2[i2].equals(portConstraintArray);
                        if (!bl) {
                            if (!bl2) continue;
                            bl3 = true;
                            if (!bl) break;
                            if (!bl) continue;
                        }
                        break block26;
                    }
                    bl2 = bl3;
                }
                if (!bl2) {
                    portConstraintArray3 = new PortConstraint[]{portConstraintArray};
                    portConstraintArray2 = null;
                } else {
                    portConstraintArray2 = new PortConstraint[]{portConstraintArray};
                }
            }
        }
        portConstraintArray = null;
        PortConstraint[] portConstraintArray4 = null;
        if (this.isTargetBend(bend) && this.isPortReassignmentAllowed(bend.getEdge(), false)) {
            portConstraintArray = this.getValidPortConstraints(bend.getEdge(), false);
            PortConstraint portConstraint = this.getPortConstraint(bend, false);
            if (portConstraint != null && !portConstraint.isAtAnySide()) {
                boolean bl4;
                block27: {
                    boolean bl5 = false;
                    for (int i3 = 0; i3 < portConstraintArray.length; ++i3) {
                        bl4 = portConstraintArray[i3].equals(portConstraint);
                        if (!bl) {
                            if (!bl4) continue;
                            bl5 = true;
                            if (!bl) break;
                            if (!bl) continue;
                        }
                        break block27;
                    }
                    bl4 = bl5;
                }
                if (!bl4) {
                    portConstraintArray4 = new PortConstraint[]{portConstraint};
                    portConstraintArray = null;
                } else {
                    portConstraintArray = new PortConstraint[]{portConstraint};
                }
            }
        }
        if (portConstraintArray2 == null && portConstraintArray == null && portConstraintArray4 == null && portConstraintArray3 == null) return null;
        CompositeDrawable compositeDrawable2 = new CompositeDrawable();
        Edge edge = bend.getEdge();
        Node node = edge.source();
        if (portConstraintArray2 != null) {
            for (n2 = 0; n2 < portConstraintArray2.length; ++n2) {
                compositeDrawable2.addDrawable(this.createPortConstraintDrawable(portConstraintArray2[n2], node, edge, true, true));
                if (!bl) {
                    if (!bl) continue;
                }
                break;
            }
        } else if (portConstraintArray3 != null) {
            for (n2 = 0; n2 < portConstraintArray3.length; ++n2) {
                compositeDrawable2.addDrawable(this.createPortConstraintDrawable((PortConstraint)portConstraintArray3[n2], node, edge, true, false));
                if (!bl) {
                    if (!bl) continue;
                }
                break;
            }
        } else {
            node = edge.target();
        }
        if (portConstraintArray != null) {
            for (n2 = 0; n2 < portConstraintArray.length; ++n2) {
                compositeDrawable2.addDrawable(this.createPortConstraintDrawable(portConstraintArray[n2], node, edge, false, true));
                if (!bl) {
                    if (!bl) continue;
                }
                break;
            }
        } else if (portConstraintArray4 != null) {
            for (n2 = 0; n2 < portConstraintArray4.length; ++n2) {
                compositeDrawable = compositeDrawable2;
                if (bl) return compositeDrawable;
                compositeDrawable.addDrawable(this.createPortConstraintDrawable((PortConstraint)portConstraintArray4[n2], node, edge, false, false));
                if (!bl) continue;
            }
        }
        compositeDrawable = compositeDrawable2;
        return compositeDrawable;
    }

    protected PortConstraint[] getValidPortConstraints(Edge edge, boolean bl) {
        return zd;
    }

    protected Drawable createPortConstraintDrawable(PortConstraint portConstraint, Node node, Edge edge, boolean bl, boolean bl2) {
        GeneralPath generalPath;
        block8: {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            boolean bl3;
            block11: {
                float f8;
                NodeRealizer nodeRealizer;
                block16: {
                    block15: {
                        block14: {
                            block9: {
                                block13: {
                                    block12: {
                                        block10: {
                                            bl3 = NodeRealizer.z;
                                            if (portConstraint == null || portConstraint.isAtAnySide()) {
                                                return null;
                                            }
                                            nodeRealizer = this.getGraph2D().getRealizer(node);
                                            generalPath = new GeneralPath(0, 14);
                                            f7 = (float)nodeRealizer.getCenterX();
                                            f6 = (float)nodeRealizer.getCenterY();
                                            f8 = 12.5f;
                                            if (!bl && this.ie) break block9;
                                            if (!portConstraint.isAtNorth()) break block10;
                                            f5 = 1.0f;
                                            f4 = 0.0f;
                                            f3 = 0.0f;
                                            f2 = 1.0f;
                                            f6 -= (float)nodeRealizer.getHeight() * 0.5f + f8;
                                            if (!bl3) break block11;
                                        }
                                        if (!portConstraint.isAtEast()) break block12;
                                        f5 = 0.0f;
                                        f4 = 1.0f;
                                        f3 = -1.0f;
                                        f2 = 0.0f;
                                        f7 += (float)nodeRealizer.getWidth() * 0.5f + f8;
                                        if (!bl3) break block11;
                                    }
                                    if (!portConstraint.isAtSouth()) break block13;
                                    f5 = -1.0f;
                                    f4 = 0.0f;
                                    f3 = 0.0f;
                                    f2 = -1.0f;
                                    f6 += (float)nodeRealizer.getHeight() * 0.5f + f8;
                                    if (!bl3) break block11;
                                }
                                f5 = 0.0f;
                                f4 = -1.0f;
                                f3 = 1.0f;
                                f2 = 0.0f;
                                f7 -= (float)nodeRealizer.getWidth() * 0.5f + f8;
                                if (!bl3) break block11;
                            }
                            if (!portConstraint.isAtSouth()) break block14;
                            f5 = 1.0f;
                            f4 = 0.0f;
                            f3 = 0.0f;
                            f2 = 1.0f;
                            f6 += (float)nodeRealizer.getHeight() * 0.5f + f8;
                            if (!bl3) break block11;
                        }
                        if (!portConstraint.isAtWest()) break block15;
                        f5 = 0.0f;
                        f4 = 1.0f;
                        f3 = -1.0f;
                        f2 = 0.0f;
                        f7 -= (float)nodeRealizer.getWidth() * 0.5f + f8;
                        if (!bl3) break block11;
                    }
                    if (!portConstraint.isAtNorth()) break block16;
                    f5 = -1.0f;
                    f4 = 0.0f;
                    f3 = 0.0f;
                    f2 = -1.0f;
                    f6 -= (float)nodeRealizer.getHeight() * 0.5f + f8;
                    if (!bl3) break block11;
                }
                f5 = 0.0f;
                f4 = -1.0f;
                f3 = 1.0f;
                f2 = 0.0f;
                f7 += (float)nodeRealizer.getWidth() * 0.5f + f8;
            }
            float[] fArray = bl2 ? ee : fe;
            generalPath.moveTo(f7 + fArray[0] * f5 + fArray[1] * f3, f6 + fArray[0] * f4 + fArray[1] * f2);
            for (int i2 = 2; i2 < fArray.length; i2 += 2) {
                generalPath.lineTo(f7 + fArray[i2] * f5 + fArray[i2 + 1] * f3, f6 + fArray[i2] * f4 + fArray[i2 + 1] * f2);
                if (!bl3) {
                    if (!bl3) continue;
                }
                break block8;
            }
            generalPath.closePath();
        }
        if (bl2) {
            return new ShapeDrawable(generalPath, Color.green, Color.black);
        }
        CompositeDrawable compositeDrawable = new CompositeDrawable();
        compositeDrawable.addDrawable(this.createPortConstraintDrawable(portConstraint, node, edge, bl, true));
        compositeDrawable.addDrawable(new ShapeDrawable(generalPath, Color.red, Color.black));
        return compositeDrawable;
    }

    protected boolean isPortReassignmentAllowed(Edge edge, boolean bl) {
        return bl ? this.spc != null : this.tpc != null;
    }

    public DataMap getSpc() {
        return this.spc;
    }

    public void setSpc(DataMap dataMap) {
        this.spc = dataMap;
    }

    public DataMap getTpc() {
        return this.tpc;
    }

    public void setTpc(DataMap dataMap) {
        this.tpc = dataMap;
    }

    public float getMaxDistance() {
        return this.xd;
    }

    public void setMaxDistance(float f2) {
        this.xd = f2;
    }

    public boolean isDirectedArrows() {
        return this.ie;
    }

    public void setDirectedArrows(boolean bl) {
        this.ie = bl;
    }
}

