/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Node;
import y.base.YCursor;
import y.geom.YRectangle;
import y.view.AbstractSelectionBoxMode;
import y.view.Bend;
import y.view.BendCursor;
import y.view.EdgeLabel;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.NodeLabel;
import y.view.NodePort;
import y.view.NodeRealizer;
import y.view.Selections;
import y.view.ViewContainer;
import y.view.YLabel;
import y.view.hierarchy.HierarchyManager;

public class SelectionBoxMode
extends AbstractSelectionBoxMode {
    public static final int TYPE_NODE = 1;
    public static final int TYPE_EDGE = 2;
    public static final int TYPE_BEND = 8;
    public static final int TYPE_NODE_LABEL = 16;
    public static final int TYPE_EDGE_LABEL = 32;
    public static final int TYPE_NODE_PORT = 64;
    private static final int sm = 9;
    private static final int rm = 48;
    private boolean tm;
    private boolean qm;

    public SelectionBoxMode(ViewContainer viewContainer) {
        super(viewContainer);
    }

    public SelectionBoxMode() {
    }

    public boolean isExtendedTypeSelectionEnabled() {
        return this.tm;
    }

    public void setExtendedTypeSelectionEnabled(boolean bl) {
        this.tm = bl;
    }

    public boolean isMixedSelectionEnabled() {
        return this.qm;
    }

    public void setMixedSelectionEnabled(boolean bl) {
        this.qm = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectionBoxAction(Rectangle rectangle, boolean bl) {
        Graph2D graph2D = this.getGraph2D();
        graph2D.firePreEvent();
        try {
            this.b(graph2D, rectangle, bl);
        }
        finally {
            graph2D.firePostEvent();
        }
        graph2D.updateViews();
    }

    private void b(Graph2D graph2D, Rectangle rectangle, boolean bl) {
        block3: {
            block5: {
                boolean bl2;
                block4: {
                    block2: {
                        bl2 = NodeRealizer.z;
                        if (!this.isExtendedTypeSelectionEnabled()) break block2;
                        this.selectTypes(graph2D, this.adjustTypes(this.getSelectedTypes(graph2D)), rectangle, bl);
                        if (!bl2) break block3;
                    }
                    if (bl) break block4;
                    this.unselectAll(graph2D);
                    this.c(rectangle);
                    if (!bl2) break block3;
                }
                if (!graph2D.selectedEdges().ok()) break block5;
                this.b(rectangle);
                if (!bl2) break block3;
            }
            this.c(rectangle);
        }
    }

    void c(Rectangle2D rectangle2D) {
        Object object;
        boolean bl = NodeRealizer.z;
        Graph2D graph2D = this.getGraph2D();
        YCursor yCursor = graph2D.nodes();
        while (yCursor.ok()) {
            object = yCursor.node();
            if (this.belongsToSelection((Node)object, rectangle2D)) {
                this.setSelected(graph2D, (Node)object, true);
            }
            yCursor.next();
            if (!bl) continue;
        }
        yCursor = graph2D.bends();
        while (yCursor.ok()) {
            object = yCursor.bend();
            if (this.belongsToSelection((Bend)object, rectangle2D)) {
                this.setSelected(graph2D, (Bend)object, true);
            }
            yCursor.next();
            if (!bl) continue;
        }
    }

    void b(Rectangle2D rectangle2D) {
        boolean bl = NodeRealizer.z;
        Graph2D graph2D = this.getGraph2D();
        EdgeCursor edgeCursor = graph2D.edges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (this.belongsToSelection(edge, rectangle2D)) {
                this.setSelected(graph2D, edge, true);
            }
            edgeCursor.next();
            if (!bl) continue;
        }
    }

    protected boolean belongsToSelection(Node node, Rectangle2D rectangle2D) {
        Graph2D graph2D = this.getGraph2D();
        NodeRealizer nodeRealizer = this.getGraph2D().getRealizer(node);
        HierarchyManager hierarchyManager = HierarchyManager.getInstance(graph2D);
        if (hierarchyManager != null && hierarchyManager.isGroupNode(node)) {
            return rectangle2D.contains(nodeRealizer.getX(), nodeRealizer.getY(), nodeRealizer.getWidth(), nodeRealizer.getHeight());
        }
        return nodeRealizer.isInBox(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected boolean belongsToSelection(Edge edge, Rectangle2D rectangle2D) {
        EdgeRealizer edgeRealizer = this.getGraph2D().getRealizer(edge);
        return edgeRealizer.pathIntersects(rectangle2D, false);
    }

    protected boolean belongsToSelection(Bend bend, Rectangle2D rectangle2D) {
        return bend.isInBox(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    protected boolean belongsToSelection(YLabel yLabel, Rectangle2D rectangle2D) {
        return this.b(yLabel.getBox(), rectangle2D);
    }

    protected boolean belongsToSelection(NodePort nodePort, Rectangle2D rectangle2D) {
        return this.b(nodePort.getBounds(), rectangle2D);
    }

    private boolean b(YRectangle yRectangle, Rectangle2D rectangle2D) {
        double d2 = yRectangle.getX() + yRectangle.getWidth() * 0.5;
        double d3 = yRectangle.getY() + yRectangle.getHeight() * 0.5;
        return rectangle2D.getX() <= d2 && d2 <= rectangle2D.getX() + rectangle2D.getWidth() && rectangle2D.getY() <= d3 && d3 <= rectangle2D.getY() + rectangle2D.getHeight();
    }

    protected int adjustTypes(int n2) {
        int n3;
        block13: {
            block14: {
                boolean bl;
                block12: {
                    block9: {
                        int n4;
                        block11: {
                            block10: {
                                bl = NodeRealizer.z;
                                if (!this.isMixedSelectionEnabled()) break block9;
                                n4 = n2;
                                if (n4 != 0) break block10;
                                n4 = 9;
                                if (!bl) break block11;
                            }
                            if ((n4 & 9) == n4) {
                                n4 = 9;
                            }
                        }
                        return n4;
                    }
                    n3 = n2;
                    if (n3 == 0) {
                        n3 = 9;
                    }
                    if ((n3 & 2) != 2) break block12;
                    n3 = 2;
                    if (!bl) break block13;
                }
                if ((n3 & 9) == 0) break block14;
                n3 = 9;
                if (!bl) break block13;
            }
            n3 = SelectionBoxMode.b(n3);
        }
        if ((n3 & 0x30) != 0) {
            n3 = 48;
        }
        return n3;
    }

    private static int b(int n2) {
        return n2 & -n2;
    }

    protected int getSelectedTypes(Graph2D graph2D) {
        int n2;
        block3: {
            boolean bl = NodeRealizer.z;
            int n3 = 0;
            YCursor yCursor = graph2D.nodes();
            while (yCursor.ok()) {
                n3 |= this.getSelectedNodeTypes(graph2D, yCursor.node());
                yCursor.next();
                if (!bl) continue;
            }
            yCursor = graph2D.edges();
            while (yCursor.ok()) {
                n2 = n3 | this.getSelectedEdgeTypes(graph2D, yCursor.edge());
                if (!bl) {
                    n3 = n2;
                    yCursor.next();
                    if (!bl) continue;
                }
                break block3;
            }
            n2 = n3;
        }
        return n2;
    }

    protected int getSelectedEdgeTypes(Graph2D graph2D, Edge edge) {
        int n2;
        int n3;
        boolean bl = NodeRealizer.z;
        int n4 = 0;
        if (this.isSelected(graph2D, edge)) {
            n4 |= 2;
        }
        EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
        if ((n4 & 0x20) != 32 && edgeRealizer.labelCount() > 0) {
            int n5 = edgeRealizer.labelCount();
            for (int i2 = 0; i2 < n5; ++i2) {
                n3 = this.isSelected(graph2D, edgeRealizer.getLabel(i2)) ? 1 : 0;
                if (!bl) {
                    if (n3 == 0) continue;
                    n4 |= 0x20;
                    if (!bl) break;
                    if (!bl) continue;
                }
                break;
            }
        } else {
            n3 = n4 & 8;
        }
        if (n3 != 8 && edgeRealizer.bendCount() > 0) {
            BendCursor bendCursor = edgeRealizer.bends();
            while (bendCursor.ok()) {
                n2 = this.isSelected(graph2D, bendCursor.bend()) ? 1 : 0;
                if (!bl) {
                    if (n2 != 0) {
                        n4 |= 8;
                        if (!bl) break;
                    }
                    bendCursor.next();
                    if (!bl) continue;
                }
                break;
            }
        } else {
            n2 = n4;
        }
        return n2;
    }

    protected int getSelectedNodeTypes(Graph2D graph2D, Node node) {
        int n2;
        int n3;
        boolean bl = NodeRealizer.z;
        int n4 = 0;
        if (this.isSelected(graph2D, node)) {
            n4 |= 1;
        }
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        if ((n4 & 0x10) != 16 && nodeRealizer.labelCount() > 0) {
            int n5 = nodeRealizer.labelCount();
            for (int i2 = 0; i2 < n5; ++i2) {
                n3 = this.isSelected(graph2D, nodeRealizer.getLabel(i2)) ? 1 : 0;
                if (!bl) {
                    if (n3 == 0) continue;
                    n4 |= 0x10;
                    if (!bl) break;
                    if (!bl) continue;
                }
                break;
            }
        } else {
            n3 = n4 & 0x40;
        }
        if (n3 != 64 && nodeRealizer.portCount() > 0) {
            Iterator iterator2 = nodeRealizer.ports();
            while (iterator2.hasNext()) {
                if (!this.isSelected(graph2D, (NodePort)iterator2.next())) continue;
                n2 = n4 | 0x40;
                if (!bl) {
                    n4 = n2;
                }
                break;
            }
        } else {
            n2 = n4;
        }
        return n2;
    }

    protected void selectTypes(Graph2D graph2D, int n2, Rectangle rectangle, boolean bl) {
        boolean bl2 = NodeRealizer.z;
        YCursor yCursor = graph2D.nodes();
        while (yCursor.ok()) {
            this.selectNodeTypes(graph2D, yCursor.node(), n2, rectangle, bl);
            yCursor.next();
            if (!bl2) continue;
        }
        yCursor = graph2D.edges();
        while (yCursor.ok()) {
            this.selectEdgeTypes(graph2D, yCursor.edge(), n2, rectangle, bl);
            yCursor.next();
            if (!bl2) continue;
        }
    }

    protected void selectEdgeTypes(Graph2D graph2D, Edge edge, int n2, Rectangle rectangle, boolean bl) {
        block18: {
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            block16: {
                block17: {
                    bl6 = NodeRealizer.z;
                    bl5 = !bl;
                    boolean bl7 = (n2 & 2) == 2;
                    bl4 = (n2 & 0x20) == 32;
                    boolean bl8 = bl3 = (n2 & 8) == 8;
                    if (!bl7) break block16;
                    if (!this.belongsToSelection(edge, (Rectangle2D)rectangle)) break block17;
                    this.setSelected(graph2D, edge, true);
                    if (!bl6) break block16;
                }
                if (bl5) {
                    this.setSelected(graph2D, edge, false);
                }
            }
            EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
            if (bl4 && edgeRealizer.labelCount() > 0) {
                int n3 = edgeRealizer.labelCount();
                for (int i2 = 0; i2 < n3; ++i2) {
                    EdgeLabel edgeLabel = edgeRealizer.getLabel(i2);
                    bl2 = this.belongsToSelection(edgeLabel, (Rectangle2D)rectangle);
                    if (!bl6) {
                        if (bl2) {
                            this.setSelected(graph2D, edgeLabel, true);
                            if (!bl6) continue;
                        }
                        if (!bl5) continue;
                        this.setSelected(graph2D, edgeLabel, false);
                        if (!bl6) continue;
                    }
                    break;
                }
            } else {
                bl2 = bl3;
            }
            if (!bl2 || edgeRealizer.bendCount() <= 0) break block18;
            BendCursor bendCursor = edgeRealizer.bends();
            while (bendCursor.ok()) {
                block20: {
                    Bend bend;
                    block19: {
                        bend = bendCursor.bend();
                        if (!this.belongsToSelection(bend, (Rectangle2D)rectangle)) break block19;
                        this.setSelected(graph2D, bend, true);
                        if (!bl6) break block20;
                    }
                    if (bl5) {
                        this.setSelected(graph2D, bend, false);
                    }
                }
                bendCursor.next();
                if (!bl6) continue;
            }
        }
    }

    protected void selectNodeTypes(Graph2D graph2D, Node node, int n2, Rectangle rectangle, boolean bl) {
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        block13: {
            block14: {
                bl6 = NodeRealizer.z;
                bl5 = !bl;
                boolean bl7 = (n2 & 1) == 1;
                bl4 = (n2 & 0x10) == 16;
                boolean bl8 = bl3 = (n2 & 0x40) == 64;
                if (!bl7) break block13;
                if (!this.belongsToSelection(node, (Rectangle2D)rectangle)) break block14;
                this.setSelected(graph2D, node, true);
                if (!bl6) break block13;
            }
            if (bl5) {
                this.setSelected(graph2D, node, false);
            }
        }
        NodeRealizer nodeRealizer = graph2D.getRealizer(node);
        if (bl4 && nodeRealizer.labelCount() > 0) {
            int n3 = nodeRealizer.labelCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                NodeLabel nodeLabel = nodeRealizer.getLabel(i2);
                bl2 = this.belongsToSelection(nodeLabel, (Rectangle2D)rectangle);
                if (!bl6) {
                    if (bl2) {
                        this.setSelected(graph2D, nodeLabel, true);
                        if (!bl6) continue;
                    }
                    if (!bl5) continue;
                    this.setSelected(graph2D, nodeLabel, false);
                    if (!bl6) continue;
                }
                break;
            }
        } else {
            bl2 = bl3;
        }
        if (bl2 && nodeRealizer.portCount() > 0) {
            Iterator iterator2 = nodeRealizer.ports();
            while (iterator2.hasNext()) {
                NodePort nodePort = (NodePort)iterator2.next();
                if (this.belongsToSelection(nodePort, (Rectangle2D)rectangle)) {
                    this.setSelected(graph2D, nodePort, true);
                    if (!bl6) continue;
                }
                if (!bl5) continue;
                this.setSelected(graph2D, nodePort, false);
                if (!bl6) continue;
            }
        }
    }

    protected void unselectAll(Graph2D graph2D) {
        graph2D.unselectAll();
    }

    protected void setSelected(Graph2D graph2D, Node node, boolean bl) {
        block3: {
            block2: {
                if (!bl) break block2;
                Selections.selectNodeAndSelfLoopBends(graph2D, node);
                if (!NodeRealizer.z) break block3;
            }
            Selections.deselectNodeAndSelfLoopBends(graph2D, node);
        }
    }

    protected void setSelected(Graph2D graph2D, Bend bend, boolean bl) {
        graph2D.setSelected(bend, bl);
    }

    protected void setSelected(Graph2D graph2D, Edge edge, boolean bl) {
        graph2D.setSelected(edge, bl);
    }

    protected void setSelected(Graph2D graph2D, YLabel yLabel, boolean bl) {
        graph2D.setSelected(yLabel, bl);
    }

    protected void setSelected(Graph2D graph2D, NodePort nodePort, boolean bl) {
        graph2D.setSelected(nodePort, bl);
    }

    protected boolean isSelected(Graph2D graph2D, Bend bend) {
        return graph2D.isSelected(bend);
    }

    protected boolean isSelected(Graph2D graph2D, YLabel yLabel) {
        return graph2D.isSelected(yLabel);
    }

    protected boolean isSelected(Graph2D graph2D, Edge edge) {
        return graph2D.isSelected(edge);
    }

    protected boolean isSelected(Graph2D graph2D, Node node) {
        return graph2D.isSelected(node);
    }

    protected boolean isSelected(Graph2D graph2D, NodePort nodePort) {
        return graph2D.isSelected(nodePort);
    }
}

