/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import y.base.DataProvider;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.EdgeMap;
import y.base.GraphEvent;
import y.base.GraphListener;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.base.NodeMap;
import y.util.EdgeMapAdapter;
import y.util.Filter;
import y.util.NodeMapAdapter;
import y.view.Bend;
import y.view.BendCursor;
import y.view.BendList;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.Graph2DSelectionEvent;
import y.view.Graph2DSelectionListener;
import y.view.NodePort;
import y.view.NodeRealizer;
import y.view.YLabel;
import y.view.hierarchy.HierarchyManager;

public abstract class Selections {
    private Selections() {
    }

    public static boolean isSelected(Graph2D graph2D, Object object) {
        return object instanceof Node && graph2D.isSelected((Node)object) || object instanceof Edge && graph2D.isSelected((Edge)object) || object instanceof Bend && graph2D.isSelected((Bend)object) || object instanceof YLabel && graph2D.isSelected((YLabel)object) || object instanceof NodePort && graph2D.isSelected((NodePort)object);
    }

    public static void setSelected(Graph2D graph2D, Object object, boolean bl) {
        block5: {
            block8: {
                boolean bl2;
                block7: {
                    block6: {
                        block4: {
                            bl2 = NodeRealizer.z;
                            if (!(object instanceof Node)) break block4;
                            graph2D.setSelected((Node)object, bl);
                            if (!bl2) break block5;
                        }
                        if (!(object instanceof Edge)) break block6;
                        graph2D.setSelected((Edge)object, bl);
                        if (!bl2) break block5;
                    }
                    if (!(object instanceof Bend)) break block7;
                    graph2D.setSelected((Bend)object, bl);
                    if (!bl2) break block5;
                }
                if (!(object instanceof YLabel)) break block8;
                graph2D.setSelected((YLabel)object, bl);
                if (!bl2) break block5;
            }
            if (object instanceof NodePort) {
                graph2D.setSelected((NodePort)object, bl);
            }
        }
    }

    public static void selectNodesAndSelfLoopBends(Graph2D graph2D) {
        boolean bl = NodeRealizer.z;
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            Selections.selectNodeAndSelfLoopBends(graph2D, nodeCursor.node());
            nodeCursor.next();
            if (!bl) continue;
        }
    }

    public static void selectNodeAndSelfLoopBends(Graph2D graph2D, Node node) {
        boolean bl = NodeRealizer.z;
        graph2D.setSelected(node, true);
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edge.isSelfLoop()) {
                BendCursor bendCursor = graph2D.getRealizer(edge).bends();
                while (bendCursor.ok()) {
                    graph2D.setSelected(bendCursor.bend(), true);
                    bendCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break;
                }
            } else {
                edgeCursor.next();
            }
            if (!bl) continue;
        }
    }

    public static void deselectNodeAndSelfLoopBends(Graph2D graph2D, Node node) {
        boolean bl = NodeRealizer.z;
        graph2D.setSelected(node, false);
        EdgeCursor edgeCursor = node.outEdges();
        while (edgeCursor.ok()) {
            Edge edge = edgeCursor.edge();
            if (edge.isSelfLoop()) {
                BendCursor bendCursor = graph2D.getRealizer(edge).bends();
                while (bendCursor.ok()) {
                    graph2D.setSelected(bendCursor.bend(), false);
                    bendCursor.next();
                    if (!bl) {
                        if (!bl) continue;
                    }
                    break;
                }
            } else {
                edgeCursor.next();
            }
            if (!bl) continue;
        }
    }

    public static DataProvider createSelectionDataProvider(Graph2D graph2D) {
        return new _c(Selections.createSelectionNodeMap(graph2D), Selections.createSelectionEdgeMap(graph2D));
    }

    public static NodeMap createSelectionNodeMap(Graph2D graph2D) {
        return new _d(graph2D);
    }

    public static EdgeMap createSelectionEdgeMap(Graph2D graph2D) {
        return new _b(graph2D);
    }

    public static void findExtendedGroupingSelection(final Graph2D graph2D, NodeList nodeList, NodeList nodeList2, BendList bendList) {
        Selections.b(graph2D, new Filter(){

            public boolean accept(Object object) {
                return graph2D.isSelected((Node)object);
            }
        }, new Filter(){

            public boolean accept(Object object) {
                return graph2D.isSelected((Bend)object);
            }
        }, nodeList, nodeList2, bendList);
    }

    static void b(Graph2D graph2D, Filter filter2, Filter filter3, NodeList nodeList, NodeList nodeList2, BendList bendList) {
        boolean bl = NodeRealizer.z;
        HierarchyManager hierarchyManager = HierarchyManager.getInstance(graph2D);
        if (hierarchyManager == null) {
            return;
        }
        boolean[] blArray = new boolean[graph2D.N()];
        NodeCursor nodeCursor = graph2D.nodes();
        while (nodeCursor.ok()) {
            Node node;
            Node node2 = nodeCursor.node();
            block1: while (filter2.accept(node = node2)) {
                if (hierarchyManager.isGroupNode(node) && !blArray[node.index()]) {
                    Selections.b(hierarchyManager, graph2D, filter2, filter3, node, node, nodeList, bendList, blArray);
                }
                Node node3 = hierarchyManager.getParentNode(node);
                while (hierarchyManager.isGroupNode(node3)) {
                    block9: {
                        block8: {
                            node2 = node3;
                            if (bl) continue block1;
                            if (node2.getGraph() != graph2D || blArray[node3.index()]) break block1;
                            if (!filter2.accept(node3)) break block8;
                            Selections.b(hierarchyManager, graph2D, filter2, filter3, node3, node3, nodeList, bendList, blArray);
                            if (!bl) break block9;
                        }
                        nodeList2.add(node3);
                    }
                    blArray[node3.index()] = true;
                    node3 = hierarchyManager.getParentNode(node3);
                    if (!bl) continue;
                }
                break block1;
            }
            nodeCursor.next();
            if (!bl) continue;
        }
    }

    private static void b(HierarchyManager hierarchyManager, Graph2D graph2D, Filter filter2, Filter filter3, Node node, Node node2, NodeList nodeList, BendList bendList, boolean[] blArray) {
        boolean bl = NodeRealizer.z;
        NodeCursor nodeCursor = hierarchyManager.getChildren(node2);
        block0: while (true) {
            int n2 = nodeCursor.ok();
            block1: while (n2 != 0) {
                Node node3 = nodeCursor.node();
                if (nodeList != null && !blArray[node3.index()] && !filter2.accept(node3)) {
                    nodeList.add(node3);
                    blArray[node3.index()] = true;
                }
                if (hierarchyManager.isGroupNode(node3)) {
                    Selections.b(hierarchyManager, graph2D, filter2, filter3, node, node3, nodeList, bendList, blArray);
                }
                if (bendList != null) {
                    for (Edge edge = node3.firstOutEdge(); edge != null; edge = edge.nextOutEdge()) {
                        EdgeRealizer edgeRealizer = graph2D.getRealizer(edge);
                        n2 = edgeRealizer.bendCount();
                        if (bl) continue block1;
                        if (n2 <= 0 || !hierarchyManager.isAncestor(node, edge.target())) continue;
                        BendCursor bendCursor = edgeRealizer.bends();
                        while (bendCursor.ok()) {
                            n2 = filter3.accept(bendCursor.bend()) ? 1 : 0;
                            if (bl) continue block1;
                            if (n2 == 0) {
                                bendList.add(bendCursor.bend());
                            }
                            bendCursor.next();
                            if (!bl) continue;
                        }
                        if (!bl) continue;
                    }
                }
                nodeCursor.next();
                if (!bl) continue block0;
            }
            break;
        }
    }

    public static boolean isNodeSelectionEmpty(Graph2D graph2D) {
        boolean bl;
        block3: {
            boolean bl2 = NodeRealizer.z;
            NodeCursor nodeCursor = graph2D.nodes();
            while (nodeCursor.ok()) {
                bl = graph2D.isSelected(nodeCursor.node());
                if (!bl2) {
                    if (bl) {
                        return false;
                    }
                    nodeCursor.next();
                    if (!bl2) continue;
                }
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    public static boolean isEdgeSelectionEmpty(Graph2D graph2D) {
        boolean bl;
        block3: {
            boolean bl2 = NodeRealizer.z;
            EdgeCursor edgeCursor = graph2D.edges();
            while (edgeCursor.ok()) {
                bl = graph2D.isSelected(edgeCursor.edge());
                if (!bl2) {
                    if (bl) {
                        return false;
                    }
                    edgeCursor.next();
                    if (!bl2) continue;
                }
                break block3;
            }
            bl = true;
        }
        return bl;
    }

    public static class SelectionStateObserver
    implements Graph2DSelectionListener,
    GraphListener {
        int xe = 0;
        boolean we = false;

        public void onGraph2DSelectionEvent(Graph2DSelectionEvent graph2DSelectionEvent) {
            this.we = true;
            if (this.xe == 0) {
                this.updateSelectionState(graph2DSelectionEvent.getGraph2D());
                this.we = false;
            }
        }

        public void onGraphEvent(GraphEvent graphEvent) {
            boolean bl = NodeRealizer.z;
            switch (graphEvent.getType()) {
                case 12: {
                    ++this.xe;
                    if (!bl) break;
                }
                case 13: {
                    --this.xe;
                    if (!this.we || this.xe != 0) break;
                    this.updateSelectionState((Graph2D)graphEvent.getGraph());
                    this.we = false;
                    if (!bl) break;
                }
                case 0: 
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 11: {
                    this.we = true;
                    if (this.xe != 0) break;
                    this.updateSelectionState((Graph2D)graphEvent.getGraph());
                    this.we = false;
                }
            }
        }

        protected void updateSelectionState(Graph2D graph2D) {
        }
    }

    private static final class _c
    implements DataProvider {
        private NodeMap ke;
        private EdgeMap je;

        _c(NodeMap nodeMap, EdgeMap edgeMap) {
            this.ke = nodeMap;
            this.je = edgeMap;
        }

        public Object get(Object object) {
            if (object instanceof Node) {
                return this.ke.get(object);
            }
            if (object instanceof Edge) {
                return this.je.get(object);
            }
            return null;
        }

        public boolean getBool(Object object) {
            if (object instanceof Node) {
                return this.ke.getBool(object);
            }
            if (object instanceof Edge) {
                return this.je.getBool(object);
            }
            return false;
        }

        public double getDouble(Object object) {
            if (object instanceof Node) {
                return this.ke.getDouble(object);
            }
            if (object instanceof Edge) {
                return this.je.getDouble(object);
            }
            return 0.0;
        }

        public int getInt(Object object) {
            if (object instanceof Node) {
                return this.ke.getInt(object);
            }
            if (object instanceof Edge) {
                return this.je.getInt(object);
            }
            return 0;
        }
    }

    private static final class _b
    extends EdgeMapAdapter {
        private Graph2D sb;

        _b(Graph2D graph2D) {
            this.sb = graph2D;
        }

        public void setBool(Object object, boolean bl) {
            this.sb.setSelected((Edge)object, bl);
        }

        public boolean getBool(Object object) {
            return this.sb.isSelected((Edge)object);
        }
    }

    private static final class _d
    extends NodeMapAdapter {
        private Graph2D h;

        _d(Graph2D graph2D) {
            this.h = graph2D;
        }

        public void setBool(Object object, boolean bl) {
            this.h.setSelected((Node)object, bl);
        }

        public boolean getBool(Object object) {
            return this.h.isSelected((Node)object);
        }
    }
}

