/*
 * Decompiled with CFR 0.152.
 */
package y.view;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import y.geom.YDimension;
import y.geom.YPoint;
import y.geom.YRectangle;
import y.view.LineType;
import y.view.NodePort;
import y.view.NodeRealizer;
import y.view.c;

public class ShapePortConfiguration
implements NodePort.Painter,
NodePort.IntersectionTest,
NodePort.ContainsTest,
NodePort.BoundsProvider,
NodePort.UnionRectCalculator {
    private static final double k = 10.0;
    private static final double j = 0.5;
    private YDimension l = new YDimension(10.0, 10.0);
    private YPoint m = new YPoint(0.5, 0.5);

    public YDimension getSize() {
        return this.l;
    }

    private static boolean b(YDimension yDimension) {
        if (yDimension == null) {
            return false;
        }
        double d2 = yDimension.getWidth();
        if (d2 < 0.0 || Double.isNaN(d2) || Double.isInfinite(d2)) {
            return false;
        }
        double d3 = yDimension.getHeight();
        return !(d3 < 0.0) && !Double.isNaN(d3) && !Double.isInfinite(d3);
    }

    public void setSize(YDimension yDimension) {
        block3: {
            block2: {
                if (!ShapePortConfiguration.b(yDimension)) break block2;
                this.l = yDimension;
                if (!NodeRealizer.z) break block3;
            }
            throw new IllegalArgumentException();
        }
    }

    public void setSize(double d2, double d3) {
        this.setSize(new YDimension(d2, d3));
    }

    public YPoint getRatio() {
        return this.m;
    }

    private static boolean b(YPoint yPoint) {
        if (yPoint == null) {
            return false;
        }
        double d2 = yPoint.getX();
        if (d2 < 0.0 || 1.0 < d2 || Double.isNaN(d2)) {
            return false;
        }
        double d3 = yPoint.getY();
        return !(d3 < 0.0) && !(1.0 < d3) && !Double.isNaN(d3);
    }

    public void setRatio(YPoint yPoint) {
        block3: {
            block2: {
                if (!ShapePortConfiguration.b(yPoint)) break block2;
                this.m = yPoint;
                if (!NodeRealizer.z) break block3;
            }
            throw new IllegalArgumentException();
        }
    }

    public void setRatio(double d2, double d3) {
        this.setRatio(new YPoint(d2, d3));
    }

    public boolean contains(NodePort nodePort, double d2, double d3) {
        return nodePort.getBounds().contains(d2, d3);
    }

    public boolean findIntersection(NodePort nodePort, double d2, double d3, double d4, double d5, Point2D point2D) {
        boolean bl;
        block8: {
            double d6;
            boolean bl2 = NodeRealizer.z;
            if (nodePort.contains(d2, d3)) {
                if (nodePort.contains(d4, d5)) {
                    point2D.setLocation(d4, d5);
                    return false;
                }
            } else if (!nodePort.contains(d4, d5)) {
                point2D.setLocation(d2, d3);
                return false;
            }
            if (Double.isNaN(d6 = Math.sqrt((d4 - d2) * (d4 - d2) + (d5 - d3) * (d5 - d3))) || Double.isInfinite(d6)) {
                point2D.setLocation(d2, d3);
                return true;
            }
            double d7 = (d4 - d2) / 2.0;
            double d8 = (d5 - d3) / 2.0;
            double d9 = d2 + d7;
            double d10 = d3 + d8;
            while (d6 > 0.1) {
                d6 /= 2.0;
                d7 /= 2.0;
                d8 /= 2.0;
                bl = nodePort.contains(d9, d10);
                if (!bl2) {
                    if (bl) {
                        d9 += d7;
                        d10 += d8;
                        if (!bl2) continue;
                    }
                    d9 -= d7;
                    d10 -= d8;
                    if (!bl2) continue;
                }
                break block8;
            }
            point2D.setLocation(d9, d10);
            bl = true;
        }
        return bl;
    }

    public void paint(NodePort nodePort, Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        Color color = graphics2D.getColor();
        NodeRealizer nodeRealizer = nodePort.getRealizer();
        Rectangle2D rectangle2D = NodePort.b(nodePort);
        if (this.initializeFill(nodeRealizer, nodePort, graphics2D)) {
            graphics2D.fill(rectangle2D);
        }
        if (this.initializeLine(nodeRealizer, nodePort, graphics2D)) {
            graphics2D.draw(rectangle2D);
        }
        this.paintSelectionBox(nodeRealizer, nodePort, graphics2D);
        graphics2D.setColor(color);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    protected void paintSelectionBox(NodeRealizer nodeRealizer, NodePort nodePort, Graphics2D graphics2D) {
        if (NodePort.b(nodePort, graphics2D)) {
            YRectangle yRectangle = nodePort.getBounds();
            Rectangle2D.Double double_ = c.b().m;
            double_.setFrame(yRectangle.getX() - 2.0, yRectangle.getY() - 2.0, yRectangle.getWidth() + 4.0, yRectangle.getHeight() + 4.0);
            Color color = this.getPortLineColor(nodeRealizer, nodePort, true);
            graphics2D.setColor(color == null ? Color.BLACK : color);
            graphics2D.setStroke(LineType.LINE_1);
            graphics2D.draw(double_);
        }
    }

    protected boolean initializeFill(NodeRealizer nodeRealizer, NodePort nodePort, Graphics2D graphics2D) {
        Paint paint = this.getPortPaint(nodeRealizer, nodePort, NodePort.b(nodePort, graphics2D));
        if (paint != null) {
            graphics2D.setPaint(paint);
            return true;
        }
        return false;
    }

    protected Paint getPortPaint(NodeRealizer nodeRealizer, NodePort nodePort, boolean bl) {
        return this.getPortPaint(nodeRealizer, bl);
    }

    protected Paint getPortPaint(NodeRealizer nodeRealizer, boolean bl) {
        Color color = nodeRealizer.getFillColor();
        if (nodeRealizer.isSelected() && color != null) {
            return color.darker();
        }
        return color;
    }

    protected boolean initializeLine(NodeRealizer nodeRealizer, NodePort nodePort, Graphics2D graphics2D) {
        Stroke stroke;
        boolean bl = NodePort.b(nodePort, graphics2D);
        Color color = this.getPortLineColor(nodeRealizer, nodePort, bl);
        if (color != null && (stroke = this.getPortStroke(nodeRealizer, nodePort, bl)) != null) {
            graphics2D.setColor(color);
            graphics2D.setStroke(stroke);
            return true;
        }
        return false;
    }

    protected Stroke getPortStroke(NodeRealizer nodeRealizer, NodePort nodePort, boolean bl) {
        return this.getPortStroke(nodeRealizer, bl);
    }

    protected Stroke getPortStroke(NodeRealizer nodeRealizer, boolean bl) {
        return nodeRealizer.getLineType();
    }

    protected Color getPortLineColor(NodeRealizer nodeRealizer, NodePort nodePort, boolean bl) {
        return this.getPortLineColor(nodeRealizer, bl);
    }

    protected Color getPortLineColor(NodeRealizer nodeRealizer, boolean bl) {
        Color color = nodeRealizer.getLineColor();
        return color == null ? Color.BLACK : color;
    }

    public YRectangle getBounds(NodePort nodePort) {
        YPoint yPoint = nodePort.getLocation();
        YDimension yDimension = this.getSize();
        double d2 = yDimension.getWidth();
        double d3 = yDimension.getHeight();
        YPoint yPoint2 = this.getRatio();
        return new YRectangle(yPoint.getX() - d2 * yPoint2.getX(), yPoint.getY() - d3 * yPoint2.getY(), d2, d3);
    }

    public void calcUnionRect(NodePort nodePort, Rectangle2D rectangle2D) {
        block3: {
            YRectangle yRectangle;
            block2: {
                yRectangle = nodePort.getBounds();
                if (!(rectangle2D.getWidth() <= 0.0)) break block2;
                rectangle2D.setFrame(yRectangle.getX(), yRectangle.getY(), yRectangle.getWidth(), yRectangle.getHeight());
                if (!NodeRealizer.z) break block3;
            }
            rectangle2D.add(yRectangle.getX(), yRectangle.getY());
            rectangle2D.add(yRectangle.getX() + yRectangle.getWidth(), yRectangle.getY() + yRectangle.getHeight());
        }
    }
}

