/*
 * Decompiled with CFR 0.152.
 */
package y.view.tabular;

import java.awt.Color;
import java.awt.Stroke;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.w3c.dom.Element;
import y.base.Node;
import y.io.BadVersionException;
import y.io.gml.EdgeGraphicsParser;
import y.io.gml.EdgeRealizerObjectEncoder;
import y.io.graphml.graph2d.GraphicsSerializationToolkit;
import y.io.graphml.input.DeserializationEvent;
import y.io.graphml.input.DeserializationHandler;
import y.io.graphml.output.SerializationEvent;
import y.io.graphml.output.SerializationHandler;
import y.io.graphml.output.SerializationNotSupportedException;
import y.io.graphml.output.XmlWriter;
import y.view.Graph2D;
import y.view.LineType;
import y.view.NodeRealizer;
import y.view.tabular.TableGroupNodeRealizer;

public interface TableStyle {
    public Stroke getBorderLineType(NodeRealizer var1);

    public Color getBorderLineColor(NodeRealizer var1);

    public Color getBorderFillColor(NodeRealizer var1);

    public Stroke getLineType(NodeRealizer var1);

    public Color getLineColor(NodeRealizer var1);

    public Color getFillColor(NodeRealizer var1);

    public static class SimpleStyleDeserializer
    implements DeserializationHandler {
        public void onHandleDeserialization(DeserializationEvent deserializationEvent) {
            org.w3c.dom.Node node = deserializationEvent.getXmlNode();
            if ("SimpleStyle".equals(node.getLocalName()) && "http://www.yworks.com/xml/graphml".equals(node.getNamespaceURI()) && node.getNodeType() == 1) {
                Element element = (Element)node;
                LineType lineType = null;
                String string2 = element.getAttribute("borderLineType");
                String string3 = element.getAttribute("borderLineWidth");
                if (!"".equals(string2) && !"".equals(string3)) {
                    int n2 = (int)Double.parseDouble(string3);
                    byte by = EdgeGraphicsParser.decodeLineStyle(string2);
                    lineType = LineType.getLineType(n2, by);
                }
                Color color = null;
                String string4 = element.getAttribute("borderLineColor");
                if (!"".equals(string4)) {
                    color = GraphicsSerializationToolkit.parseColor(string4);
                }
                Color color2 = null;
                String string5 = element.getAttribute("borderFillColor");
                if (!"".equals(string5)) {
                    color2 = GraphicsSerializationToolkit.parseColor(string5);
                }
                LineType lineType2 = null;
                String string6 = element.getAttribute("lineType");
                String string7 = element.getAttribute("lineWidth");
                if (!"".equals(string6) && !"".equals(string7)) {
                    int n3 = (int)Double.parseDouble(string7);
                    byte by = EdgeGraphicsParser.decodeLineStyle(string6);
                    lineType2 = LineType.getLineType(n3, by);
                }
                Color color3 = null;
                String string8 = element.getAttribute("lineColor");
                if (!"".equals(string8)) {
                    color3 = GraphicsSerializationToolkit.parseColor(string8);
                }
                Color color4 = null;
                String string9 = element.getAttribute("fillColor");
                if (!"".equals(string9)) {
                    color4 = GraphicsSerializationToolkit.parseColor(string9);
                }
                deserializationEvent.setResult(new SimpleStyle(lineType, color, color2, lineType2, color3, color4));
            }
        }
    }

    public static class SimpleStyleSerializer
    implements SerializationHandler {
        private static final String z = "SimpleStyle";

        public void onHandleSerialization(SerializationEvent serializationEvent) throws SerializationNotSupportedException {
            Object object = serializationEvent.getItem();
            if (object instanceof SimpleStyle) {
                String string2;
                String string3;
                LineType lineType;
                String string4;
                String string5;
                SimpleStyle simpleStyle = (SimpleStyle)object;
                XmlWriter xmlWriter = serializationEvent.getWriter();
                Node node = (Node)serializationEvent.getContext().getCurrentObject();
                Graph2D graph2D = (Graph2D)serializationEvent.getContext().getGraph();
                NodeRealizer nodeRealizer = graph2D.getRealizer(node);
                xmlWriter.writeStartElement(z, "http://www.yworks.com/xml/graphml");
                LineType lineType2 = (LineType)simpleStyle.getBorderLineType(nodeRealizer);
                if (lineType2 != null) {
                    string5 = EdgeRealizerObjectEncoder.encodeLineStyle(lineType2.getLineStyle());
                    xmlWriter.writeAttribute("borderLineType", string5);
                    xmlWriter.writeAttribute("borderLineWidth", lineType2.getLineWidth());
                }
                if ((string5 = GraphicsSerializationToolkit.valueOf(simpleStyle.getBorderLineColor(nodeRealizer))) != null) {
                    xmlWriter.writeAttribute("borderLineColor", string5);
                }
                if ((string4 = GraphicsSerializationToolkit.valueOf(simpleStyle.getBorderFillColor(nodeRealizer))) != null) {
                    xmlWriter.writeAttribute("borderFillColor", string4);
                }
                if ((lineType = (LineType)simpleStyle.getLineType(nodeRealizer)) != null) {
                    string3 = EdgeRealizerObjectEncoder.encodeLineStyle(lineType.getLineStyle());
                    xmlWriter.writeAttribute("lineType", string3);
                    xmlWriter.writeAttribute("lineWidth", lineType.getLineWidth());
                }
                if ((string3 = GraphicsSerializationToolkit.valueOf(simpleStyle.getLineColor(nodeRealizer))) != null) {
                    xmlWriter.writeAttribute("lineColor", string3);
                }
                if ((string2 = GraphicsSerializationToolkit.valueOf(simpleStyle.getFillColor(nodeRealizer))) != null) {
                    xmlWriter.writeAttribute("fillColor", string2);
                }
                xmlWriter.writeEndElement();
                serializationEvent.setHandled(true);
            }
        }
    }

    public static class SimpleStyle
    implements Externalizable,
    TableStyle {
        private LineType h;
        private Color c;
        private Color d;
        private LineType f;
        private Color e;
        private Color g;

        public SimpleStyle() {
            this(null, null, null, null, null, null);
        }

        public SimpleStyle(LineType lineType, Color color, Color color2) {
            this(null, null, null, lineType, color, color2);
        }

        public SimpleStyle(LineType lineType, Color color, Color color2, LineType lineType2, Color color3, Color color4) {
            this.h = lineType;
            this.c = color;
            this.d = color2;
            this.f = lineType2;
            this.e = color3;
            this.g = color4;
        }

        public Stroke getBorderLineType(NodeRealizer nodeRealizer) {
            return this.h;
        }

        public Color getBorderLineColor(NodeRealizer nodeRealizer) {
            return this.c;
        }

        public Color getBorderFillColor(NodeRealizer nodeRealizer) {
            return this.d;
        }

        public Stroke getLineType(NodeRealizer nodeRealizer) {
            return this.f;
        }

        public Color getLineColor(NodeRealizer nodeRealizer) {
            return this.e;
        }

        public Color getFillColor(NodeRealizer nodeRealizer) {
            return this.g;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            switch (objectInput.readByte()) {
                case 0: {
                    this.h = LineType.createLineType(objectInput);
                    this.c = (Color)objectInput.readObject();
                    this.d = (Color)objectInput.readObject();
                    this.f = LineType.createLineType(objectInput);
                    this.e = (Color)objectInput.readObject();
                    this.g = (Color)objectInput.readObject();
                    if (!TableGroupNodeRealizer.z) break;
                }
                default: {
                    throw new BadVersionException();
                }
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeByte(0);
            LineType.serializeLineType(objectOutput, this.h);
            objectOutput.writeObject(this.c);
            objectOutput.writeObject(this.d);
            LineType.serializeLineType(objectOutput, this.f);
            objectOutput.writeObject(this.e);
            objectOutput.writeObject(this.g);
        }
    }
}

