/*
 * Decompiled with CFR 0.152.
 */
package yext.svg.io;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Writer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import y.view.DefaultGraph2DRenderer;
import y.view.EdgeRealizer;
import y.view.NodeRealizer;
import yext.svg.io.SVGIOHandler;

public class SVGGraph2DRenderer
extends DefaultGraph2DRenderer {
    private SVGIOHandler A;

    public void setSVGIOHandler(SVGIOHandler sVGIOHandler) {
        this.A = sVGIOHandler;
    }

    protected SVGIOHandler getSVGIOHandler() {
        return this.A;
    }

    protected Document getSVGDocument() {
        return this.getSVGIOHandler().getDocument();
    }

    protected Element getTopLevelGroup() {
        return this.getSVGIOHandler().A().getTopLevelGroup(false);
    }

    protected void setTopLevelGroup(Element element) {
        this.getSVGIOHandler().A().setTopLevelGroup(element);
    }

    protected Element createElement(String string2) {
        return this.getSVGDocument().createElement(string2);
    }

    protected CDATASection createCDATASection(String string2) {
        return this.getSVGDocument().createCDATASection(string2);
    }

    protected void insertNodeAbove(Node node, Node node2) {
        Node node3 = node2.getParentNode();
        node3.removeChild(node2);
        node.appendChild(node2);
        node3.appendChild(node);
    }

    protected void insertNodeBelow(Node node, Node node2) {
        Node node3;
        while ((node3 = node2.getFirstChild()) != null) {
            node2.removeChild(node3);
            node.appendChild(node3);
        }
        node2.appendChild(node);
    }

    protected void addToSVGDefinition(Element element) {
        this.getSVGIOHandler().A().getDOMTreeManager().addOtherDef(element);
    }

    protected void writeDocument(Node node, Writer writer) throws IOException {
        this.getSVGIOHandler().A(node, writer);
    }

    public void paint(Graphics2D graphics2D, NodeRealizer nodeRealizer) {
        Shape shape = graphics2D.getClip();
        if (shape != null && shape.contains(SVGGraph2DRenderer.A(nodeRealizer))) {
            graphics2D.setClip(null);
        }
        nodeRealizer.paint(graphics2D);
        graphics2D.setClip(shape);
    }

    public void paintSloppy(Graphics2D graphics2D, NodeRealizer nodeRealizer) {
        Shape shape = graphics2D.getClip();
        if (shape != null && shape.contains(SVGGraph2DRenderer.A(nodeRealizer))) {
            graphics2D.setClip(null);
        }
        nodeRealizer.paintSloppy(graphics2D);
        graphics2D.setClip(shape);
    }

    public void paint(Graphics2D graphics2D, EdgeRealizer edgeRealizer) {
        Shape shape = graphics2D.getClip();
        if (shape != null && shape.contains(SVGGraph2DRenderer.A(edgeRealizer))) {
            graphics2D.setClip(null);
        }
        edgeRealizer.paint(graphics2D);
        graphics2D.setClip(shape);
    }

    public void paintSloppy(Graphics2D graphics2D, EdgeRealizer edgeRealizer) {
        Shape shape = graphics2D.getClip();
        if (shape != null && shape.contains(SVGGraph2DRenderer.A(edgeRealizer))) {
            graphics2D.setClip(null);
        }
        edgeRealizer.paintSloppy(graphics2D);
        graphics2D.setClip(shape);
    }

    private static Rectangle2D A(NodeRealizer nodeRealizer) {
        Rectangle2D.Double double_ = nodeRealizer.getBoundingBox();
        if (nodeRealizer.isSelected()) {
            double_.setFrame(double_.getX() - 10.0, double_.getY() - 10.0, double_.getWidth() + 20.0, double_.getHeight() + 20.0);
        }
        nodeRealizer.calcUnionRect(double_);
        return double_;
    }

    private static Rectangle2D A(EdgeRealizer edgeRealizer) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, -1.0, -1.0);
        edgeRealizer.calcUnionRect(double_);
        return double_;
    }
}

