/*
 * Decompiled with CFR 0.152.
 */
package yext.svg.io;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import y.io.IOHandler;
import y.view.Graph2D;
import y.view.Graph2DRenderer;
import y.view.Graph2DView;
import yext.svg.io.A;
import yext.svg.io.SVGGraph2DRenderer;
import yext.svg.util.IdGenerator;
import yext.svg.view.SVGModel;

public class SVGIOHandler
extends IOHandler {
    private Document B;
    private SVGGraphics2D E;
    private SVGGraph2DRenderer A;
    private Graph2DView F;
    private Graph2DView D;
    private boolean C = true;
    private boolean G = false;
    private Object H = SVGModel.VALUE_SVG_RENDERING_FORCE_VECTORIZATION;

    public String getFileFormatString() {
        return "SVG Format";
    }

    public String getFileNameExtension() {
        return "svg";
    }

    public boolean canRead() {
        return false;
    }

    public void setSVGGraph2DRenderer(SVGGraph2DRenderer sVGGraph2DRenderer) {
        this.A = sVGGraph2DRenderer;
    }

    public SVGGraph2DRenderer getSVGGraph2DRenderer() {
        if (this.A != null) {
            this.A.setSVGIOHandler(this);
        }
        return this.A;
    }

    public Object getSVGRenderingHintValue() {
        return this.H;
    }

    public void setSVGRenderingHintValue(Object object) {
        if (SVGModel.KEY_SVG_RENDERING.isCompatibleValue(object)) {
            this.H = object != null ? object : SVGModel.VALUE_SVG_RENDERING_DEFAULT;
        } else {
            throw new IllegalArgumentException("Incompatible SVG rendering hint value: " + object);
        }
    }

    public boolean isUseCSS() {
        return this.G;
    }

    public void setUseCSS(boolean bl) {
        this.G = bl;
    }

    public Graph2DView getActiveGraph2DView() {
        return this.D;
    }

    SVGGraphics2D A() {
        return this.E;
    }

    public void read(Graph2D graph2D, InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException("Can't read files in " + this.getFileFormatString());
    }

    public void write(Graph2D graph2D, OutputStream outputStream) throws IOException {
        Graph2DView graph2DView;
        this.E = new _A(this.getDocument());
        this.E.getGeneratorContext().setComment("Generated by ySVG");
        this.E.setRenderingHint(SVGModel.KEY_SVG_RENDERING, this.H);
        this.E.setRenderingHint(IdGenerator.KEY_ID_GENERATOR, (Object)new IdGenerator());
        this.D = graph2DView = (Graph2DView)graph2D.getCurrentView();
        if (this.F != null) {
            this.D = this.F;
            this.D.setGraph2D(graph2D);
        }
        if (this.D == null) {
            this.D = this.createDefaultGraph2DView(graph2D);
        }
        Dimension dimension = this.D.getCanvasSize();
        if (this.isCanvasSizeAssigned()) {
            this.E.setSVGCanvasSize(dimension);
        }
        Graph2DRenderer graph2DRenderer = this.D.getGraph2DRenderer();
        if (this.getSVGGraph2DRenderer() != null) {
            this.D.setGraph2DRenderer(this.getSVGGraph2DRenderer());
        }
        this.D.paintVisibleContent((Graphics2D)this.E);
        if (this.getSVGGraph2DRenderer() != null) {
            this.D.setGraph2DRenderer(graph2DRenderer);
        }
        if (graph2DView == null || this.D == this.F) {
            if (graph2DView != this.D) {
                graph2D.removeView(this.D);
            }
            if (graph2DView != null) {
                graph2D.setCurrentView(graph2DView);
            }
        }
        this.D = null;
        this.A(this.E.getRoot(), new OutputStreamWriter(outputStream, "UTF-8"), this.G);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void A(Element element, Writer writer, boolean bl) throws IOException {
        Node node;
        Node node2;
        block6: {
            node2 = element.getParentNode();
            node = element.getNextSibling();
            try {
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/svg");
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
                DocumentFragment documentFragment = element.getOwnerDocument().createDocumentFragment();
                documentFragment.appendChild(element);
                if (bl) {
                    yext.svg.io.A.A(documentFragment, true);
                }
                if (this.getSVGGraph2DRenderer() != null) {
                    this.getSVGGraph2DRenderer().writeDocument(documentFragment, writer);
                } else {
                    this.A(documentFragment, writer);
                }
                writer.flush();
                Object var8_7 = null;
                if (node2 == null) return;
                if (node != null) break block6;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (node2 == null) throw throwable;
                if (node == null) {
                    node2.appendChild(element);
                    throw throwable;
                }
                node2.insertBefore(element, node);
                throw throwable;
            }
            node2.appendChild(element);
            return;
        }
        node2.insertBefore(element, node);
    }

    void A(Node node, Writer writer) throws IOException {
        try {
            DOMSource dOMSource = new DOMSource(node);
            StreamResult streamResult = new StreamResult(writer);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            try {
                transformerFactory.setAttribute("indent-number", new Integer(2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IOException(transformerConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new IOException(transformerException.getMessage());
        }
    }

    protected Document createDocument() {
        DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
        return dOMImplementation.createDocument(null, "svg", null);
    }

    public Document getDocument() {
        if (this.B == null) {
            this.B = this.createDocument();
        }
        return this.B;
    }

    public Graph2DView createDefaultGraph2DView(Graph2D graph2D) {
        Graph2DView graph2DView = new Graph2DView(graph2D);
        Rectangle rectangle = graph2D.getBoundingBox();
        Dimension dimension = new Dimension(rectangle.width, rectangle.height);
        graph2DView.setSize(dimension);
        graph2DView.setPreferredSize(dimension);
        graph2DView.zoomToArea(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
        graph2DView.setPaintDetailThreshold(0.0);
        return graph2DView;
    }

    public void setGraph2DView(Graph2DView graph2DView) {
        this.F = graph2DView;
    }

    public Graph2DView getGraph2DView() {
        return this.F;
    }

    public boolean isCanvasSizeAssigned() {
        return this.C;
    }

    public void setCanvasSizeAssigned(boolean bl) {
        this.C = bl;
    }

    private static class _A
    extends SVGGraphics2D {
        _A(Document document) {
            super(document);
        }

        _A(_A _A2) {
            super((SVGGraphics2D)_A2);
        }

        public Graphics create() {
            return new _A(this);
        }

        public void setRenderingHint(RenderingHints.Key key, Object object) {
            if (!RenderingHints.KEY_ANTIALIASING.equals(key) && !RenderingHints.KEY_TEXT_ANTIALIASING.equals(key)) {
                super.setRenderingHint(key, object);
            }
        }
    }
}

