/*
 * Decompiled with CFR 0.152.
 */
package yext.svg.io;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.io.graphml.graph2d.AbstractNodeRealizerSerializer;
import y.io.graphml.graph2d.GraphicsSerializationToolkit;
import y.io.graphml.graph2d.ResourceDescriptor;
import y.io.graphml.graph2d.ResourceDeserializationHandler;
import y.io.graphml.graph2d.ResourceSerializationHandler;
import y.io.graphml.input.DeserializationEvent;
import y.io.graphml.input.DeserializationHandler;
import y.io.graphml.input.GraphMLParseContext;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.output.GraphMLWriteContext;
import y.io.graphml.output.GraphMLWriteException;
import y.io.graphml.output.SerializationEvent;
import y.io.graphml.output.SerializationHandler;
import y.io.graphml.output.XmlWriter;
import y.util.D;
import y.view.NodeRealizer;
import yext.svg.view.SVGModel;
import yext.svg.view.SVGNodeRealizer;

public class SVGNodeRealizerSerializer
extends AbstractNodeRealizerSerializer {
    private static final _A A = new _A();

    public String getName() {
        return "SVGNode";
    }

    public String getNamespaceURI() {
        return "http://www.yworks.com/xml/graphml";
    }

    public Class getRealizerClass() {
        return SVGNodeRealizer.class;
    }

    public void write(NodeRealizer nodeRealizer, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) throws GraphMLWriteException {
        super.write(nodeRealizer, xmlWriter, graphMLWriteContext);
        SVGNodeRealizer sVGNodeRealizer = (SVGNodeRealizer)nodeRealizer;
        SVGModel sVGModel = sVGNodeRealizer.getModel();
        xmlWriter.writeStartElement("SVGModel", "http://www.yworks.com/xml/graphml");
        if (sVGModel != null) {
            this.A(sVGModel, xmlWriter, graphMLWriteContext);
        }
        xmlWriter.writeEndElement();
    }

    private void A(SVGModel sVGModel, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) {
        if (graphMLWriteContext == null || sVGModel == null) {
            return;
        }
        xmlWriter.writeAttribute("svgBoundsPolicy", String.valueOf(sVGModel.getSVGBoundsPolicy()));
        ResourceSerializationHandler resourceSerializationHandler = (ResourceSerializationHandler)graphMLWriteContext.lookup(ResourceSerializationHandler.class);
        ResourceDescriptor resourceDescriptor = null;
        StringWriter stringWriter = new StringWriter();
        String string2 = null;
        try {
            sVGModel.serializeSVGContent(stringWriter);
            string2 = stringWriter.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (resourceSerializationHandler != null && string2 != null) {
            resourceDescriptor = resourceSerializationHandler.registerResource(string2, A);
        }
        xmlWriter.writeStartElement("SVGContent", "http://www.yworks.com/xml/graphml");
        if (resourceDescriptor != null) {
            xmlWriter.writeAttribute("refid", resourceDescriptor.getId());
        } else if (string2 != null) {
            xmlWriter.writeText(string2.replaceAll("\r\n", "\n"));
        } else {
            URL uRL = sVGModel.getSVGURL();
            if (uRL != null) {
                xmlWriter.writeAttribute("href", uRL.toString());
            }
        }
        xmlWriter.writeEndElement();
    }

    public void parse(NodeRealizer nodeRealizer, Node node, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        SVGNodeRealizer sVGNodeRealizer = (SVGNodeRealizer)nodeRealizer;
        super.parse(sVGNodeRealizer, node, graphMLParseContext);
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                String string2;
                Node node2 = nodeList.item(i2);
                if (node2.getNodeType() != 1 || !"SVGModel".equals(string2 = node2.getLocalName()) || !"http://www.yworks.com/xml/graphml".equals(node2.getNamespaceURI())) continue;
                this.A(sVGNodeRealizer, node2, graphMLParseContext);
                Node node3 = node2.getAttributes().getNamedItem("svgBoundsPolicy");
                if (node3 == null) continue;
                sVGNodeRealizer.getModel().setSVGBoundsPolicy(Integer.parseInt(node3.getNodeValue()));
            }
        }
    }

    private void A(SVGNodeRealizer sVGNodeRealizer, Node node, GraphMLParseContext graphMLParseContext) throws GraphMLParseException {
        if (graphMLParseContext == null) {
            return;
        }
        ResourceDeserializationHandler resourceDeserializationHandler = (ResourceDeserializationHandler)graphMLParseContext.lookup(ResourceDeserializationHandler.class);
        NodeList nodeList = node.getChildNodes();
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Node node2 = nodeList.item(i2);
            if (node2.getNodeType() != 1 || !"SVGContent".equals(node2.getLocalName()) || !"http://www.yworks.com/xml/graphml".equals(node2.getNamespaceURI())) continue;
            SVGModel sVGModel = null;
            NamedNodeMap namedNodeMap = node2.getAttributes();
            Node node3 = namedNodeMap.getNamedItem("refid");
            if (node3 != null && resourceDeserializationHandler != null) {
                sVGModel = (SVGModel)resourceDeserializationHandler.getResourceForID(node3.getNodeValue(), A, null, graphMLParseContext);
            } else {
                Node node4 = node2.getFirstChild();
                if (node4.getNodeType() == 3) {
                    String string2 = node4.getNodeValue();
                    sVGModel = new SVGModel(new StringReader(string2));
                }
            }
            if (sVGModel != null) {
                sVGNodeRealizer.setModel((SVGModel)sVGModel.clone());
                continue;
            }
            node3 = namedNodeMap.getNamedItem("href");
            if (node3 == null) continue;
            try {
                sVGNodeRealizer.setSVGURL(new URL(node3.getNodeValue()));
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                if (GraphicsSerializationToolkit.getBooleanDeserializationProperty(graphMLParseContext, "y.io.graphml.input.DeserializationProperties.IGNORE_RESOURCE_ERRORS")) {
                    D.bug("Cannot load SVG from: " + node3.getNodeValue());
                    continue;
                }
                throw new GraphMLParseException("Cannot load SVG from: " + node3.getNodeValue(), malformedURLException);
            }
        }
    }

    private static class _A
    implements DeserializationHandler,
    SerializationHandler {
        private _A() {
        }

        public Object A(Node node, GraphMLParseContext graphMLParseContext) {
            SVGModel sVGModel = null;
            if (node != null && node.getNodeType() == 3) {
                String string2 = node.getNodeValue();
                sVGModel = new SVGModel(new StringReader(string2));
            }
            return sVGModel;
        }

        public void onHandleDeserialization(DeserializationEvent deserializationEvent) throws GraphMLParseException {
            Node node = deserializationEvent.getXmlNode();
            if (node != null && node.getNodeType() == 3) {
                deserializationEvent.setResult(this.A(node, deserializationEvent.getContext()));
            }
        }

        public void A(Object object, XmlWriter xmlWriter, GraphMLWriteContext graphMLWriteContext) {
            String string2 = (String)object;
            xmlWriter.writeText(string2.replaceAll("\r\n", "\n"));
        }

        public void onHandleSerialization(SerializationEvent serializationEvent) throws GraphMLWriteException {
            Object object = serializationEvent.getItem();
            if (object instanceof String) {
                this.A(object, serializationEvent.getWriter(), serializationEvent.getContext());
                serializationEvent.setHandled(true);
            }
        }
    }
}

