/*
 * Decompiled with CFR 0.152.
 */
package yext.svg.view;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import y.io.BadVersionException;
import y.view.NodeRealizer;
import yext.svg.view.SVGModel;

public class SVGNodeRealizer
extends NodeRealizer {
    SVGModel A;

    public SVGNodeRealizer() {
        this.A();
    }

    public SVGNodeRealizer(SVGModel sVGModel) {
        this();
        this.A = sVGModel;
        this.setToOriginalSize();
    }

    public SVGNodeRealizer(URL uRL) {
        this();
        this.setSVGURL(uRL);
        this.setToOriginalSize();
    }

    public SVGNodeRealizer(NodeRealizer nodeRealizer) {
        super(nodeRealizer);
        if (nodeRealizer instanceof SVGNodeRealizer) {
            SVGNodeRealizer sVGNodeRealizer = (SVGNodeRealizer)nodeRealizer;
            this.A = (SVGModel)sVGNodeRealizer.A.clone();
        } else {
            this.A();
        }
    }

    private void A() {
        this.A = new SVGModel();
        this.getLabel().setModel((byte)5);
        this.getLabel().setPosition((byte)109);
    }

    public NodeRealizer createCopy(NodeRealizer nodeRealizer) {
        return new SVGNodeRealizer(nodeRealizer);
    }

    public boolean findIntersection(double d2, double d3, double d4, double d5, Point2D point2D) {
        if (d2 == d4 && d3 == d5) {
            return false;
        }
        if (!this.contains(d2, d3) || this.contains(d4, d5)) {
            return false;
        }
        super.findIntersection(d2, d3, d4, d5, point2D);
        return true;
    }

    public URL getSVGURL() {
        return this.A.getSVGURL();
    }

    public void setSVGURL(URL uRL) {
        this.A.setSVGURL(uRL);
    }

    public SVGModel getModel() {
        return this.A;
    }

    public void setModel(SVGModel sVGModel) {
        this.A = sVGModel;
    }

    public void setToOriginalSize() {
        Rectangle2D rectangle2D;
        if (this.A.isInitialized() && (rectangle2D = this.A.getSvgBounds()) != null) {
            this.setSize(rectangle2D.getWidth(), rectangle2D.getHeight());
        }
    }

    public void paintNode(Graphics2D graphics2D) {
        if (this.A.isInitialized()) {
            this.A.paint(graphics2D, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.isSelected()) {
            this.paintHotSpots(graphics2D);
        }
        this.paintText(graphics2D);
    }

    public void write(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(1);
        super.write(objectOutputStream);
        this.getModel().A(objectOutputStream);
    }

    public void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        switch (objectInputStream.readByte()) {
            case 0: {
                super.read(objectInputStream);
                this.setSVGURL((URL)objectInputStream.readObject());
                break;
            }
            case 1: {
                super.read(objectInputStream);
                this.getModel().A(objectInputStream);
                break;
            }
            default: {
                throw new BadVersionException();
            }
        }
    }
}

