/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.extensions.SassExtension;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.references.SassScssFunctionReference;

public class SassExtensionFunctionDocumentationProvider
extends DocumentationProviderEx {
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof CssFunction && element.getContainingFile() instanceof SassScssStylesheetFile) {
            for (PsiReference reference : element.getReferences()) {
                Collection<SassExtensionFunctionInfo> functionInfos;
                SassExtensionFunctionInfo function;
                PsiElement realElement;
                Module module;
                PsiElement resultResult = reference.resolve();
                if (!(reference instanceof SassScssFunctionReference) || resultResult != element && resultResult != null && SassExtensionFunctionDocumentationProvider.isSassScssLanguage(resultResult.getLanguage()) || (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(realElement = originalElement != null ? originalElement : element))) == null || (function = (SassExtensionFunctionInfo)ContainerUtil.getFirstItem(functionInfos = SassExtension.findExtensionFunctionInfos(((CssFunction)element).getName(), originalElement, module))) == null) continue;
                return function.getDocumentation();
            }
        }
        return super.generateDoc(element, originalElement);
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (SassRubyIntegrationHelper.getInstance().isSassExtensionLookupObject(object) && element != null && element.getContainingFile() instanceof SassScssStylesheetFile) {
            String name = object instanceof SassExtensionFunctionInfo ? ((SassExtensionFunctionInfo)object).getName() : (object instanceof LookupElement ? ((LookupElement)object).getLookupString() : object.toString());
            CssTerm term = CssElementFactory.getInstance((Project)element.getProject()).createTerm(name + "()", CssPsiUtil.getStylesheetLanguage((PsiElement)element));
            PsiElement firstChild = term.getFirstChild();
            if (firstChild instanceof CssFunction) {
                firstChild.putUserData(DocumentationManager.ORIGINAL_ELEMENT_KEY, (Object)SmartPointerManager.getInstance((Project)psiManager.getProject()).createSmartPsiElementPointer(element));
                return firstChild;
            }
        }
        return super.getDocumentationElementForLookupItem(psiManager, object, element);
    }

    @Nullable
    public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/plugins/sass/extensions/SassExtensionFunctionDocumentationProvider", "getCustomDocumentationElement"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/sass/extensions/SassExtensionFunctionDocumentationProvider", "getCustomDocumentationElement"));
        }
        CssFunction function = (CssFunction)PsiTreeUtil.getParentOfType((PsiElement)contextElement, CssFunction.class, (boolean)false);
        return function != null ? function : super.getCustomDocumentationElement(editor, file, contextElement);
    }

    private static boolean isSassScssLanguage(Language language) {
        return language == SCSSLanguage.INSTANCE || language == SASSLanguage.INSTANCE;
    }
}

