/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionInfo;
import org.jetbrains.plugins.sass.extensions.SassExtensionFunctionsIndex;
import org.jetbrains.plugins.sass.extensions.SassRubyIntegrationHelper;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;

public class SassRubyIntegrationHelperImpl
extends SassRubyIntegrationHelper {
    @Override
    public void fillCompletionResultWithExtensionFunctions(final @NotNull CompletionResultSet resultSet, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (resultSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultSet", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "fillCompletionResultWithExtensionFunctions"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "fillCompletionResultWithExtensionFunctions"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "fillCompletionResultWithExtensionFunctions"));
        }
        FileBasedIndex index = FileBasedIndex.getInstance();
        Collection names = index.getAllKeys(SassExtensionFunctionsIndex.ID, project);
        final String prefix = resultSet.getPrefixMatcher().getPrefix();
        for (String name : names) {
            index.processValues(SassExtensionFunctionsIndex.ID, (Object)name, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<SassExtensionFunctionInfo>(){

                public boolean process(VirtualFile file, @NotNull SassExtensionFunctionInfo value) {
                    if (value == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl$1", "process"));
                    }
                    resultSet.addElement(SASSSCSSLangUtil.createCustomFunctionLookupItem(value, prefix));
                    return true;
                }
            }, scope);
        }
    }

    @Override
    @NotNull
    public Collection<? extends SassExtensionFunctionInfo> findExtensionFunctions(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "findExtensionFunctions"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "findExtensionFunctions"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "findExtensionFunctions"));
        }
        Collection<SassExtensionFunctionInfo> collection = SassExtensionFunctionsIndex.find(name, scope);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "findExtensionFunctions"));
        }
        return collection;
    }

    @Override
    public boolean hasRubyPlugin() {
        return false;
    }

    @Override
    public boolean isRubyModule(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "isRubyModule"));
        }
        return false;
    }

    @Override
    public boolean isGemInstalled(@NotNull String gemNameOrUrl, @NotNull Module module) {
        if (gemNameOrUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gemNameOrUrl", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "isGemInstalled"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/SassRubyIntegrationHelperImpl", "isGemInstalled"));
        }
        return false;
    }
}

