/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.highlighting;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.ide.highlighter.XmlFileHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.highlighting.SASSSyntaxHighlighter;
import org.jetbrains.plugins.sass.highlighting.SassScssHighlightingColors;
import org.jetbrains.plugins.scss.lexer.SCSSHighlightingLexer;
import org.jetbrains.plugins.scss.lexer.SCSSTokenTypes;

public class SCSSSyntaxHighlighter
extends SASSSyntaxHighlighter
implements SCSSTokenTypes {
    private static final HashMap<IElementType, TextAttributesKey> mapping = ContainerUtil.newHashMap();

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = mapping.containsKey(tokenType) ? SCSSSyntaxHighlighter.pack((TextAttributesKey)mapping.get(tokenType)) : super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/highlighting/SCSSSyntaxHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    @Override
    @NotNull
    public Lexer getHighlightingLexer() {
        SCSSHighlightingLexer sCSSHighlightingLexer = new SCSSHighlightingLexer(CssElementDescriptorFactory2.getInstance().getValueIdentifiers());
        if (sCSSHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/scss/highlighting/SCSSSyntaxHighlighter", "getHighlightingLexer"));
        }
        return sCSSHighlightingLexer;
    }

    static {
        mapping.put(SCSSTokenTypes.COMMENT, SassScssHighlightingColors.COMMENT);
        HtmlFileHighlighter.registerEmbeddedTokenAttributes(mapping, null);
        XmlFileHighlighter.registerEmbeddedTokenAttributes(mapping, null);
    }
}

