/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.compose.cli.DockerComposeCli;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.BlockingSet;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;

public class DockerComposeProjectService {
    private static final Logger LOG = Logger.getInstance(DockerComposeProjectService.class);
    private static final String DEFAULT_DOCKER_COMPOSE_VERSION = "1.10.0";
    private final BlockingSet<String> myBusyDockerComposeProjects = BlockingSet.newInstance();
    private final LoadingCache<String, String> myDockerComposeVersionsCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, String>(){

        public String load(@NotNull String key) throws IOException {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/docker/compose/DockerComposeProjectService$1", "load"));
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            return DockerComposeCli.INSTANCE.getVersion(key, indicator);
        }
    });

    @NotNull
    public ProcessOutput runDockerComposeContainer(final @NotNull Path configurationPath, final @NotNull RemoteDockerApplicationRuntime applicationRuntime, @NotNull String taskTitle) throws InterruptedException, ServerRuntimeException, IOException {
        if (configurationPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationPath", "com/intellij/docker/compose/DockerComposeProjectService", "runDockerComposeContainer"));
        }
        if (applicationRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationRuntime", "com/intellij/docker/compose/DockerComposeProjectService", "runDockerComposeContainer"));
        }
        if (taskTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskTitle", "com/intellij/docker/compose/DockerComposeProjectService", "runDockerComposeContainer"));
        }
        final Ref dockerComposeProcessOutputRef = Ref.create();
        final Ref exceptionRef = Ref.create();
        Task.Modal task = new Task.Modal(null, taskTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/docker/compose/DockerComposeProjectService$2", "run"));
                }
                final Thread currentThread = Thread.currentThread();
                if (indicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)indicator).addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                        public void cancel() {
                            currentThread.interrupt();
                        }
                    });
                }
                try {
                    dockerComposeProcessOutputRef.set((Object)DockerComposeProjectService.this.runDockerComposeContainer(configurationPath, applicationRuntime));
                }
                catch (ServerRuntimeException | IOException | InterruptedException e) {
                    exceptionRef.set((Object)e);
                }
            }
        };
        if (ProgressManager.getInstance().hasProgressIndicator()) {
            task.run(ProgressManager.getInstance().getProgressIndicator());
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> ProgressManager.getInstance().run((Task)task), ModalityState.any());
        }
        if (!exceptionRef.isNull()) {
            Exception exception = (Exception)exceptionRef.get();
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            if (exception instanceof ServerRuntimeException) {
                throw (ServerRuntimeException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
        }
        ProcessOutput processOutput = (ProcessOutput)dockerComposeProcessOutputRef.get();
        if (processOutput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/DockerComposeProjectService", "runDockerComposeContainer"));
        }
        return processOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ProcessOutput runDockerComposeContainer(@NotNull Path configurationPath, RemoteDockerApplicationRuntime applicationRuntime) throws InterruptedException, ServerRuntimeException, IOException {
        if (configurationPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationPath", "com/intellij/docker/compose/DockerComposeProjectService", "runDockerComposeContainer"));
        }
        String projectName = DockerComposeConfigurationUtil.getDockerComposeProjectName(configurationPath);
        this.myBusyDockerComposeProjects.put((Object)projectName);
        ProcessOutput processOutput = applicationRuntime.startAndGetOutput();
        ProcessOutput processOutput2 = processOutput;
        if (processOutput2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/DockerComposeProjectService", "runDockerComposeContainer"));
        }
        return processOutput2;
        finally {
            this.myBusyDockerComposeProjects.remove((Object)projectName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDockerComposeContainer(@NotNull Path configurationPath, @NotNull Runnable runnable) {
        if (configurationPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurationPath", "com/intellij/docker/compose/DockerComposeProjectService", "runDockerComposeContainer"));
        }
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/docker/compose/DockerComposeProjectService", "runDockerComposeContainer"));
        }
        String projectName = DockerComposeConfigurationUtil.getDockerComposeProjectName(configurationPath);
        this.myBusyDockerComposeProjects.put((Object)projectName);
        try {
            runnable.run();
        }
        finally {
            this.myBusyDockerComposeProjects.remove((Object)projectName);
        }
    }

    @NotNull
    public String getDockerComposeVersion(@NotNull DockerCloudConfiguration dockerCloudConfiguration) {
        if (dockerCloudConfiguration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerCloudConfiguration", "com/intellij/docker/compose/DockerComposeProjectService", "getDockerComposeVersion"));
        }
        String dockerComposeExePath = dockerCloudConfiguration.getComposeExecPath();
        if (!StringUtil.isEmpty((String)dockerComposeExePath)) {
            String string;
            try {
                string = (String)this.myDockerComposeVersionsCache.get((Object)dockerComposeExePath);
            }
            catch (ExecutionException e) {
                LOG.debug("Error occurred while getting version of docker-compose executable: " + dockerComposeExePath, (Throwable)e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/DockerComposeProjectService", "getDockerComposeVersion"));
            }
            return string;
        }
        if (DEFAULT_DOCKER_COMPOSE_VERSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/DockerComposeProjectService", "getDockerComposeVersion"));
        }
        return DEFAULT_DOCKER_COMPOSE_VERSION;
    }

    @NotNull
    public static DockerComposeProjectService getInstance() {
        DockerComposeProjectService dockerComposeProjectService = (DockerComposeProjectService)ServiceManager.getService(DockerComposeProjectService.class);
        if (dockerComposeProjectService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/DockerComposeProjectService", "getInstance"));
        }
        return dockerComposeProjectService;
    }
}

