/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.commands;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.compose.commands.DockerComposeImageManager;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.common.PathsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

abstract class AbstractCmdExec {
    private static final Logger LOG = Logger.getInstance(AbstractCmdExec.class);
    public static final String DOCKER_SOCK_PATH = "/var/run/docker.sock";
    public static final String DOCKER_COMPOSE_FILE_OPTION = "-f";
    public static final String DOCKER_COMPOSE_DETACHED_OPTION = "-d";
    @NotNull
    protected final RemoteDockerRuntime myDockerRuntime;
    @NotNull
    protected final DockerComposeImageManager myDockerComposeImageManager;

    protected AbstractCmdExec(@NotNull RemoteDockerRuntime dockerRuntime) {
        if (dockerRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerRuntime", "com/intellij/docker/compose/commands/AbstractCmdExec", "<init>"));
        }
        this.myDockerRuntime = dockerRuntime;
        this.myDockerComposeImageManager = new DockerComposeImageManager(dockerRuntime);
    }

    protected void bindUnixDockerSock(@NotNull PathsBuilder pathsBuilder) {
        if (pathsBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathsBuilder", "com/intellij/docker/compose/commands/AbstractCmdExec", "bindUnixDockerSock"));
        }
        pathsBuilder.addPath(DOCKER_SOCK_PATH);
    }

    protected RemoteDockerApplicationRuntime doExec(String configurationFolderPath, ImmutableList.Builder<String> cmdBuilder, VolumesBuilder volumesBuilder, EnvsBuilder envsBuilder) throws IOException, ServerRuntimeException {
        DockerAgentDeploymentConfigImpl config = new DockerAgentDeploymentConfigImpl(this.myDockerComposeImageManager.getImageName(), volumesBuilder.build());
        config.withCommand(ArrayUtil.toStringArray((Collection)cmdBuilder.build())).withWorkingDir(configurationFolderPath);
        if (envsBuilder != null) {
            config.withEnvs(ServiceCmdExecUtils.filterDockerEnvs(envsBuilder.buildEnvs()));
        }
        return RemoteDockerApplicationRuntime.createWithImageInitialization(this.myDockerRuntime, config, this.myDockerComposeImageManager::buildImage);
    }
}

