/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.commands;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.compose.commands.AbstractCmdExec;
import com.intellij.docker.compose.commands.CreateContainerUpCmd;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationVolumesCollector;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.common.PathsBuilder;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CreateContainerUpCmdExec
extends AbstractCmdExec {
    private static final Logger LOG = Logger.getInstance(CreateContainerUpCmdExec.class);
    public static final String DOCKER_COMPOSE_UP_COMMAND = "up";
    private static final String JETBRAINS_ASK_IDE_TO_START_CONTAINERS_ENV_VAR = "JETBRAINS_ASK_IDE_TO_START_CONTAINERS";
    private static final String YES = "Yes";

    public CreateContainerUpCmdExec(@NotNull RemoteDockerRuntime dockerRuntime) {
        if (dockerRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerRuntime", "com/intellij/docker/compose/commands/CreateContainerUpCmdExec", "<init>"));
        }
        super(dockerRuntime);
    }

    @NotNull
    public RemoteDockerApplicationRuntime exec(@NotNull CreateContainerUpCmd cmd) throws IOException, ServerRuntimeException {
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/docker/compose/commands/CreateContainerUpCmdExec", "exec"));
        }
        String mainConfigurationFilePath = (String)ContainerUtil.getFirstItem(cmd.getConfigurationFiles());
        if (mainConfigurationFilePath == null) {
            throw new IllegalArgumentException("At least one Docker Compose configuration file must be specified");
        }
        String configurationFolderPath = PathUtil.getParentPath((String)mainConfigurationFilePath);
        if (StringUtil.isEmpty((String)configurationFolderPath)) {
            throw new IllegalArgumentException("Docker Compose main configuration file " + configurationFolderPath);
        }
        PathsBuilder pathsBuilder = PathsBuilder.builder();
        this.bindUnixDockerSock(pathsBuilder);
        DockerComposeConfigurationVolumesCollector collector = new DockerComposeConfigurationVolumesCollector(pathsBuilder);
        collector.collect(cmd.getConfigurationFiles());
        VolumesBuilder volumesBuilder = VolumesBuilder.builder();
        for (String string : pathsBuilder.build()) {
            volumesBuilder.addBoundVolume(string);
        }
        ImmutableList.Builder cmdBuilder = ImmutableList.builder();
        for (String configurationFile : cmd.getConfigurationFiles()) {
            cmdBuilder.add((Object)"-f").add((Object)configurationFile);
        }
        cmdBuilder.add((Object[])new String[]{DOCKER_COMPOSE_UP_COMMAND, "-d"});
        EnvsBuilder envsBuilder = EnvsBuilder.builder();
        if (cmd.getEnvs() != null) {
            envsBuilder.addEnvs((Map<String, String>)cmd.getEnvs());
        }
        envsBuilder.addEnv(JETBRAINS_ASK_IDE_TO_START_CONTAINERS_ENV_VAR, YES);
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = this.doExec(configurationFolderPath, (ImmutableList.Builder<String>)cmdBuilder, volumesBuilder, envsBuilder);
        if (remoteDockerApplicationRuntime == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/commands/CreateContainerUpCmdExec", "exec"));
        }
        return remoteDockerApplicationRuntime;
    }
}

