/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.commands;

import com.intellij.util.PathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jetbrains.annotations.NotNull;

public class ResourceUtil {
    private static final String JAR_FILE_SEPARATOR = "/";

    private ResourceUtil() {
    }

    public static void traverseResources(@NotNull Class<?> context, @NotNull String basepath, @NotNull Callback callback) throws IOException {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/docker/compose/commands/ResourceUtil", "traverseResources"));
        }
        if (basepath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basepath", "com/intellij/docker/compose/commands/ResourceUtil", "traverseResources"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/docker/compose/commands/ResourceUtil", "traverseResources"));
        }
        File jarFile = new File(PathUtil.getJarPathForClass(context));
        if (jarFile.isFile()) {
            try (JarFile jar = new JarFile(jarFile);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String resourcePathname;
                    JarEntry jarEntry = entries.nextElement();
                    String pathname = jarEntry.getName();
                    if (!pathname.startsWith(basepath + JAR_FILE_SEPARATOR) || (resourcePathname = pathname.substring((basepath + JAR_FILE_SEPARATOR).length())).isEmpty()) continue;
                    if (!jarEntry.isDirectory()) {
                        InputStream inputStream = jar.getInputStream(jarEntry);
                        Throwable throwable = null;
                        try {
                            callback.handleFile(JAR_FILE_SEPARATOR + resourcePathname, inputStream, jarEntry.getSize());
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (inputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            inputStream.close();
                            continue;
                        }
                    }
                    callback.handleDirectory(JAR_FILE_SEPARATOR + resourcePathname);
                }
            }
        }
        URL url = context.getResource(JAR_FILE_SEPARATOR + basepath);
        if (url != null) {
            try {
                ResourceUtil.traverseFilesRecursive(callback, new File(url.toURI()), "");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private static void traverseFilesRecursive(@NotNull Callback callback, @NotNull File file, @NotNull String pathname) throws IOException {
        block18: {
            block17: {
                File[] children;
                if (callback == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/docker/compose/commands/ResourceUtil", "traverseFilesRecursive"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/docker/compose/commands/ResourceUtil", "traverseFilesRecursive"));
                }
                if (pathname == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathname", "com/intellij/docker/compose/commands/ResourceUtil", "traverseFilesRecursive"));
                }
                if (!file.isDirectory()) break block17;
                if (!pathname.isEmpty()) {
                    callback.handleDirectory(pathname);
                }
                if ((children = file.listFiles()) == null) break block18;
                for (File child : children) {
                    ResourceUtil.traverseFilesRecursive(callback, child, pathname + JAR_FILE_SEPARATOR + child.getName());
                }
                break block18;
            }
            try (FileInputStream inputStream = new FileInputStream(file);){
                callback.handleFile(pathname, inputStream, file.length());
            }
        }
    }

    public static interface Callback {
        public void handleDirectory(@NotNull String var1) throws IOException;

        public void handleFile(@NotNull String var1, @NotNull InputStream var2, long var3) throws IOException;
    }
}

