/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.common;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DockerComposeEnvironment {
    private Map<String, String> myEnvs;

    public DockerComposeEnvironment() {
        this(new LinkedHashMap<String, String>());
    }

    public DockerComposeEnvironment(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/docker/compose/configuration/beans/common/DockerComposeEnvironment", "<init>"));
        }
        this.myEnvs = envs;
    }

    @JsonValue
    public Map<String, String> getEnvs() {
        return this.myEnvs;
    }

    public String toString() {
        return "DockerComposeEnvironment{myEnvs=" + this.myEnvs + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerComposeEnvironment that = (DockerComposeEnvironment)o;
        return !(this.myEnvs != null ? !this.myEnvs.equals(that.myEnvs) : that.myEnvs != null);
    }

    public int hashCode() {
        return this.myEnvs != null ? this.myEnvs.hashCode() : 0;
    }

    public static DockerComposeEnvironment fromMap(@NotNull Map<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/docker/compose/configuration/beans/common/DockerComposeEnvironment", "fromMap"));
        }
        LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            envs.put(entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null);
        }
        return new DockerComposeEnvironment(envs);
    }

    public static DockerComposeEnvironment fromList(@NotNull List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/docker/compose/configuration/beans/common/DockerComposeEnvironment", "fromList"));
        }
        LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
        for (String env : list) {
            int i = env.indexOf("=");
            if (i > -1) {
                envs.put(env.substring(0, i), env.substring(i + 1));
                continue;
            }
            envs.put(env, null);
        }
        return new DockerComposeEnvironment(envs);
    }
}

