/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.common;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RestartPolicy {
    @NotNull
    public abstract String stringValue();

    public String toString() {
        return this.stringValue();
    }

    @NotNull
    public static NamedRestartPolicy noRestart() {
        NamedRestartPolicy namedRestartPolicy = NamedRestartPolicy.NO_RESTART;
        if (namedRestartPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/RestartPolicy", "noRestart"));
        }
        return namedRestartPolicy;
    }

    @NotNull
    public static NamedRestartPolicy alwaysRestart() {
        NamedRestartPolicy namedRestartPolicy = NamedRestartPolicy.ALWAYS_RESTART;
        if (namedRestartPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/RestartPolicy", "alwaysRestart"));
        }
        return namedRestartPolicy;
    }

    @NotNull
    public static OnFailureRestartPolicy onFailureRestart(int count) {
        OnFailureRestartPolicy onFailureRestartPolicy = new OnFailureRestartPolicy(count);
        if (onFailureRestartPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/RestartPolicy", "onFailureRestart"));
        }
        return onFailureRestartPolicy;
    }

    @NotNull
    public static OnFailureRestartPolicy onFailureRestart() {
        OnFailureRestartPolicy onFailureRestartPolicy = new OnFailureRestartPolicy(null);
        if (onFailureRestartPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/RestartPolicy", "onFailureRestart"));
        }
        return onFailureRestartPolicy;
    }

    public static class OnFailureRestartPolicy
    extends RestartPolicy {
        @Nullable
        private final Integer myRestartCount;

        private OnFailureRestartPolicy(@Nullable Integer count) {
            this.myRestartCount = count;
        }

        @Override
        @NotNull
        public String stringValue() {
            String string = this.myRestartCount != null ? "on-failure:" + this.myRestartCount : "on-failure";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/RestartPolicy$OnFailureRestartPolicy", "stringValue"));
            }
            return string;
        }
    }

    public static class NamedRestartPolicy
    extends RestartPolicy {
        private static final NamedRestartPolicy NO_RESTART = new NamedRestartPolicy("no");
        private static final NamedRestartPolicy ALWAYS_RESTART = new NamedRestartPolicy("always");
        @NotNull
        private final String myName;

        private NamedRestartPolicy(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/docker/compose/configuration/beans/common/RestartPolicy$NamedRestartPolicy", "<init>"));
            }
            this.myName = name;
        }

        @Override
        @NotNull
        public String stringValue() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/configuration/beans/common/RestartPolicy$NamedRestartPolicy", "stringValue"));
            }
            return string;
        }
    }
}

