/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.configuration.beans.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intellij.docker.compose.configuration.beans.common.AccessMode;
import org.jetbrains.annotations.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DockerComposeVolumesFromV1 {
    private String myName;
    private AccessMode myAccessMode;

    public DockerComposeVolumesFromV1(String name, AccessMode accessMode) {
        this.myName = name;
        this.myAccessMode = accessMode;
    }

    @JsonCreator
    public static DockerComposeVolumesFromV1 parseV1(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/docker/compose/configuration/beans/v1/DockerComposeVolumesFromV1", "parseV1"));
        }
        String name = null;
        AccessMode accessMode = null;
        boolean filled = false;
        int i = value.lastIndexOf(":");
        if (i > -1) {
            for (AccessMode current : AccessMode.values()) {
                if (!current.getCode().equals(value.substring(i + 1))) continue;
                accessMode = current;
                name = value.substring(0, i);
                filled = true;
            }
        }
        if (!filled) {
            name = value;
        }
        return new DockerComposeVolumesFromV1(name, accessMode);
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public AccessMode getAccessMode() {
        return this.myAccessMode;
    }

    public void setAccessMode(AccessMode accessMode) {
        this.myAccessMode = accessMode;
    }

    @JsonValue
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.myName);
        if (this.myAccessMode != null) {
            sb.append(":").append(this.myAccessMode.getCode());
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerComposeVolumesFromV1 v1 = (DockerComposeVolumesFromV1)o;
        if (this.myName != null ? !this.myName.equals(v1.myName) : v1.myName != null) {
            return false;
        }
        return this.myAccessMode == v1.myAccessMode;
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myAccessMode != null ? this.myAccessMode.hashCode() : 0);
        return result;
    }
}

