/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.google.common.collect.ImmutableMap;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumesFrom;
import com.intellij.docker.compose.configuration.beans.common.DockerComposePort;
import com.intellij.docker.compose.configuration.beans.common.RestartPolicy;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractServiceCmd<T extends AbstractServiceCmd> {
    private String myServiceName;
    private DockerVolumesFrom[] myVolumesFrom;
    private String[] myCommand;
    private String myWorkingDir;
    private Map<String, String> myEnvironment;
    private List<String> myConfigurationPaths;
    private DockerVolumeBinding[] myVolumesBinding;
    private List<DockerComposePort> myPorts;
    private String myUser;
    private RestartPolicy myRestartPolicy;
    private ImmutableMap<String, String> myEnvs;

    @Nullable
    public String getServiceName() {
        return this.myServiceName;
    }

    @NotNull
    public T withServiceName(@Nullable String serviceName) {
        this.myServiceName = serviceName;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withServiceName"));
        }
        return t;
    }

    @Nullable
    public DockerVolumesFrom[] getVolumesFrom() {
        return this.myVolumesFrom;
    }

    @NotNull
    public T withVolumesFrom(@Nullable DockerVolumesFrom[] volumesFrom) {
        this.myVolumesFrom = volumesFrom;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withVolumesFrom"));
        }
        return t;
    }

    @Nullable
    public String[] getCommand() {
        return this.myCommand;
    }

    @NotNull
    public T withCommand(String ... command) {
        this.myCommand = command;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withCommand"));
        }
        return t;
    }

    @Nullable
    public String getWorkingDir() {
        return this.myWorkingDir;
    }

    @NotNull
    public T withWorkingDir(@Nullable String workingDir) {
        this.myWorkingDir = workingDir;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withWorkingDir"));
        }
        return t;
    }

    @Nullable
    public Map<String, String> getEnvironment() {
        return this.myEnvironment;
    }

    @NotNull
    public T withEnvironment(@Nullable Map<String, String> environment) {
        this.myEnvironment = environment;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withEnvironment"));
        }
        return t;
    }

    @Nullable
    public List<String> getConfigurationPaths() {
        return this.myConfigurationPaths;
    }

    @NotNull
    public T withConfigurationPath(@Nullable List<String> configurationPath) {
        this.myConfigurationPaths = configurationPath;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withConfigurationPath"));
        }
        return t;
    }

    @Nullable
    public ImmutableMap<String, String> getEnvs() {
        return this.myEnvs;
    }

    @NotNull
    public T withEnvs(@Nullable Map<String, String> envs) {
        this.myEnvs = envs != null ? ImmutableMap.copyOf(envs) : null;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withEnvs"));
        }
        return t;
    }

    public DockerVolumeBinding[] getVolumesBinding() {
        return this.myVolumesBinding;
    }

    @NotNull
    public T withVolumes(@Nullable DockerVolumeBinding[] volumesBinding) {
        this.myVolumesBinding = volumesBinding;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withVolumes"));
        }
        return t;
    }

    @Nullable
    public String getUser() {
        return this.myUser;
    }

    @NotNull
    public T withUser(@Nullable String user) {
        this.myUser = user;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withUser"));
        }
        return t;
    }

    @Nullable
    public RestartPolicy getRestartPolicy() {
        return this.myRestartPolicy;
    }

    @NotNull
    public T withRestartPolicy(@Nullable RestartPolicy restartPolicy) {
        this.myRestartPolicy = restartPolicy;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withRestartPolicy"));
        }
        return t;
    }

    @Nullable
    public List<DockerComposePort> getPorts() {
        return this.myPorts;
    }

    @NotNull
    public T withPorts(@Nullable List<DockerComposePort> ports) {
        this.myPorts = ports;
        T t = this.getThis();
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/AbstractServiceCmd", "withPorts"));
        }
        return t;
    }

    @NotNull
    protected abstract T getThis();
}

