/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.compose.DockerComposeClient;
import com.intellij.docker.compose.DockerComposeProjectService;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationSerializer;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.compose.service.commands.ComposeServiceRunCmd;
import com.intellij.docker.compose.service.commands.ServiceCmdExecUtils;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ComposeServiceRunCmdExec {
    private static final String DOCKER_COMPOSE_RUN_CMD_TITLE = "docker-compose run";
    @NotNull
    private final DockerComposeClient myDockerComposeClient;

    public ComposeServiceRunCmdExec(@NotNull DockerComposeClient client) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "com/intellij/docker/compose/service/commands/ComposeServiceRunCmdExec", "<init>"));
        }
        this.myDockerComposeClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public RemoteDockerApplicationRuntime exec(@NotNull ComposeServiceRunCmd cmd) throws IOException, InterruptedException, ServerRuntimeException {
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/intellij/docker/compose/service/commands/ComposeServiceRunCmdExec", "exec"));
        }
        if (ContainerUtil.isEmpty(cmd.getConfigurationPaths())) {
            throw new IllegalArgumentException("Compose configuration path must be defined");
        }
        if (StringUtil.isEmpty((String)cmd.getServiceName())) {
            throw new IllegalArgumentException("Compose service name must be defined");
        }
        List<Path> paths = DockerComposeConfigurationUtil.findConfigurationFiles(cmd.getConfigurationPaths());
        Path mainConfigurationPath = paths.iterator().next();
        Set<String> namedVolumes = ServiceCmdExecUtils.collectNamedVolumes(cmd.getVolumesBinding());
        DockerComposeConfigurationBuilder<?, ?, ?> configurationBuilder = ServiceCmdExecUtils.createConfigurationBuilder(mainConfigurationPath, namedVolumes);
        configurationBuilder.addService(cmd.getServiceName()).withEntrypointLine("").withCommand(cmd.getCommand()).withWorkingDir(cmd.getWorkingDir()).withEnvironment(cmd.getEnvironment()).withVolumesFrom(cmd.getVolumesFrom()).withBindVolumes(cmd.getVolumesBinding()).withPorts(cmd.getPorts()).withUser(cmd.getUser()).withRestartPolicy(cmd.getRestartPolicy());
        Object override = configurationBuilder.build();
        File tempFile = ServiceCmdExecUtils.createTempDockerComposeOverrideYml();
        try (FileWriter output = new FileWriter(tempFile);){
            DockerComposeConfigurationSerializer.newInstance().serialize(output, (DockerComposeConfiguration)override);
        }
        RemoteDockerApplicationRuntime serviceApplicationRuntime = this.myDockerComposeClient.createRunServiceContainer().withServiceName(cmd.getServiceName()).withServiceCmd(cmd.getCommand()).withConfigurationFiles((List<Path>)ImmutableList.builder().addAll(paths).add((Object)tempFile.toPath()).build()).withEnvs(cmd.getEnvs()).exec();
        ProcessOutput dockerComposeProcessOutput = DockerComposeProjectService.getInstance().runDockerComposeContainer(mainConfigurationPath, serviceApplicationRuntime, DOCKER_COMPOSE_RUN_CMD_TITLE);
        if (dockerComposeProcessOutput.getExitCode() != 0) {
            throw new IllegalStateException("Failed to run single Docker Compose service " + cmd.getServiceName() + ": " + dockerComposeProcessOutput.getStderr());
        }
        String serviceContainerName = ServiceCmdExecUtils.parseServiceContainerName(dockerComposeProcessOutput.getStdout());
        if (StringUtil.isEmpty((String)serviceContainerName)) {
            throw new IllegalStateException("Returned an empty container name for single Docker Compose service " + cmd.getServiceName());
        }
        RemoteDockerRuntime dockerRuntime = this.myDockerComposeClient.getDockerRuntime();
        RemoteDockerApplicationRuntime applicationRuntime = dockerRuntime.findContainerByName(serviceContainerName);
        if (applicationRuntime == null) {
            throw new ServerRuntimeException("Cannot find any application for: " + serviceContainerName);
        }
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = applicationRuntime;
        if (remoteDockerApplicationRuntime == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ComposeServiceRunCmdExec", "exec"));
        }
        return remoteDockerApplicationRuntime;
    }
}

