/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose.service.commands;

import com.google.common.collect.ImmutableSet;
import com.intellij.docker.agent.settings.DockerAgentContainerInspection;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerLabel;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.compose.configuration.beans.DockerComposeConfigurationParser;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfiguration;
import com.intellij.docker.compose.configuration.beans.common.DockerComposeConfigurationBuilder;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1;
import com.intellij.docker.compose.configuration.beans.v1.DockerComposeConfigurationV1Builder;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2;
import com.intellij.docker.compose.configuration.beans.v2.DockerComposeConfigurationV2Builder;
import com.intellij.docker.compose.configuration.util.DockerComposeConfigurationUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServiceCmdExecUtils {
    private static final Logger LOG = Logger.getInstance(ServiceCmdExecUtils.class);
    public static final String EMPTY_COMMAND = "";
    private static final String DOCKER_COMPOSE_OVERRIDE = "docker-compose.override.";
    private static final String YML_EXTENSION = ".yml";
    private static final Pattern DOCKER_START_PATTERN = Pattern.compile("\\$docker start (?<name>.+)");
    private static final String DOCKER_COMPOSE_SERVICE_NAME_LABEL = "com.docker.compose.service";
    private static final Pattern SERVER_RUNTIME_EXCEPTION_MESSAGE_PATTERN = Pattern.compile("(?s).*\\{\"message\":\"(?<body>.*)\"\\}.*");
    private static final ImmutableSet<String> DOCKER_ENV_VARS = ImmutableSet.of((Object)"DOCKER_HOST", (Object)"DOCKER_TLS_VERIFY", (Object)"DOCKER_CERT_PATH");

    private ServiceCmdExecUtils() {
    }

    @NotNull
    public static DockerComposeConfigurationBuilder<?, ?, ?> createConfigurationBuilder(@NotNull Path mainConfigurationPath, final @NotNull Collection<String> volumes) throws IOException {
        if (mainConfigurationPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainConfigurationPath", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "createConfigurationBuilder"));
        }
        if (volumes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "volumes", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "createConfigurationBuilder"));
        }
        DockerComposeConfigurationBuilder dockerComposeConfigurationBuilder = (DockerComposeConfigurationBuilder)DockerComposeConfigurationParser.newInstance().parseBean(mainConfigurationPath.toString()).accept(new DockerComposeConfiguration.Visitor<DockerComposeConfigurationBuilder<?, ?, ?>>(){

            @Override
            public DockerComposeConfigurationV1Builder visit(@NotNull DockerComposeConfigurationV1 configuration) {
                if (configuration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$1", "visit"));
                }
                return new DockerComposeConfigurationV1Builder();
            }

            @Override
            public DockerComposeConfigurationV2Builder visit(@NotNull DockerComposeConfigurationV2 configuration) {
                if (configuration == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$1", "visit"));
                }
                DockerComposeConfigurationV2Builder builder = new DockerComposeConfigurationV2Builder().withVersion(configuration.getVersion());
                for (String volume : volumes) {
                    builder.addVolume(volume);
                }
                return builder;
            }
        });
        if (dockerComposeConfigurationBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "createConfigurationBuilder"));
        }
        return dockerComposeConfigurationBuilder;
    }

    @NotNull
    public static Set<String> collectNamedVolumes(@Nullable DockerVolumeBinding[] bindings) {
        if (bindings == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "collectNamedVolumes"));
            }
            return set;
        }
        LinkedHashSet<String> volumes = new LinkedHashSet<String>();
        for (DockerVolumeBinding bind : bindings) {
            String bindPath = bind.getHostPath();
            if (bindPath == null || !DockerComposeConfigurationUtil.isNamedVolumeBind(bindPath)) continue;
            volumes.add(bindPath);
        }
        LinkedHashSet<String> linkedHashSet = volumes;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "collectNamedVolumes"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static File createTempDockerComposeOverrideYml() throws IOException {
        File tempDir = new File(PathManager.getTempPath());
        File file = FileUtil.createTempFile((File)tempDir, (String)DOCKER_COMPOSE_OVERRIDE, (String)YML_EXTENSION, (boolean)true);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "createTempDockerComposeOverrideYml"));
        }
        return file;
    }

    @NotNull
    public static String parseServiceContainerName(@NotNull String stdout) {
        if (stdout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stdout", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "parseServiceContainerName"));
        }
        String trimmedStdout = StringUtil.trim((String)stdout);
        int last = Math.max(trimmedStdout.lastIndexOf("\n"), trimmedStdout.lastIndexOf("\r"));
        String string = trimmedStdout.substring(last + 1).trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "parseServiceContainerName"));
        }
        return string;
    }

    @Nullable
    public static String parseDockerStartCmd(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "parseDockerStartCmd"));
        }
        Matcher matcher = DOCKER_START_PATTERN.matcher(s);
        if (matcher.matches()) {
            return matcher.group("name").trim();
        }
        return null;
    }

    @NotNull
    static Optional<Matcher> matches(@NotNull String s, @NotNull Iterable<Pattern> patterns) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "matches"));
        }
        if (patterns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patterns", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "matches"));
        }
        for (Pattern pattern : patterns) {
            Matcher matcher = pattern.matcher(s);
            if (!matcher.matches()) continue;
            Optional<Matcher> optional = Optional.of(matcher);
            if (optional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "matches"));
            }
            return optional;
        }
        Optional<Matcher> optional = Optional.empty();
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "matches"));
        }
        return optional;
    }

    @NotNull
    static Optional<String> tryFindServiceContainerName(@NotNull ServiceContainers serviceContainers, @Nullable String serviceName) {
        if (serviceContainers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceContainers", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "tryFindServiceContainerName"));
        }
        for (String containerName : serviceContainers.getUpToDateServices()) {
            if (!ServiceCmdExecUtils.isServiceContainerName(containerName, serviceName)) continue;
            Optional<String> optional = Optional.of(containerName);
            if (optional == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "tryFindServiceContainerName"));
            }
            return optional;
        }
        Optional<String> optional = Optional.empty();
        if (optional == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "tryFindServiceContainerName"));
        }
        return optional;
    }

    static boolean isServiceContainerName(@NotNull String containerName, @Nullable String serviceName) {
        if (containerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containerName", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "isServiceContainerName"));
        }
        return containerName.contains("_" + serviceName + "_");
    }

    public static boolean isServiceContainer(@NotNull RemoteDockerApplicationRuntime container, @Nullable String serviceName) throws ServerRuntimeException {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "isServiceContainer"));
        }
        if (serviceName == null) {
            return false;
        }
        DockerAgentContainerInspection inspect = container.inspect();
        if (inspect.getLabels() != null) {
            for (DockerLabel label : inspect.getLabels()) {
                if (!DOCKER_COMPOSE_SERVICE_NAME_LABEL.equals(label.getKey()) || !serviceName.equals(label.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static ServiceContainers listServiceContainerNames(@NotNull ProcessOutput dockerComposeProcessOutput) {
        if (dockerComposeProcessOutput == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerComposeProcessOutput", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "listServiceContainerNames"));
        }
        LinkedHashSet<String> allServices = new LinkedHashSet<String>();
        List<Pattern> ignorePatterns = Arrays.asList(Pattern.compile("Creating volume \".*\" with .* driver"), Pattern.compile("Creating network \".*\" with .* driver"));
        List<Pattern> upToDatePatterns = Collections.singletonList(Pattern.compile("(?<container>.*) is up-to-date"));
        List<Pattern> patterns = Collections.singletonList(Pattern.compile("(?:Starting|Creating|Recreating) (?<container>.+)"));
        LinkedHashSet<String> upToDateServices = new LinkedHashSet<String>();
        boolean allErrLinesMatched = true;
        for (String line : dockerComposeProcessOutput.getStderrLines()) {
            String serviceContainerName;
            Optional<Matcher> matcher;
            if (!StringUtil.isNotEmpty((String)line)) continue;
            Optional<Matcher> ignoreMatcher = ServiceCmdExecUtils.matches(line, ignorePatterns);
            boolean matched = ignoreMatcher.isPresent();
            if (!matched && (matcher = ServiceCmdExecUtils.matches(line, patterns)).isPresent()) {
                serviceContainerName = matcher.get().group("container").trim();
                allServices.add(serviceContainerName);
                matched = true;
            }
            if (!matched && (matcher = ServiceCmdExecUtils.matches(line, upToDatePatterns)).isPresent()) {
                serviceContainerName = matcher.get().group("container").trim();
                allServices.add(serviceContainerName);
                upToDateServices.add(serviceContainerName);
                matched = true;
            }
            if (matched) continue;
            allErrLinesMatched = false;
        }
        if (!allErrLinesMatched && LOG.isDebugEnabled()) {
            LOG.debug("Failed to locate container names in every line of Docker Compose output.\nstderr:\n", new Object[]{dockerComposeProcessOutput.getStderr(), "\nstdout:\n" + dockerComposeProcessOutput.getStdout()});
        }
        ServiceContainers serviceContainers = new ServiceContainers(allServices, upToDateServices);
        if (serviceContainers == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "listServiceContainerNames"));
        }
        return serviceContainers;
    }

    @NotNull
    public static String extractErrorMessage(@NotNull ServerRuntimeException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "extractErrorMessage"));
        }
        String message = e.getMessage();
        if (message == null) {
            String string = e.toString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "extractErrorMessage"));
            }
            return string;
        }
        Matcher matcher = SERVER_RUNTIME_EXCEPTION_MESSAGE_PATTERN.matcher(message);
        String string = matcher.matches() ? matcher.group("body") : message;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "extractErrorMessage"));
        }
        return string;
    }

    @NotNull
    public static DockerEnvVar[] filterDockerEnvs(@NotNull DockerEnvVar[] vars) {
        if (vars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vars", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "filterDockerEnvs"));
        }
        DockerEnvVar[] dockerEnvVarArray = (DockerEnvVar[])Arrays.stream(vars).filter(var -> !DOCKER_ENV_VARS.contains((Object)var.getName())).toArray(DockerEnvVar[]::new);
        if (dockerEnvVarArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils", "filterDockerEnvs"));
        }
        return dockerEnvVarArray;
    }

    public static class ServiceContainers {
        @NotNull
        private final Set<String> myAllServices;
        @NotNull
        private final Set<String> myUpToDateServices;

        public ServiceContainers(@NotNull Set<String> allServices, @NotNull Set<String> upToDateServices) {
            if (allServices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allServices", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$ServiceContainers", "<init>"));
            }
            if (upToDateServices == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upToDateServices", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$ServiceContainers", "<init>"));
            }
            this.myAllServices = allServices;
            this.myUpToDateServices = upToDateServices;
        }

        @NotNull
        public Set<String> getAllServices() {
            Set<String> set = this.myAllServices;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$ServiceContainers", "getAllServices"));
            }
            return set;
        }

        @NotNull
        public Set<String> getUpToDateServices() {
            Set<String> set = this.myUpToDateServices;
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/compose/service/commands/ServiceCmdExecUtils$ServiceContainers", "getUpToDateServices"));
            }
            return set;
        }
    }
}

