/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.remote.DockerComposeCredentialsHolder;
import com.intellij.remote.ext.RemoteCredentialsHandlerBase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerComposeCredentialsHandler
extends RemoteCredentialsHandlerBase<DockerComposeCredentialsHolder> {
    public DockerComposeCredentialsHandler(DockerComposeCredentialsHolder credentials) {
        super((Object)credentials);
    }

    public String getId() {
        DockerComposeCredentialsHolder cred = (DockerComposeCredentialsHolder)this.getCredentials();
        String name = cred.getComposeFilePaths() + ":" + cred.getComposeServiceName();
        return "docker-compose://" + name + "/";
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/docker/remote/DockerComposeCredentialsHandler", "save"));
        }
        ((DockerComposeCredentialsHolder)this.getCredentials()).save(rootElement);
    }

    public String getPresentableDetails(String interpreterPath) {
        DockerComposeCredentialsHolder credentials = (DockerComposeCredentialsHolder)this.getCredentials();
        return String.format("Docker Compose (%s at %s)", credentials.getComposeServiceName(), credentials.getComposeFilePaths());
    }

    public void load(@Nullable Element rootElement) {
        if (rootElement != null) {
            ((DockerComposeCredentialsHolder)this.getCredentials()).load(rootElement);
        }
    }
}

