/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.ext.RemoteCredentialsHandlerBase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerCredentialsHandler
extends RemoteCredentialsHandlerBase<DockerCredentialsHolder> {
    public DockerCredentialsHandler(DockerCredentialsHolder credentials) {
        super((Object)credentials);
    }

    public String getId() {
        DockerCredentialsHolder cred = (DockerCredentialsHolder)this.getCredentials();
        String name = StringUtil.isNotEmpty((String)cred.getContainerName()) ? cred.getContainerName() : cred.getImageName();
        return "docker://" + name + "/";
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/docker/remote/DockerCredentialsHandler", "save"));
        }
        ((DockerCredentialsHolder)this.getCredentials()).save(rootElement);
    }

    public String getPresentableDetails(String interpreterPath) {
        DockerCredentialsHolder credentials = (DockerCredentialsHolder)this.getCredentials();
        String containerName = StringUtil.isNotEmpty((String)credentials.getContainerName()) ? credentials.getContainerName() + " " : "";
        return "Docker " + containerName + "(" + credentials.getImageName() + ")";
    }

    public void load(@Nullable Element rootElement) {
        if (rootElement != null) {
            ((DockerCredentialsHolder)this.getCredentials()).load(rootElement);
        }
    }
}

