/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.settings.DockerExtraHostsEditor;
import com.intellij.docker.settings.DockerEnvVarsEditor;
import com.intellij.docker.settings.DockerLinksEditor;
import com.intellij.docker.settings.DockerPortBindingsEditor;
import com.intellij.docker.settings.DockerVolumeBindingsEditor;
import com.intellij.docker.settings.TableWithCardEditor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.UserActivityProviderComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EventDispatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerInterpreterContainerSettingsEditor
extends SettingsEditor<DockerContainerSettings> {
    private static final int COLLAPSED_SIZE_POLICY = 3;
    private static final int EXPANDED_SIZE_POLICY = 7;
    @NotNull
    private final Project myProject;
    private JPanel myMainPanel;
    private JPanel myPortBindingsPanelPlaceHolder;
    private JCheckBox myPublishAllPortsCheckBox;
    private JPanel myLinksPanelPlaceHolder;
    private JPanel myVolumeBindingsPanelPlaceHolder;
    private JPanel myEnvVarsPanelPlaceHolder;
    private JPanel myNotificationPanel;
    private JTextField myNetworkModeField;
    private JCheckBox myDisableNetworkingCheckBox;
    private JPanel myExtraHostsPlaceHolder;
    private JPanel myVerticalSpacerPanel;
    private DockerPortBindingsEditor myPortBindingsEditor;
    private DockerLinksEditor myLinksEditor;
    private DockerExtraHostsEditor myExtraHostsEditor;
    private DockerVolumeBindingsEditor myVolumeBindingsEditor;
    private DockerEnvVarsEditor myEnvVarsEditor;
    private HideableDecorator myPortBindingsDecorator;
    private HideableDecorator myLinksDecorator;
    private HideableDecorator myExtraHostsDecorator;
    private HideableDecorator myVolumeBindingsDecorator;
    private HideableDecorator myEnvVarsDecorator;
    private int mySettingsVersion;

    public DockerInterpreterContainerSettingsEditor(@NotNull Project project, @Nullable RemoteServer server) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor", "<init>"));
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myPublishAllPortsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerInterpreterContainerSettingsEditor.this.updatePortBindingsAvailability();
            }
        });
        this.myDisableNetworkingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerInterpreterContainerSettingsEditor.this.updateNetworkModeAvailability();
            }
        });
        this.myPortBindingsEditor = new DockerPortBindingsEditor();
        this.myPortBindingsDecorator = this.decorateEditor(this.myPortBindingsPanelPlaceHolder, "Port bindings", (TableWithCardEditor<?, ?>)this.myPortBindingsEditor);
        this.myLinksEditor = new DockerLinksEditor(server);
        this.myLinksDecorator = this.decorateEditor(this.myLinksPanelPlaceHolder, "Links", (TableWithCardEditor<?, ?>)this.myLinksEditor);
        this.myExtraHostsEditor = new DockerExtraHostsEditor();
        this.myExtraHostsDecorator = this.decorateEditor(this.myExtraHostsPlaceHolder, "Extra hosts", this.myExtraHostsEditor);
        this.myVolumeBindingsEditor = new DockerVolumeBindingsEditor(server);
        this.myVolumeBindingsDecorator = this.decorateEditor(this.myVolumeBindingsPanelPlaceHolder, "Volume bindings", (TableWithCardEditor<?, ?>)this.myVolumeBindingsEditor);
        this.myEnvVarsEditor = new DockerEnvVarsEditor();
        this.myEnvVarsDecorator = this.decorateEditor(this.myEnvVarsPanelPlaceHolder, "Environment variables", (TableWithCardEditor<?, ?>)this.myEnvVarsEditor);
    }

    private HideableDecorator decorateEditor(@NotNull JPanel panel, @NotNull String title, @NotNull TableWithCardEditor<?, ?> editor) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor", "decorateEditor"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor", "decorateEditor"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor", "decorateEditor"));
        }
        editor.getPanel().setPreferredSize(new Dimension(500, 100));
        return new HideableDecoratorEx(panel, title, editor);
    }

    private void updatePortBindingsAvailability() {
        boolean enablePortBindings = !this.myPublishAllPortsCheckBox.isSelected();
        this.myPortBindingsEditor.setEnabled(enablePortBindings);
    }

    private void updateNetworkModeAvailability() {
        this.myNetworkModeField.setEnabled(!this.myDisableNetworkingCheckBox.isSelected());
    }

    protected void resetEditorFrom(@NotNull DockerContainerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor", "resetEditorFrom"));
        }
        if (settings == null) {
            settings = DockerContainerSettings.defaultSettings(this.myProject);
        }
        this.myPortBindingsEditor.setItems(settings.getPortBindings());
        this.myLinksEditor.setItems(settings.getLinks());
        this.myExtraHostsEditor.setItems(settings.getExtraHosts());
        this.myVolumeBindingsEditor.setItems(settings.getVolumeBindings());
        this.myEnvVarsEditor.setItems(settings.getEnvVars());
        this.myPortBindingsDecorator.setOn(!settings.getPortBindings().isEmpty());
        this.myLinksDecorator.setOn(!settings.getPortBindings().isEmpty());
        this.myExtraHostsDecorator.setOn(!settings.getExtraHosts().isEmpty());
        this.myVolumeBindingsDecorator.setOn(!settings.getVolumeBindings().isEmpty());
        this.myEnvVarsDecorator.setOn(!settings.getEnvVars().isEmpty());
        this.myPublishAllPortsCheckBox.setSelected(settings.isPublishAllPorts());
        this.myDisableNetworkingCheckBox.setSelected(settings.isNetworkDisabled());
        this.myNetworkModeField.setText(settings.getNetworkMode());
        this.mySettingsVersion = settings.getVersion();
        this.updatePortBindingsAvailability();
        this.updateNetworkModeAvailability();
    }

    protected void applyEditorTo(@NotNull DockerContainerSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor", "applyEditorTo"));
        }
        settings.setPublishAllPorts(this.myPublishAllPortsCheckBox.isSelected());
        settings.setPortBindings(this.myPortBindingsEditor.getItems());
        settings.setLinks(this.myLinksEditor.getItems());
        settings.setExtraHosts(this.myExtraHostsEditor.getItems());
        settings.setVolumeBindings(this.myVolumeBindingsEditor.getItems());
        settings.setEnvVars(this.myEnvVarsEditor.getItems());
        settings.setNetworkDisabled(this.myDisableNetworkingCheckBox.isSelected());
        settings.setNetworkMode(this.myNetworkModeField.getText());
        settings.setVersion(this.mySettingsVersion);
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor", "createEditor"));
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.myNotificationPanel = new NotificationPanel();
    }

    private boolean areAllEditorsCollapsed() {
        return Iterables.all(this.getAllDecorators(), (Predicate)new Predicate<HideableDecorator>(){

            public boolean apply(HideableDecorator input) {
                return !input.isExpanded();
            }
        });
    }

    @NotNull
    private Iterable<HideableDecorator> getAllDecorators() {
        List<HideableDecorator> list = Arrays.asList(this.myPortBindingsDecorator, this.myLinksDecorator, this.myExtraHostsDecorator, this.myVolumeBindingsDecorator, this.myEnvVarsDecorator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/DockerInterpreterContainerSettingsEditor", "getAllDecorators"));
        }
        return list;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        JTextField jTextField;
        JCheckBox jCheckBox2;
        JPanel jPanel3;
        JPanel jPanel4;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.createUIComponents();
        this.myMainPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLinksPanelPlaceHolder = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel6, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myVolumeBindingsPanelPlaceHolder = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel5, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myEnvVarsPanelPlaceHolder = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel4, new GridConstraints(7, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPortBindingsPanelPlaceHolder = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel3, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myPublishAllPortsCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Publish all ports");
        jPanel7.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel8 = this.myNotificationPanel;
        jPanel7.add((Component)jPanel8, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Network mode:");
        jPanel7.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNetworkModeField = jTextField = new JTextField();
        jPanel7.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDisableNetworkingCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Disable networking");
        jPanel7.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myExtraHostsPlaceHolder = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel2, new GridConstraints(5, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myVerticalSpacerPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel, new GridConstraints(9, 0, 1, 1, 0, 3, 0, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class NotificationPanel
    extends JPanel
    implements UserActivityProviderComponent {
        private final EventDispatcher<ChangeListener> myEventDispatcher = EventDispatcher.create(ChangeListener.class);

        private NotificationPanel() {
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.myEventDispatcher.addListener((EventListener)changeListener, (Disposable)DockerInterpreterContainerSettingsEditor.this);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.myEventDispatcher.removeListener((EventListener)changeListener);
        }

        public void stateChanged() {
            ((ChangeListener)this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
        }
    }

    private class HideableDecoratorEx
    extends HideableDecorator {
        private final JPanel myPanel;

        public HideableDecoratorEx(JPanel panel, String title, TableWithCardEditor editor) {
            super(panel, title, true);
            this.myPanel = panel;
            this.setContentComponent(editor.getPanel());
        }

        protected void on() {
            super.on();
            ((NotificationPanel)DockerInterpreterContainerSettingsEditor.this.myNotificationPanel).stateChanged();
            GridLayoutManager layout = (GridLayoutManager)DockerInterpreterContainerSettingsEditor.this.myMainPanel.getLayout();
            layout.getConstraintsForComponent((Component)this.myPanel).setVSizePolicy(7);
            layout.getConstraintsForComponent((Component)DockerInterpreterContainerSettingsEditor.this.myVerticalSpacerPanel).setVSizePolicy(3);
        }

        protected void off() {
            super.off();
            ((NotificationPanel)DockerInterpreterContainerSettingsEditor.this.myNotificationPanel).stateChanged();
            GridLayoutManager layout = (GridLayoutManager)DockerInterpreterContainerSettingsEditor.this.myMainPanel.getLayout();
            layout.getConstraintsForComponent((Component)this.myPanel).setVSizePolicy(3);
            if (DockerInterpreterContainerSettingsEditor.this.areAllEditorsCollapsed()) {
                layout.getConstraintsForComponent((Component)DockerInterpreterContainerSettingsEditor.this.myVerticalSpacerPanel).setVSizePolicy(7);
            }
        }
    }
}

