/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.common;

import com.intellij.docker.agent.ArrayMapping;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvsBuilder {
    private static final String PATH_ENV = "PATH";
    @NotNull
    private final Map<String, String> myEnvsMap = new LinkedHashMap<String, String>();
    private boolean myPassParentEnvironment;

    private EnvsBuilder() {
    }

    @NotNull
    public static EnvsBuilder builder() {
        EnvsBuilder envsBuilder = new EnvsBuilder();
        if (envsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/EnvsBuilder", "builder"));
        }
        return envsBuilder;
    }

    @NotNull
    public EnvsBuilder addEnvs(@NotNull List<DockerEnvVarImpl> vars) {
        if (vars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vars", "com/intellij/docker/remote/run/common/EnvsBuilder", "addEnvs"));
        }
        for (DockerEnvVarImpl var : vars) {
            this.myEnvsMap.put(var.getName(), var.getValue());
        }
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/EnvsBuilder", "addEnvs"));
        }
        return envsBuilder;
    }

    @NotNull
    public EnvsBuilder addEnvs(@NotNull Map<String, String> env) {
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/docker/remote/run/common/EnvsBuilder", "addEnvs"));
        }
        this.myEnvsMap.putAll(env);
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/EnvsBuilder", "addEnvs"));
        }
        return envsBuilder;
    }

    @NotNull
    public EnvsBuilder addEnv(@NotNull String key, @NotNull String value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/docker/remote/run/common/EnvsBuilder", "addEnv"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/docker/remote/run/common/EnvsBuilder", "addEnv"));
        }
        this.myEnvsMap.put(key, value);
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/EnvsBuilder", "addEnv"));
        }
        return envsBuilder;
    }

    private static void addEnv(@NotNull List<DockerEnvVar> envVars, @Nullable String name, @Nullable String value) {
        if (envVars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envVars", "com/intellij/docker/remote/run/common/EnvsBuilder", "addEnv"));
        }
        if (name != null) {
            DockerEnvVarImpl envVar = new DockerEnvVarImpl();
            envVar.setName(name);
            envVar.setValue(value);
            envVars.add((DockerEnvVar)envVar);
        }
    }

    @NotNull
    public EnvsBuilder withPassParentEnvironment(boolean passParentEnvironment) {
        this.myPassParentEnvironment = passParentEnvironment;
        EnvsBuilder envsBuilder = this;
        if (envsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/EnvsBuilder", "withPassParentEnvironment"));
        }
        return envsBuilder;
    }

    @NotNull
    public String[] build() {
        String[] stringArray = (String[])new ArrayMapping<DockerEnvVar, String>(){

            protected String mapElement(DockerEnvVar source) {
                return source.getName() + "=" + source.getValue();
            }
        }.map((Object[])this.buildEnvs(), String.class);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/EnvsBuilder", "build"));
        }
        return stringArray;
    }

    public DockerEnvVar[] buildEnvs() {
        ArrayList<DockerEnvVar> result = new ArrayList<DockerEnvVar>();
        for (Map.Entry<String, String> entry : this.myEnvsMap.entrySet()) {
            if (this.myPassParentEnvironment && PATH_ENV.equalsIgnoreCase(entry.getKey())) {
                if (entry.getValue() == null) continue;
                EnvsBuilder.addEnv(result, entry.getKey(), entry.getValue() + ":$" + PATH_ENV);
                continue;
            }
            EnvsBuilder.addEnv(result, entry.getKey(), entry.getValue());
        }
        return result.toArray(new DockerEnvVar[result.size()]);
    }
}

