/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.common;

import com.google.common.collect.ImmutableList;
import com.intellij.docker.remote.settings.DockerExtraHost;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtraHostsBuilder {
    private final ImmutableList.Builder<String> myExtraHosts = ImmutableList.builder();

    private ExtraHostsBuilder() {
    }

    @NotNull
    public static ExtraHostsBuilder builder() {
        ExtraHostsBuilder extraHostsBuilder = new ExtraHostsBuilder();
        if (extraHostsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/ExtraHostsBuilder", "builder"));
        }
        return extraHostsBuilder;
    }

    @NotNull
    public ExtraHostsBuilder addExtraHosts(@NotNull List<DockerExtraHost> extraHosts) {
        if (extraHosts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraHosts", "com/intellij/docker/remote/run/common/ExtraHostsBuilder", "addExtraHosts"));
        }
        for (DockerExtraHost host : extraHosts) {
            this.myExtraHosts.add((Object)(host.getHostname() + ":" + host.getIP()));
        }
        ExtraHostsBuilder extraHostsBuilder = this;
        if (extraHostsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/ExtraHostsBuilder", "addExtraHosts"));
        }
        return extraHostsBuilder;
    }

    @NotNull
    public String[] build() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)this.myExtraHosts.build());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/ExtraHostsBuilder", "build"));
        }
        return stringArray;
    }
}

