/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.common;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PathsBuilder {
    @NotNull
    private final Set<String> myCollectedPaths = new LinkedHashSet<String>();

    @NotNull
    public PathsBuilder addPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/docker/remote/run/common/PathsBuilder", "addPath"));
        }
        if (StringUtil.isEmpty((String)(path = path.trim()))) {
            PathsBuilder pathsBuilder = this;
            if (pathsBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PathsBuilder", "addPath"));
            }
            return pathsBuilder;
        }
        if (this.myCollectedPaths.contains(path = FileUtil.normalize((String)path))) {
            PathsBuilder pathsBuilder = this;
            if (pathsBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PathsBuilder", "addPath"));
            }
            return pathsBuilder;
        }
        Iterator<String> iterator = this.myCollectedPaths.iterator();
        while (iterator.hasNext()) {
            String collectedPath = iterator.next();
            if (collectedPath.startsWith(path)) {
                iterator.remove();
                this.myCollectedPaths.add(path);
                PathsBuilder pathsBuilder = this;
                if (pathsBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PathsBuilder", "addPath"));
                }
                return pathsBuilder;
            }
            if (!path.startsWith(collectedPath)) continue;
            PathsBuilder pathsBuilder = this;
            if (pathsBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PathsBuilder", "addPath"));
            }
            return pathsBuilder;
        }
        this.myCollectedPaths.add(path);
        PathsBuilder pathsBuilder = this;
        if (pathsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PathsBuilder", "addPath"));
        }
        return pathsBuilder;
    }

    @NotNull
    public Set<String> build() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.myCollectedPaths);
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PathsBuilder", "build"));
        }
        return linkedHashSet;
    }

    @NotNull
    public static PathsBuilder builder() {
        PathsBuilder pathsBuilder = new PathsBuilder();
        if (pathsBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/common/PathsBuilder", "builder"));
        }
        return pathsBuilder;
    }
}

