/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.google.common.net.HostAndPort;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.DockerMachineExecProcess;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerExecProcess
extends RemoteProcess {
    @NotNull
    private static final Logger LOG = Logger.getInstance(DockerExecProcess.class);
    @NotNull
    private final RemoteDockerApplicationRuntime myApplicationRuntime;
    @NotNull
    private final OutputStream myOutputStream;
    @NotNull
    private final InputStream myInputStream;
    @NotNull
    private final InputStream myErrorStream;
    @NotNull
    private final CountDownLatch myCompleted;
    @NotNull
    private final AtomicInteger myExitCode;
    @NotNull
    private final String myDockerHost;
    private final boolean myRemoveContainer;

    public DockerExecProcess(@NotNull RemoteDockerApplicationRuntime applicationRuntime, @NotNull String dockerHost, boolean removeContainer) {
        if (applicationRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationRuntime", "com/intellij/docker/remote/run/runtime/DockerExecProcess", "<init>"));
        }
        if (dockerHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerHost", "com/intellij/docker/remote/run/runtime/DockerExecProcess", "<init>"));
        }
        this.myCompleted = new CountDownLatch(1);
        this.myExitCode = new AtomicInteger();
        this.myApplicationRuntime = applicationRuntime;
        this.myDockerHost = dockerHost;
        this.myRemoveContainer = removeContainer;
        this.myOutputStream = applicationRuntime.getStdin();
        this.myInputStream = applicationRuntime.getStdout();
        this.myErrorStream = applicationRuntime.getStderr();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myApplicationRuntime.wait4terminal();
            }
            finally {
                this.onTerminalClosed();
            }
        });
    }

    public void onTerminalClosed() {
        try {
            if (this.retrieveContainerExitCode()) {
                this.removeContainerLater();
            }
        }
        finally {
            this.myCompleted.countDown();
        }
    }

    private void removeContainerLater() {
        if (this.myRemoveContainer) {
            ApplicationManager.getApplication().executeOnPooledThread(this.myApplicationRuntime::removeContainer);
        }
    }

    @NotNull
    public OutputStream getOutputStream() {
        OutputStream outputStream = this.myOutputStream;
        if (outputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerExecProcess", "getOutputStream"));
        }
        return outputStream;
    }

    @NotNull
    public InputStream getInputStream() {
        InputStream inputStream = this.myInputStream;
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerExecProcess", "getInputStream"));
        }
        return inputStream;
    }

    @NotNull
    public InputStream getErrorStream() {
        InputStream inputStream = this.myErrorStream;
        if (inputStream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerExecProcess", "getErrorStream"));
        }
        return inputStream;
    }

    public int waitFor() throws InterruptedException {
        this.myCompleted.await();
        return this.myExitCode.get();
    }

    public int exitValue() {
        if (this.myCompleted.getCount() != 0L) {
            throw new IllegalThreadStateException();
        }
        return this.myExitCode.get();
    }

    public void destroy() {
        this.stopContainerLater();
    }

    public boolean killProcessTree() {
        this.stopContainerLater();
        return true;
    }

    public boolean isDisconnected() {
        return this.myCompleted.getCount() == 0L;
    }

    private boolean retrieveContainerExitCode() {
        try {
            int exitCode = (Integer)this.myApplicationRuntime.executeAgentTask(() -> this.myApplicationRuntime.getAgentApplication().waitForExitImmediate(arg_0 -> ((Logger)LOG).info(arg_0)));
            this.myExitCode.set(exitCode);
            if (this.myApplicationRuntime.inspect().isRunning()) {
                LOG.debug("Container " + this.myApplicationRuntime.getContainerId() + " has unexpected \"running\" state");
            }
            return true;
        }
        catch (ServerRuntimeException e) {
            LOG.info(e.getMessage());
            return false;
        }
    }

    private void stopContainerLater() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myApplicationRuntime.executeAgentTask(() -> {
                    this.myApplicationRuntime.getAgentApplication().stopContainerImmediate(arg_0 -> ((Logger)LOG).info(arg_0));
                    return null;
                });
            }
            catch (ServerRuntimeException e) {
                LOG.info(e.getMessage());
            }
        });
    }

    @NotNull
    public RemoteDockerApplicationRuntime getApplicationRuntime() {
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = this.myApplicationRuntime;
        if (remoteDockerApplicationRuntime == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerExecProcess", "getApplicationRuntime"));
        }
        return remoteDockerApplicationRuntime;
    }

    @NotNull
    public String getDockerHost() {
        String string = this.myDockerHost;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerExecProcess", "getDockerHost"));
        }
        return string;
    }

    @Nullable
    public HostAndPort getLocalTunnel(int remotePort) {
        return HostAndPort.fromParts((String)this.myDockerHost, (int)remotePort);
    }

    public static class Factory {
        @NotNull
        public static DockerExecProcess startProcessWithRemove(@NotNull RemoteDockerRuntime dockerRuntime, @NotNull DockerAgentDeploymentConfigImpl config) throws ServerRuntimeException, RemoteSdkException, IOException {
            if (dockerRuntime == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerRuntime", "com/intellij/docker/remote/run/runtime/DockerExecProcess$Factory", "startProcessWithRemove"));
            }
            if (config == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/docker/remote/run/runtime/DockerExecProcess$Factory", "startProcessWithRemove"));
            }
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.createWithPullImage(dockerRuntime, config);
            DockerExecProcess dockerExecProcess = Factory.startProcessWithRemove(applicationRuntime);
            if (dockerExecProcess == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerExecProcess$Factory", "startProcessWithRemove"));
            }
            return dockerExecProcess;
        }

        @NotNull
        public static DockerExecProcess startProcessWithRemove(@NotNull RemoteDockerApplicationRuntime applicationRuntime) throws ServerRuntimeException, RemoteSdkException {
            if (applicationRuntime == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationRuntime", "com/intellij/docker/remote/run/runtime/DockerExecProcess$Factory", "startProcessWithRemove"));
            }
            applicationRuntime.startAndAttach();
            DockerExecProcess dockerExecProcess = Factory.newProcess(applicationRuntime, true);
            if (dockerExecProcess == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerExecProcess$Factory", "startProcessWithRemove"));
            }
            return dockerExecProcess;
        }

        @NotNull
        public static DockerExecProcess newProcess(@NotNull RemoteDockerApplicationRuntime applicationRuntime, boolean removeContainer) throws RemoteSdkException {
            if (applicationRuntime == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationRuntime", "com/intellij/docker/remote/run/runtime/DockerExecProcess$Factory", "newProcess"));
            }
            DockerCloudConfiguration account = applicationRuntime.getDockerRuntime().getAccount();
            String dockerHost = DockerUtil.getDockerHost(account);
            String machineName = account.getMachine();
            if (StringUtil.isNotEmpty((String)machineName)) {
                DockerMachineExecProcess dockerMachineExecProcess = new DockerMachineExecProcess(applicationRuntime, dockerHost, removeContainer);
                if (dockerMachineExecProcess == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerExecProcess$Factory", "newProcess"));
                }
                return dockerMachineExecProcess;
            }
            DockerExecProcess dockerExecProcess = new DockerExecProcess(applicationRuntime, dockerHost, removeContainer);
            if (dockerExecProcess == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/DockerExecProcess$Factory", "newProcess"));
            }
            return dockerExecProcess;
        }
    }
}

