/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.remote.run.runtime.DockerExecProcess;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.Tunnelable;
import com.jetbrains.plugins.remotesdk.transport.SshConnectionManager;
import com.jetbrains.plugins.remotesdk.transport.SshRemoteSession;
import org.jetbrains.annotations.NotNull;

public class DockerMachineExecProcess
extends DockerExecProcess
implements Tunnelable {
    public DockerMachineExecProcess(@NotNull RemoteDockerApplicationRuntime applicationRuntime, @NotNull String dockerHost, boolean removeContainer) {
        if (applicationRuntime == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationRuntime", "com/intellij/docker/remote/run/runtime/DockerMachineExecProcess", "<init>"));
        }
        if (dockerHost == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dockerHost", "com/intellij/docker/remote/run/runtime/DockerMachineExecProcess", "<init>"));
        }
        super(applicationRuntime, dockerHost, removeContainer);
    }

    public void addRemoteTunnel(int remotePort, String host, int localPort) throws RemoteSdkException {
        this.getSshSession().addRemoteTunnel(remotePort, host, localPort);
    }

    public void addLocalTunnel(int localPort, int remotePort) throws RemoteSdkException {
        this.getSshSession().addLocalTunnel(localPort, this.getDockerHost(), remotePort);
    }

    private SshRemoteSession getSshSession() throws RemoteSdkException {
        SshConnectionManager connectionManager = SshConnectionManager.getInstance();
        return connectionManager.getSession(this.getDockerMachineCredentials());
    }

    private RemoteCredentials getDockerMachineCredentials() {
        RemoteCredentialsHolder credentials = new RemoteCredentialsHolder();
        credentials.setHost(this.getDockerHost());
        credentials.setPort(22);
        credentials.setUserName("docker");
        credentials.setPassword("tcuser");
        return credentials;
    }
}

