/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InputStreamConsumer
implements Callable<String> {
    @NotNull
    private final CountDownLatch myCountDownLatch;
    @NotNull
    private final InputStream myInputStream;
    @Nullable
    private final ProgressIndicator myProgressIndicator;
    @NotNull
    private final StringBuilder myResultBuilder;

    public InputStreamConsumer(@NotNull InputStream stream, @Nullable ProgressIndicator indicator) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/docker/remote/run/runtime/InputStreamConsumer", "<init>"));
        }
        this.myCountDownLatch = new CountDownLatch(1);
        this.myResultBuilder = new StringBuilder();
        this.myInputStream = stream;
        this.myProgressIndicator = indicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.myInputStream, "UTF-8"));
            String line = reader.readLine();
            boolean firstLine = true;
            while (line != null) {
                if (!firstLine) {
                    this.myResultBuilder.append("\n");
                }
                firstLine = false;
                this.myResultBuilder.append(line);
                this.updateIndicatorText(line);
                line = reader.readLine();
            }
            String string = this.myResultBuilder.toString();
            return string;
        }
        finally {
            this.myCountDownLatch.countDown();
        }
    }

    private void updateIndicatorText(@NotNull CharSequence lastLineRead) {
        if (lastLineRead == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastLineRead", "com/intellij/docker/remote/run/runtime/InputStreamConsumer", "updateIndicatorText"));
        }
        if (StringUtil.isEmpty((CharSequence)lastLineRead) || Character.isWhitespace(lastLineRead.charAt(0))) {
            return;
        }
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.setText2(lastLineRead.toString());
        }
    }

    public String wait4Result() throws IOException {
        try {
            this.myCountDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return this.myResultBuilder.toString();
    }

    @NotNull
    public static InputStreamConsumer consume(@NotNull InputStream stream, @Nullable ProgressIndicator progressIndicator) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/docker/remote/run/runtime/InputStreamConsumer", "consume"));
        }
        InputStreamConsumer consumer = new InputStreamConsumer(stream, progressIndicator);
        ApplicationManager.getApplication().executeOnPooledThread((Callable)consumer);
        InputStreamConsumer inputStreamConsumer = consumer;
        if (inputStreamConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/InputStreamConsumer", "consume"));
        }
        return inputStreamConsumer;
    }
}

