/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote.run.runtime;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerConnector;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerServerRuntimeInstance;
import com.intellij.docker.agent.DockerAgent;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.DockerAgentRepositoryConfig;
import com.intellij.docker.agent.DockerAuthConfig;
import com.intellij.docker.agent.DockerAuthConfigImpl;
import com.intellij.docker.agent.OngoingProcess;
import com.intellij.docker.registry.RegistryRuntimeTask;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.WrappedConflictException;
import com.intellij.docker.remote.run.runtime.WrappedInternalServerErrorException;
import com.intellij.docker.remote.run.runtime.WrappedNotFoundException;
import com.intellij.docker.remote.run.runtime.WrappedNotModifiedException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.impl.runtime.ServerTaskExecutorImpl;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteDockerRuntime {
    private static final Logger LOG = Logger.getInstance((String)("#" + RemoteDockerRuntime.class));
    private static final Map<Pair<DockerCloudConfiguration, Project>, RemoteDockerRuntime> myDockerRuntimeMap = new LinkedHashMap<Pair<DockerCloudConfiguration, Project>, RemoteDockerRuntime>();
    private static final Lock myDockerRuntimeMapLock = new ReentrantLock();
    private final DockerCloudConfiguration myAccount;
    @Nullable
    private final Project myProject;
    private AgentTaskExecutor myAgentTaskExecutor;
    private DockerAgent myDockerAgent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteDockerRuntime create(@NotNull DockerCloudConfiguration config, @Nullable Project project) throws ServerRuntimeException {
        RemoteDockerRuntime dockerRuntime;
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime", "create"));
        }
        myDockerRuntimeMapLock.lock();
        try {
            Pair key = Pair.create((Object)config, (Object)project);
            dockerRuntime = myDockerRuntimeMap.get(key);
            if (dockerRuntime == null) {
                dockerRuntime = new RemoteDockerRuntime(config, project);
                myDockerRuntimeMap.put((Pair<DockerCloudConfiguration, Project>)key, dockerRuntime);
                if (project != null) {
                    Disposer.register((Disposable)project, () -> RemoteDockerRuntime.forgetRuntime((Pair<DockerCloudConfiguration, Project>)key));
                }
            }
        }
        finally {
            myDockerRuntimeMapLock.unlock();
        }
        return dockerRuntime;
    }

    private static void forgetRuntime(Pair<DockerCloudConfiguration, Project> key) {
        myDockerRuntimeMapLock.lock();
        try {
            myDockerRuntimeMap.remove(key);
        }
        finally {
            myDockerRuntimeMapLock.unlock();
        }
    }

    private RemoteDockerRuntime(DockerCloudConfiguration account, @Nullable Project project) throws ServerRuntimeException {
        this.myAccount = account;
        this.myProject = project;
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final Ref errorRef = Ref.create();
        new DockerConnector(account, (ServerTaskExecutor)new ServerTaskExecutorImpl()).connect((ServerConnector.ConnectionCallback)new ServerConnector.ConnectionCallback<DockerDeploymentConfiguration>(){

            public void connected(@NotNull ServerRuntimeInstance<DockerDeploymentConfiguration> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverRuntimeInstance", "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime$1", "connected"));
                }
                DockerServerRuntimeInstance dockerServerRuntimeInstance = (DockerServerRuntimeInstance)serverRuntimeInstance;
                RemoteDockerRuntime.this.myDockerAgent = (DockerAgent)dockerServerRuntimeInstance.getAgent();
                RemoteDockerRuntime.this.myAgentTaskExecutor = dockerServerRuntimeInstance.getDockerAgentTaskExecutor();
                semaphore.up();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime$1", "errorOccurred"));
                }
                errorRef.set((Object)new ServerRuntimeException(errorMessage));
                semaphore.up();
            }
        });
        semaphore.waitFor();
        if (!errorRef.isNull()) {
            throw (ServerRuntimeException)((Object)errorRef.get());
        }
    }

    public <T> T executeAgentTask(Computable<T> computable) throws ServerRuntimeException {
        try {
            return (T)this.myAgentTaskExecutor.execute(computable);
        }
        catch (ServerRuntimeException e) {
            String message = e.getMessage();
            if (message.contains("NotFoundException")) {
                throw new WrappedNotFoundException(message);
            }
            if (message.contains("InternalServerErrorException")) {
                throw new WrappedInternalServerErrorException(message);
            }
            if (message.contains("NotModifiedException")) {
                throw new WrappedNotModifiedException(message);
            }
            if (message.contains("ConflictException")) {
                throw new WrappedConflictException(message);
            }
            throw e;
        }
    }

    public DockerAgent getAgent() {
        return this.myDockerAgent;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public RemoteDockerApplicationRuntime findContainerByName(String containerName) throws ServerRuntimeException {
        return (RemoteDockerApplicationRuntime)this.createName2ContainerMapping().fun((Object)containerName);
    }

    public Function<String, RemoteDockerApplicationRuntime> createName2ContainerMapping() throws ServerRuntimeException {
        DockerAgentApplication[] applications = this.getContainers();
        return containerName -> {
            for (DockerAgentApplication application : applications) {
                if (application.getContainerNames() == null || !Arrays.stream(application.getContainerNames()).anyMatch(n -> n != null && n.startsWith("/" + containerName))) continue;
                return RemoteDockerApplicationRuntime.create(this, application);
            }
            return null;
        };
    }

    public DockerAgentApplication[] getContainers() throws ServerRuntimeException {
        return (DockerAgentApplication[])this.executeAgentTask(() -> this.getAgent().getContainers());
    }

    public DockerAgentApplication[] getImages() throws ServerRuntimeException {
        return this.getImages(null);
    }

    public DockerAgentApplication[] getImages(String label) throws ServerRuntimeException {
        return (DockerAgentApplication[])this.executeAgentTask(() -> this.getAgent().getImages(label));
    }

    public DockerAgentApplication findImageByName(String imageName) throws ServerRuntimeException {
        DockerAgentApplication[] applications;
        for (DockerAgentApplication application : applications = this.getImages()) {
            for (String imageTag : application.getImageRepoTags()) {
                if (!StringUtil.equals((CharSequence)imageTag, (CharSequence)imageName)) continue;
                return application;
            }
        }
        return null;
    }

    public void pullImage(@NotNull String imageName) throws ServerRuntimeException {
        if (imageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageName", "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime", "pullImage"));
        }
        LOG.debug("Pull image {" + imageName + "}");
        try {
            this.doPullImage(imageName);
            LOG.debug("Docker image {" + imageName + "} pulled successfully");
        }
        catch (ServerRuntimeException e) {
            LOG.debug("Failed to pull docker image {" + imageName + "}", (Throwable)e);
            throw e;
        }
    }

    private void doPullImage(final @NotNull String imageName) throws ServerRuntimeException {
        if (imageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageName", "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime", "doPullImage"));
        }
        final DockerAgentRepositoryConfig repositoryConfig = new DockerAgentRepositoryConfig(){

            public DockerAuthConfig getAuthConfig() {
                DockerAuthConfigImpl result = new DockerAuthConfigImpl();
                result.setServerAddress("registry.hub.docker.com");
                return result;
            }

            public String getQualifiedRepository() {
                return imageName;
            }

            public String getQualifiedTag() {
                return null;
            }

            public String getTag() {
                return null;
            }
        };
        new RegistryRuntimeTask(){

            protected OngoingProcess doPerform(DockerAgentProgressCallback progressCallback) {
                return RemoteDockerRuntime.this.getAgent().pullImage(repositoryConfig, progressCallback);
            }
        }.performSync((ServerTaskExecutor)new ServerTaskExecutorImpl(), this.myAgentTaskExecutor, RemoteDockerRuntime.getInitialIndicatorText(imageName));
    }

    @NotNull
    private static String getInitialIndicatorText(@NotNull String imageName) {
        if (imageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "imageName", "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime", "getInitialIndicatorText"));
        }
        String string = "Pulling \"" + imageName + "\" image...";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/remote/run/runtime/RemoteDockerRuntime", "getInitialIndicatorText"));
        }
        return string;
    }

    public DockerCloudConfiguration getAccount() {
        return this.myAccount;
    }
}

