/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.text.SemVer;
import com.jetbrains.nodejs.boilerplate.express.ExpressProjectPeer;
import com.jetbrains.nodejs.boilerplate.express.ExpressProjectSettings;
import com.jetbrains.nodejs.boilerplate.express.ExpressStylesheetEngine;
import com.jetbrains.nodejs.boilerplate.express.ExpressTemplateEngine;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersion;
import com.jetbrains.nodejs.library.NodeJsCoreLibraryConfigurator;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import icons.NodeJSIcons;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressProjectGenerator
extends WebProjectTemplate<ExpressProjectSettings> {
    private static final Logger LOG = Logger.getInstance(ExpressProjectGenerator.class);
    private static final String EXPRESS_GENERATOR_PKG_NAME = "express-generator";

    @NotNull
    @Nls
    public String getName() {
        if ("Node.js Express App" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "getName"));
        }
        return "Node.js Express App";
    }

    public String getDescription() {
        return "<html>Express.js application skeleton from <a href='http://expressjs.com'>http://expressjs.com</a></html>";
    }

    public Icon getIcon() {
        return NodeJSIcons.Nodejs_16;
    }

    @Nullable
    public String getHelpId() {
        return "create.from.express-js.skeleton";
    }

    public boolean postponeValidation() {
        return false;
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull ExpressProjectSettings settings, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "generateProject"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "generateProject"));
        }
        try {
            File projectDir = new File(baseDir.getPath());
            TmpData tmpData = ExpressProjectGenerator.installExpressGeneratorPackage(project, settings);
            ExpressProjectGenerator.generateExpressApp(project, projectDir, tmpData, settings);
            ExpressProjectGenerator.installDependencies(project, projectDir, settings);
            ExpressProjectGenerator.promptNodeCoreSourcesConfiguration(project, settings.getInterpreter());
            RefreshQueue.getInstance().refresh(true, true, () -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$generateProject$1"));
                }
                if (baseDir == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$generateProject$1"));
                }
                if (project.isDisposed()) {
                    return;
                }
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$null$0"));
                    }
                    if (baseDir == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$null$0"));
                    }
                    ExpressProjectGenerator.createRunConfiguration(project, baseDir);
                });
            }, ManagingFS.getInstance().getRoots((NewVirtualFileSystem)LocalFileSystem.getInstance()));
            if (!FileUtil.delete((File)tmpData.getRootDir())) {
                LOG.warn("Cannot delete " + tmpData.getRootDir());
            } else {
                LOG.info("Successfully deleted " + tmpData.getRootDir());
            }
        }
        catch (GeneratorException e) {
            LOG.warn((Throwable)e);
            ExpressProjectGenerator.showErrorMessage(project, e.getMessage());
        }
    }

    private static void promptNodeCoreSourcesConfiguration(@NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "promptNodeCoreSourcesConfiguration"));
        }
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "promptNodeCoreSourcesConfiguration"));
        }
        NodeJsInterpreterManager.getInstance((Project)project).setDefault((NodeJsInterpreter)interpreter);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (interpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$promptNodeCoreSourcesConfiguration$3"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$promptNodeCoreSourcesConfiguration$3"));
            }
            interpreter.provideCachedVersionOrFetch(version -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$null$2"));
                }
                if (interpreter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$null$2"));
                }
                if (version != null) {
                    NodeJsCoreLibraryConfigurator configurator = NodeJsCoreLibraryConfigurator.getInstance(project);
                    configurator.configureAndAssociateWithProject((NodeJsInterpreter)interpreter, (SemVer)version, null);
                }
            });
        });
    }

    private static void createRunConfiguration(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "createRunConfiguration"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "createRunConfiguration"));
        }
        Ref appFileRef = Ref.create();
        String name = FileUtil.toSystemDependentName((String)"bin/www");
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$createRunConfiguration$4"));
            }
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$createRunConfiguration$4"));
            }
            RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)project);
            for (RunConfiguration configuration : runManager.getAllConfigurationsList()) {
                if (!name.equals(configuration.getName())) continue;
                return;
            }
            appFileRef.set((Object)VfsUtil.findRelativeFile((VirtualFile)baseDir, (String[])new String[]{"bin", "www"}));
        });
        if (appFileRef.isNull()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$createRunConfiguration$5"));
            }
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$createRunConfiguration$5"));
            }
            ConfigurationFactory configurationFactory = NodeJsRunConfigurationType.getInstance().getFactory();
            RunnerAndConfigurationSettings rac = RunManager.getInstance((Project)project).createRunConfiguration("", configurationFactory);
            NodeJsRunConfiguration runConfig = (NodeJsRunConfiguration)((Object)((Object)ObjectUtils.tryCast((Object)rac.getConfiguration(), NodeJsRunConfiguration.class)));
            if (runConfig == null) {
                return;
            }
            VirtualFile appFile = (VirtualFile)appFileRef.get();
            runConfig.setName(name);
            runConfig.setWorkingDirectory(baseDir.getPath());
            runConfig.setInputPath(VfsUtilCore.getRelativePath((VirtualFile)appFile, (VirtualFile)baseDir, (char)File.separatorChar));
            LinkedHashMap env = new LinkedHashMap();
            env.putAll(runConfig.getEnvs());
            env.put("DEBUG", baseDir.getName() + ":*");
            runConfig.setEnvs((Map<String, String>)env);
            StartBrowserSettings browserSettings = new StartBrowserSettings();
            browserSettings.setUrl("http://localhost:3000/");
            runConfig.setStartBrowserSettings(browserSettings);
            RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)project);
            runManager.addConfiguration(rac, true);
            runManager.setSelectedConfiguration(rac);
        });
    }

    @NotNull
    public WebProjectGenerator.GeneratorPeer<ExpressProjectSettings> createPeer() {
        ExpressProjectPeer expressProjectPeer = new ExpressProjectPeer();
        if (expressProjectPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "createPeer"));
        }
        return expressProjectPeer;
    }

    public boolean isPrimaryGenerator() {
        return PlatformUtils.isWebStorm();
    }

    private static void showErrorMessage(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "showErrorMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "showErrorMessage"));
        }
        String fullMessage = "Cannot create Node.js Express App: " + message;
        String title = "Create Express Project";
        Messages.showErrorDialog((Project)project, (String)fullMessage, (String)title);
        Notifications.Bus.notify((Notification)new Notification("Express Project Generator", title, fullMessage, NotificationType.ERROR));
    }

    @NotNull
    private static TmpData installExpressGeneratorPackage(@NotNull Project project, @NotNull ExpressProjectSettings settings) throws GeneratorException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "installExpressGeneratorPackage"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "installExpressGeneratorPackage"));
        }
        TmpData tmpData = new TmpData();
        try {
            GeneralCommandLine commandLine = NodeCommandLineUtil.createNpmCommandLine((File)tmpData.getRootDir(), (NodeJsLocalInterpreter)settings.getInterpreter(), (List)ContainerUtil.list((Object[])new String[]{NodeCommandLineUtil.getInstallPackageCommand((NodeJsLocalInterpreter)settings.getInterpreter()), "express-generator@" + settings.getExpressGeneratorVersion().getRawVersion()}));
            ExpressProjectGenerator.executeCommandLine(project, commandLine, true);
        }
        catch (ExecutionException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
        TmpData tmpData2 = tmpData;
        if (tmpData2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "installExpressGeneratorPackage"));
        }
        return tmpData2;
    }

    private static void generateExpressApp(@NotNull Project project, @NotNull File projectDir, @NotNull TmpData tmpData, @NotNull ExpressProjectSettings settings) throws GeneratorException {
        String binJsFile;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "generateExpressApp"));
        }
        if (projectDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDir", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "generateExpressApp"));
        }
        if (tmpData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tmpData", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "generateExpressApp"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "generateExpressApp"));
        }
        File expressGeneratorPackageDir = new File(tmpData.getNodeModulesDir(), EXPRESS_GENERATOR_PKG_NAME);
        File expressGeneratorMainFile = new File(expressGeneratorPackageDir, binJsFile = ExpressProjectGenerator.findBinJsFileForExpressGenerator(settings.getExpressGeneratorVersion()));
        if (!expressGeneratorMainFile.isFile()) {
            throw new GeneratorException("Cannot find " + expressGeneratorMainFile.getAbsolutePath());
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setWorkDirectory(projectDir);
        commandLine.setExePath(settings.getInterpreter().getInterpreterSystemDependentPath());
        commandLine.addParameter(expressGeneratorMainFile.getAbsolutePath());
        ExpressProjectGenerator.addExpressParams(commandLine, settings);
        ExpressProjectGenerator.executeCommandLine(project, commandLine, true);
    }

    @NotNull
    private static String findBinJsFileForExpressGenerator(@NotNull NodePackageVersion version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "findBinJsFileForExpressGenerator"));
        }
        SemVer semVer = SemVer.parseFromText((String)version.getRawVersion());
        if (semVer != null && (semVer.getMajor() < 4 || semVer.getMajor() == 4 && semVer.getMinor() < 15)) {
            String string = "bin" + File.separator + "express";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "findBinJsFileForExpressGenerator"));
            }
            return string;
        }
        String string = "bin" + File.separator + "express-cli.js";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "findBinJsFileForExpressGenerator"));
        }
        return string;
    }

    private static void addExpressParams(@NotNull GeneralCommandLine commandLine, @NotNull ExpressProjectSettings settings) {
        ExpressTemplateEngine templateEngine;
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "addExpressParams"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "addExpressParams"));
        }
        commandLine.addParameter("--force");
        ExpressStylesheetEngine stylesheetEngine = settings.getStylesheetEngine();
        if (stylesheetEngine != ExpressStylesheetEngine.PLAIN_CSS) {
            commandLine.addParameter("--css");
            String option = stylesheetEngine.getCmdLineOption();
            if (option == null) {
                throw new RuntimeException("No command line option defined for " + stylesheetEngine.name());
            }
            commandLine.addParameter(option);
        }
        if ((templateEngine = settings.getTemplateEngine()) != ExpressTemplateEngine.JADE) {
            if (templateEngine == ExpressTemplateEngine.EJS) {
                commandLine.addParameter("--ejs");
            } else if (templateEngine == ExpressTemplateEngine.HBS) {
                commandLine.addParameter("--hbs");
            } else if (templateEngine == ExpressTemplateEngine.HOGAN) {
                commandLine.addParameter("--hogan");
            } else {
                throw new RuntimeException("Unexpected template option: " + templateEngine);
            }
        }
    }

    private static void installDependencies(@NotNull Project project, @NotNull File projectDir, @NotNull ExpressProjectSettings settings) throws GeneratorException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "installDependencies"));
        }
        if (projectDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDir", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "installDependencies"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "installDependencies"));
        }
        try {
            GeneralCommandLine commandLine = NodeCommandLineUtil.createNpmCommandLine((File)projectDir, (NodeJsLocalInterpreter)settings.getInterpreter(), (List)ContainerUtil.list((Object[])new String[]{"install"}));
            ExpressProjectGenerator.executeCommandLine(project, commandLine, false);
        }
        catch (ExecutionException e) {
            throw new GeneratorException(e.getMessage(), e);
        }
    }

    private static void executeCommandLine(@NotNull Project project, @NotNull GeneralCommandLine commandLine, boolean logStdStreams) throws GeneratorException {
        GeneratorException exception;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "executeCommandLine"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "executeCommandLine"));
        }
        LOG.info("Running '" + commandLine.getCommandLineString() + "' in " + commandLine.getWorkDirectory());
        Ref exceptionRef = Ref.create(null);
        boolean success = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProcessOutput output;
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator", "lambda$executeCommandLine$6"));
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setText(commandLine.getCommandLineString());
            try {
                output = NodeCommandLineUtil.execute((GeneralCommandLine)commandLine, (ProgressIndicator)indicator, (long)TimeUnit.DAYS.toMillis(1L));
            }
            catch (ExecutionException e) {
                exceptionRef.set((Object)new GeneratorException("Cannot execute " + commandLine.getCommandLineString(), e));
                return;
            }
            if (logStdStreams) {
                LOG.info("stdout: " + output.getStdout().trim());
                LOG.info("stderr: " + output.getStderr().trim());
            }
            String errorMessage = null;
            if (output.isTimeout()) {
                errorMessage = "Time limit exceeded for command:\n" + commandLine.getCommandLineString();
            }
            if (output.getExitCode() != 0) {
                errorMessage = "Failed command:\n" + commandLine.getCommandLineString() + "\nExit code: " + output.getExitCode();
            }
            if (errorMessage != null) {
                if (!output.getStdout().isEmpty()) {
                    errorMessage = errorMessage + "\nStandard output:\n" + output.getStdout();
                }
                if (!output.getStderr().isEmpty()) {
                    errorMessage = errorMessage + "\nStandard error:\n" + output.getStderr();
                }
                exceptionRef.set((Object)new GeneratorException(errorMessage));
            }
        }, "Express Project Generator", true, project);
        if (!success) {
            exceptionRef.set((Object)new GeneratorException("Interrupted by user"));
        }
        if ((exception = (GeneratorException)exceptionRef.get()) != null) {
            throw exception;
        }
    }

    private static class TmpData {
        private final File myRootDir;
        private File myNodeModulesDir;

        private TmpData() throws GeneratorException {
            try {
                this.myRootDir = FileUtil.createTempDirectory((String)"intellij-express-generator", null, (boolean)false);
            }
            catch (IOException e) {
                throw new GeneratorException("Can't create temporary directory for express-generator installation", e);
            }
            this.myNodeModulesDir = new File(this.myRootDir, "node_modules");
            if (!this.myNodeModulesDir.mkdirs()) {
                throw new GeneratorException("Can not create " + this.myNodeModulesDir.getAbsolutePath() + " directory");
            }
        }

        @NotNull
        public File getRootDir() {
            File file = this.myRootDir;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator$TmpData", "getRootDir"));
            }
            return file;
        }

        @NotNull
        public File getNodeModulesDir() {
            File file = this.myNodeModulesDir;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/ExpressProjectGenerator$TmpData", "getNodeModulesDir"));
            }
            return file;
        }
    }

    static class GeneratorException
    extends Exception {
        GeneratorException(String message) {
            super(message);
        }

        GeneratorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

