/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.google.common.collect.ImmutableList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersion;
import com.jetbrains.nodejs.packages.NodePackageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageVersionList {
    public static final NodePackageVersionList EMPTY = new NodePackageVersionList(Collections.emptyList(), null);
    private final ImmutableList<NodePackageVersion> myVersions;

    private NodePackageVersionList(@NotNull List<String> versions, @Nullable String latestVersion) {
        if (versions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionList", "<init>"));
        }
        ArrayList list = ContainerUtil.newArrayList();
        for (String version : versions) {
            NodePackageVersion expressVersion = NodePackageVersion.createFromRawVersion(version);
            if (expressVersion.getRawVersion().equals(latestVersion)) {
                expressVersion.setSelectedByDefault(true);
            }
            list.add(expressVersion);
        }
        Collections.sort(list);
        this.myVersions = ImmutableList.copyOf((Collection)list);
    }

    @NotNull
    public ImmutableList<NodePackageVersion> getVersionsInDecreasingOrder() {
        ImmutableList<NodePackageVersion> immutableList = this.myVersions;
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionList", "getVersionsInDecreasingOrder"));
        }
        return immutableList;
    }

    @NotNull
    public static NodePackageVersionList create(@NotNull NodePackageInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionList", "create"));
        }
        NodePackageVersionList nodePackageVersionList = new NodePackageVersionList((List<String>)info.getVersions(), info.getLatestVersion());
        if (nodePackageVersionList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionList", "create"));
        }
        return nodePackageVersionList;
    }

    @NotNull
    public static NodePackageVersionList create(@NotNull List<String> versions, @Nullable String latestVersion) {
        if (versions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versions", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionList", "create"));
        }
        NodePackageVersionList nodePackageVersionList = new NodePackageVersionList(versions, latestVersion);
        if (nodePackageVersionList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionList", "create"));
        }
        return nodePackageVersionList;
    }
}

