/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.express;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersion;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionList;
import com.jetbrains.nodejs.boilerplate.express.NodePackageVersionListener;
import com.jetbrains.nodejs.packages.NodePackageInfo;
import com.jetbrains.nodejs.packages.NodePackageUtil;
import com.jetbrains.nodejs.util.ui.UIHelper;
import com.jetbrains.nodejs.util.ui.WithDisplayName;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageVersionView {
    private static final Logger LOG = Logger.getInstance(NodePackageVersionView.class);
    private static final NodePackageVersionList EMPTY_VERSION_LIST = NodePackageVersionList.EMPTY;
    private final String myPackageName;
    private final NodePackageVersionListener myListener;
    private final boolean myCacheOnFs;
    private final ComboBox myComboBox;
    private final JPanel myRefreshPanel;
    private NodeJsLocalInterpreter myLatestInterpreter;
    private Status myCurrentStatus;
    private final Ref<NodePackageVersion> myLastExpressVersionRef;
    private boolean myFirstUpdate;

    public NodePackageVersionView(@NotNull String packageName, @NotNull NodePackageVersionListener listener, boolean cacheOnFs) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "<init>"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "<init>"));
        }
        this.myLastExpressVersionRef = Ref.create(null);
        this.myFirstUpdate = true;
        this.myPackageName = packageName;
        this.myListener = listener;
        this.myCacheOnFs = cacheOnFs;
        this.myComboBox = this.createEmptyComboBox();
        this.myRefreshPanel = new JPanel(new CardLayout(0, 0));
        this.addRefreshCard(Status.READY_TO_REFRESH, this.createRefreshActionComponent());
        this.addRefreshCard(Status.REFRESHING, NodePackageVersionView.createRefreshingComponent(this.myPackageName));
        this.setStatus(Status.READY_TO_REFRESH);
        this.myComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NodePackageVersionView.this.fireSelectedVersionUpdatedEventIfNeeded();
            }
        });
    }

    @NotNull
    private ComboBox createEmptyComboBox() {
        ComboBox comboBox = UIHelper.createCombobox("Unavailable   ", new WithDisplayName(){

            @Override
            public String getDisplayName() {
                if (NodePackageVersionView.this.isLoadingVersions()) {
                    return "Loading...";
                }
                return "Unavailable";
            }
        });
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "createEmptyComboBox"));
        }
        return comboBox;
    }

    private void addRefreshCard(@NotNull Status status, @NotNull Component child) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "addRefreshCard"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "addRefreshCard"));
        }
        this.myRefreshPanel.add(child, status.name());
    }

    @NotNull
    private Component createRefreshActionComponent() {
        AnAction reloadAction = new AnAction("Reload " + this.myPackageName + " versions", null, AllIcons.Actions.Refresh){

            public void actionPerformed(AnActionEvent e) {
                NodeJsLocalInterpreter interpreter = NodePackageVersionView.this.myLatestInterpreter;
                if (interpreter != null) {
                    NodePackageVersionView.this.asyncUpdateVersions(interpreter);
                }
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(NodePackageVersionView.this.myLatestInterpreter != null);
            }
        };
        ActionButton actionButton = new ActionButton(reloadAction, reloadAction.getTemplatePresentation().clone(), "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
        if (actionButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "createRefreshActionComponent"));
        }
        return actionButton;
    }

    @NotNull
    private static Component createRefreshingComponent(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "createRefreshingComponent"));
        }
        AsyncProcessIcon icon = new AsyncProcessIcon(packageName + " versions loading");
        icon.setToolTipText("Updating " + packageName + " package versions");
        AsyncProcessIcon asyncProcessIcon = icon;
        if (asyncProcessIcon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "createRefreshingComponent"));
        }
        return asyncProcessIcon;
    }

    private void fireSelectedVersionUpdatedEventIfNeeded() {
        NodePackageVersion newVersion = this.getVersion();
        NodePackageVersion lastVersion = (NodePackageVersion)this.myLastExpressVersionRef.get();
        if (newVersion == null || !newVersion.equals(lastVersion)) {
            this.myListener.onVersionSelected(newVersion);
            this.myLastExpressVersionRef.set((Object)newVersion);
        }
    }

    public void setInterpreter(@Nullable NodeJsInterpreter interpreter) {
        NodeJsLocalInterpreter localInterpreter = null;
        try {
            localInterpreter = NodeJsLocalInterpreter.castAndValidate((NodeJsInterpreter)interpreter);
            localInterpreter.getValidNpmCliJsFilePath();
            UIUtil.setEnabled((Component)this.myRefreshPanel, (boolean)true, (boolean)true);
            this.doUpdate(localInterpreter);
        }
        catch (ExecutionException e) {
            UIUtil.setEnabled((Component)this.myRefreshPanel, (boolean)false, (boolean)true);
            this.setVersions(EMPTY_VERSION_LIST);
        }
        this.myLatestInterpreter = localInterpreter;
    }

    private void setStatus(@NotNull Status status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "setStatus"));
        }
        CardLayout layout = (CardLayout)this.myRefreshPanel.getLayout();
        layout.show(this.myRefreshPanel, status.name());
        if (this.myCurrentStatus != status) {
            this.myComboBox.repaint();
            this.myCurrentStatus = status;
        }
    }

    boolean isLoadingVersions() {
        return this.myCurrentStatus == Status.REFRESHING;
    }

    @Nullable
    public NodePackageVersion getVersion() {
        return (NodePackageVersion)ObjectUtils.tryCast((Object)this.myComboBox.getSelectedItem(), NodePackageVersion.class);
    }

    @NotNull
    public ComboBox getComboBox() {
        ComboBox comboBox = this.myComboBox;
        if (comboBox == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "getComboBox"));
        }
        return comboBox;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
        panel.add((Component)this.myComboBox);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.myRefreshPanel);
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "getComponent"));
        }
        return jPanel;
    }

    private void doUpdate(@NotNull NodeJsLocalInterpreter interpreter) {
        if (interpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "doUpdate"));
        }
        if (this.myFirstUpdate && this.myCacheOnFs) {
            this.setStatus(Status.REFRESHING);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (interpreter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "lambda$doUpdate$1"));
                }
                NodePackageInfo info = NodePackageUtil.loadCachedPackageInfo(this.myPackageName);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (interpreter == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreter", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "lambda$null$0"));
                    }
                    if (info != null) {
                        NodePackageVersionList versionList = NodePackageVersionList.create(info);
                        this.setVersions(versionList);
                    }
                    this.asyncUpdateVersions(interpreter);
                });
            });
        } else {
            this.asyncUpdateVersions(interpreter);
        }
        this.myFirstUpdate = false;
    }

    private void asyncUpdateVersions(@NotNull NodeJsLocalInterpreter localInterpreter) {
        if (localInterpreter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localInterpreter", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "asyncUpdateVersions"));
        }
        this.setStatus(Status.REFRESHING);
        Runnable task = () -> {
            if (localInterpreter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localInterpreter", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "lambda$asyncUpdateVersions$3"));
            }
            Ref versionListRef = Ref.create((Object)EMPTY_VERSION_LIST);
            try {
                NodePackageInfo info = NodePackageUtil.loadPackageInfo(localInterpreter, this.myPackageName, this.myCacheOnFs);
                if (info != null) {
                    versionListRef.set((Object)NodePackageVersionList.create(info));
                }
            }
            catch (Throwable t) {
                String message = "Cannot load versions of " + this.myPackageName + " package";
                LOG.warn(message, t);
            }
            finally {
                UIUtil.invokeLaterIfNeeded(() -> this.setVersions((NodePackageVersionList)versionListRef.get()));
            }
        };
        ApplicationManager.getApplication().executeOnPooledThread(task);
    }

    private void setVersions(@NotNull NodePackageVersionList versionList) {
        if (versionList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionList", "com/jetbrains/nodejs/boilerplate/express/NodePackageVersionView", "setVersions"));
        }
        ImmutableList<NodePackageVersion> newSortedVersions = versionList.getVersionsInDecreasingOrder();
        NodePackageVersion newSelectedVersion = null;
        for (NodePackageVersion version : newSortedVersions) {
            if (!version.isStable()) continue;
            if (newSelectedVersion == null) {
                newSelectedVersion = version;
            }
            if (!version.isSelectByDefault()) continue;
            newSelectedVersion = version;
            break;
        }
        SwingHelper.updateItems((JComboBox)this.myComboBox, newSortedVersions, newSelectedVersion);
        this.setStatus(Status.READY_TO_REFRESH);
        this.fireSelectedVersionUpdatedEventIfNeeded();
    }

    private static enum Status {
        READY_TO_REFRESH,
        REFRESHING;

    }
}

